/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.actions.CloseUnrelatedProjectsAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.ui.actions.OpenProjectAction;

public class ProjectActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private OpenProjectAction fOpenAction;
    private CloseResourceAction fCloseAction;
    private CloseResourceAction fCloseUnrelatedAction;
    private ISelectionChangedListener fSelectionChangedListener;
    private int CLOSED_PROJECTS_SELECTED = 1;
    private int NON_PROJECT_SELECTED = 2;
    static /* synthetic */ Class class$0;

    public ProjectActionGroup(IViewPart iViewPart) {
        IStructuredSelection iStructuredSelection;
        this.fSite = iViewPart.getSite();
        Shell shell = this.fSite.getShell();
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        ISelection iSelection = iSelectionProvider.getSelection();
        this.fCloseAction = new CloseResourceAction(shell);
        this.fCloseAction.setActionDefinitionId("org.eclipse.ui.project.closeProject");
        this.fCloseUnrelatedAction = new CloseUnrelatedProjectsAction(shell);
        this.fCloseUnrelatedAction.setActionDefinitionId("org.eclipse.ui.project.closeUnrelatedProjects");
        this.fOpenAction = new OpenProjectAction(this.fSite);
        this.fOpenAction.setActionDefinitionId("org.eclipse.ui.project.openProject");
        if (iSelection instanceof IStructuredSelection) {
            iStructuredSelection = (IStructuredSelection)iSelection;
            this.fOpenAction.selectionChanged(iStructuredSelection);
            this.fCloseAction.selectionChanged(iStructuredSelection);
            this.fCloseUnrelatedAction.selectionChanged(iStructuredSelection);
        }
        this.fSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ISelection iSelection = selectionChangedEvent.getSelection();
                if (iSelection instanceof IStructuredSelection) {
                    ProjectActionGroup.this.performSelectionChanged((IStructuredSelection)iSelection);
                }
            }
        };
        iSelectionProvider.addSelectionChangedListener(this.fSelectionChangedListener);
        iStructuredSelection = ResourcesPlugin.getWorkspace();
        iStructuredSelection.addResourceChangeListener((IResourceChangeListener)this.fOpenAction);
        iStructuredSelection.addResourceChangeListener((IResourceChangeListener)this.fCloseAction);
        iStructuredSelection.addResourceChangeListener((IResourceChangeListener)this.fCloseUnrelatedAction);
    }

    protected void performSelectionChanged(IStructuredSelection iStructuredSelection) {
        Object[] objectArray = iStructuredSelection.toArray();
        ArrayList arrayList = new ArrayList();
        int n = this.evaluateSelection(objectArray, arrayList);
        StructuredSelection structuredSelection = new StructuredSelection(arrayList);
        this.fOpenAction.setEnabled(n == this.CLOSED_PROJECTS_SELECTED || n == 0 && this.hasClosedProjectsInWorkspace());
        this.fCloseAction.selectionChanged((IStructuredSelection)structuredSelection);
        this.fCloseUnrelatedAction.selectionChanged((IStructuredSelection)structuredSelection);
    }

    private int evaluateSelection(Object[] objectArray, List list) {
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            Object object = objectArray[n2];
            if (object instanceof IJavaProject) {
                object = ((IJavaProject)object).getProject();
            }
            if (object instanceof IProject) {
                IProject iProject = (IProject)object;
                if (iProject.isOpen()) {
                    list.add(iProject);
                } else {
                    n |= this.CLOSED_PROJECTS_SELECTED;
                }
            } else if (object instanceof IWorkingSet) {
                int n3 = this.evaluateSelection(((IWorkingSet)object).getElements(), list);
                n |= n3;
            } else {
                n |= this.NON_PROJECT_SELECTED;
            }
            ++n2;
        }
        return n;
    }

    private boolean hasClosedProjectsInWorkspace() {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            if (!iProjectArray[n].isOpen()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        iActionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), (IAction)this.fCloseAction);
        iActionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_UNRELATED_PROJECTS.getId(), (IAction)this.fCloseUnrelatedAction);
        iActionBars.setGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId(), (IAction)this.fOpenAction);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        if (this.fOpenAction.isEnabled()) {
            iMenuManager.appendToGroup("group.build", (IAction)this.fOpenAction);
        }
        if (this.fCloseAction.isEnabled()) {
            iMenuManager.appendToGroup("group.build", (IAction)this.fCloseAction);
        }
        if (this.fCloseUnrelatedAction.isEnabled() && this.areOnlyProjectsSelected(this.fCloseUnrelatedAction.getStructuredSelection())) {
            iMenuManager.appendToGroup("group.build", (IAction)this.fCloseUnrelatedAction);
        }
    }

    public OpenProjectAction getOpenProjectAction() {
        return this.fOpenAction;
    }

    private boolean areOnlyProjectsSelected(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty()) {
            return false;
        }
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof IAdaptable)) continue;
            IAdaptable iAdaptable = (IAdaptable)e;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (iAdaptable.getAdapter((Class)clazz) != null) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        iSelectionProvider.removeSelectionChangedListener(this.fSelectionChangedListener);
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        iWorkspace.removeResourceChangeListener((IResourceChangeListener)this.fOpenAction);
        iWorkspace.removeResourceChangeListener((IResourceChangeListener)this.fCloseAction);
        iWorkspace.removeResourceChangeListener((IResourceChangeListener)this.fCloseUnrelatedAction);
        super.dispose();
    }
}

