/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;

public abstract class SelectionDispatchAction
extends Action
implements ISelectionChangedListener {
    private IWorkbenchSite fSite;
    private ISelectionProvider fSpecialSelectionProvider;

    protected SelectionDispatchAction(IWorkbenchSite iWorkbenchSite) {
        Assert.isNotNull((Object)iWorkbenchSite);
        this.fSite = iWorkbenchSite;
    }

    protected SelectionDispatchAction(IWorkbenchSite iWorkbenchSite, ISelectionProvider iSelectionProvider) {
        this(iWorkbenchSite);
        this.setSpecialSelectionProvider(iSelectionProvider);
    }

    public IWorkbenchSite getSite() {
        return this.fSite;
    }

    public ISelection getSelection() {
        ISelectionProvider iSelectionProvider = this.getSelectionProvider();
        if (iSelectionProvider != null) {
            return iSelectionProvider.getSelection();
        }
        return null;
    }

    public Shell getShell() {
        return this.fSite.getShell();
    }

    public ISelectionProvider getSelectionProvider() {
        if (this.fSpecialSelectionProvider != null) {
            return this.fSpecialSelectionProvider;
        }
        return this.fSite.getSelectionProvider();
    }

    public void setSpecialSelectionProvider(ISelectionProvider iSelectionProvider) {
        this.fSpecialSelectionProvider = iSelectionProvider;
    }

    public void update(ISelection iSelection) {
        this.dispatchSelectionChanged(iSelection);
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.selectionChanged((ISelection)iStructuredSelection);
    }

    public void run(IStructuredSelection iStructuredSelection) {
        this.run((ISelection)iStructuredSelection);
    }

    public void selectionChanged(JavaTextSelection javaTextSelection) {
        this.selectionChanged((ITextSelection)javaTextSelection);
    }

    public void run(JavaTextSelection javaTextSelection) {
        this.run((ITextSelection)javaTextSelection);
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        this.selectionChanged((ISelection)iTextSelection);
    }

    public void run(ITextSelection iTextSelection) {
        this.run((ISelection)iTextSelection);
    }

    public void selectionChanged(ISelection iSelection) {
        this.setEnabled(false);
    }

    public void run(ISelection iSelection) {
    }

    public void run() {
        this.dispatchRun(this.getSelection());
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.dispatchSelectionChanged(selectionChangedEvent.getSelection());
    }

    private void dispatchSelectionChanged(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            this.selectionChanged((IStructuredSelection)iSelection);
        } else if (iSelection instanceof JavaTextSelection) {
            this.selectionChanged((JavaTextSelection)iSelection);
        } else if (iSelection instanceof ITextSelection) {
            this.selectionChanged((ITextSelection)iSelection);
        } else {
            this.selectionChanged(iSelection);
        }
    }

    private void dispatchRun(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            this.run((IStructuredSelection)iSelection);
        } else if (iSelection instanceof JavaTextSelection) {
            this.run((JavaTextSelection)iSelection);
        } else if (iSelection instanceof ITextSelection) {
            this.run((ITextSelection)iSelection);
        } else {
            this.run(iSelection);
        }
    }
}

