/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.debug.ui;

import java.util.Map;
import org.eclipse.atf.mozilla.ide.debug.model.JSLineBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.debug.ui.JDIDebugUIPlugin;

public class BreakpointUtils {
    private static final String HANDLE_ID = String.valueOf(JDIDebugUIPlugin.getUniqueIdentifier()) + ".JAVA_ELEMENT_HANDLE_ID";
    private static final String RUN_TO_LINE = String.valueOf(JDIDebugUIPlugin.getUniqueIdentifier()) + ".run_to_line";
    private static final String MEMBER_START = String.valueOf(JDIDebugUIPlugin.getUniqueIdentifier()) + ".member_start";
    private static final String MEMBER_END = String.valueOf(JDIDebugUIPlugin.getUniqueIdentifier()) + ".member_end";
    static /* synthetic */ Class class$0;

    public static IResource getBreakpointResource(IJavaElement iJavaElement) {
        IResource iResource;
        ICompilationUnit iCompilationUnit = null;
        if (iJavaElement instanceof IMember) {
            iCompilationUnit = ((IMember)iJavaElement).getCompilationUnit();
        } else if (iJavaElement instanceof ICompilationUnit) {
            iCompilationUnit = (ICompilationUnit)iJavaElement;
        }
        if (iCompilationUnit != null && iCompilationUnit.isWorkingCopy()) {
            iJavaElement = iJavaElement.getPrimaryElement();
        }
        if ((iResource = iJavaElement.getResource()) == null) {
            iResource = ResourcesPlugin.getWorkspace().getRoot();
        } else if (!iResource.getProject().exists()) {
            iResource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return iResource;
    }

    public static void addJavaBreakpointAttributes(Map map, IJavaElement iJavaElement) {
        String string = iJavaElement.getHandleIdentifier();
        map.put(HANDLE_ID, string);
        JavaCore.addJavaElementMarkerAttributes((Map)map, (IJavaElement)iJavaElement);
    }

    public static void addJavaBreakpointAttributesWithMemberDetails(Map map, IJavaElement iJavaElement, int n, int n2) {
        BreakpointUtils.addJavaBreakpointAttributes(map, iJavaElement);
        map.put(MEMBER_START, new Integer(n));
        map.put(MEMBER_END, new Integer(n2));
    }

    public static void addRunToLineAttributes(Map map) {
        map.put("org.eclipse.debug.core.persisted", Boolean.FALSE);
        map.put(RUN_TO_LINE, Boolean.TRUE);
    }

    public static boolean isRunToLineBreakpoint(JSLineBreakpoint jSLineBreakpoint) {
        return jSLineBreakpoint.getMarker().getAttribute(RUN_TO_LINE, false);
    }

    public static boolean doesBreakpointExist(IResource iResource, int n) {
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints();
        int n2 = 0;
        while (n2 < iBreakpointArray.length) {
            if (iBreakpointArray[n2] instanceof JSLineBreakpoint) {
                JSLineBreakpoint jSLineBreakpoint = (JSLineBreakpoint)iBreakpointArray[n2];
                try {
                    if (jSLineBreakpoint.getMarker().getResource().equals((Object)iResource) && jSLineBreakpoint.getLineNumber() == n) {
                        return true;
                    }
                }
                catch (CoreException coreException) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static JSLineBreakpoint lineBreakpointExists(IResource iResource, String string, int n) {
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints();
        int n2 = 0;
        while (n2 < iBreakpointArray.length) {
            if (iBreakpointArray[n2] instanceof JSLineBreakpoint) {
                JSLineBreakpoint jSLineBreakpoint = (JSLineBreakpoint)iBreakpointArray[n2];
                try {
                    if (jSLineBreakpoint.getMarker().getResource().equals((Object)iResource) && jSLineBreakpoint.getLineNumber() == n) {
                        return jSLineBreakpoint;
                    }
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            ++n2;
        }
        return null;
    }

    public static JSLineBreakpoint createLineBreakpoint(IDocument iDocument, IEditorInput iEditorInput, int n, int n2, int n3, int n4, boolean bl, Map map) {
        IResource iResource;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iResource = (IResource)iEditorInput.getAdapter((Class)clazz)) == null) {
            iResource = ResourcesPlugin.getWorkspace().getRoot();
        }
        if (iResource != null && iEditorInput instanceof IFileEditorInput) {
            return new JSLineBreakpoint(iResource, n, -1, -1, bl, map);
        }
        if (iEditorInput instanceof IStorageEditorInput) {
            iResource = ResourcesPlugin.getWorkspace().getRoot();
            String string = iEditorInput.getName();
            map.put("org.eclipse.wst.sse.ui.extensions.breakpoint.path", string);
            return new JSLineBreakpoint(iResource, n, -1, -1, bl, map);
        }
        return null;
    }
}

