/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.debug.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.atf.mozilla.ide.debug.model.JSLineBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.wst.jsdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.wst.jsdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.wst.jsdt.ui.IWorkingCopyManager;
import org.eclipse.wst.jsdt.ui.JavaUI;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTargetExtension {
    private static final String EMPTY_STRING = "";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    protected void report(final String string, final IWorkbenchPart iWorkbenchPart) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IEditorStatusLine iEditorStatusLine;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iEditorStatusLine = (IEditorStatusLine)iWorkbenchPart.getAdapter((Class)clazz)) != null) {
                    if (string != null) {
                        iEditorStatusLine.setMessage(true, string, null);
                    } else {
                        iEditorStatusLine.setMessage(true, null, null);
                    }
                }
                if (string != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    JDIDebugUIPlugin.getActiveWorkbenchShell().getDisplay().beep();
                }
            }
        });
    }

    public void toggleLineBreakpoints(IWorkbenchPart iWorkbenchPart, ISelection iSelection) throws CoreException {
        this.toggleLineBreakpoints(iWorkbenchPart, iSelection, false);
    }

    public void toggleLineBreakpoints(final IWorkbenchPart iWorkbenchPart, final ISelection iSelection, boolean bl) {
        Job job = new Job("Toggle Line Breakpoint"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                ITextEditor iTextEditor = ToggleBreakpointAdapter.this.getTextEditor(iWorkbenchPart);
                if (iTextEditor != null && iSelection instanceof ITextSelection) {
                    if (iProgressMonitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        IDocument iDocument;
                        HashMap hashMap;
                        int n;
                        ToggleBreakpointAdapter.this.report(null, iWorkbenchPart);
                        ISelection iSelection2 = iSelection;
                        if (!(iSelection instanceof IStructuredSelection)) {
                            iSelection2 = ToggleBreakpointAdapter.this.translateToMembers(iWorkbenchPart, iSelection);
                        }
                        if (iSelection2 instanceof IStructuredSelection) {
                            IJavaElement iJavaElement = (IJavaElement)((IStructuredSelection)iSelection2).getFirstElement();
                            String string = ToggleBreakpointAdapter.this.createQualifiedTypeName(iJavaElement);
                            IResource iResource = BreakpointUtils.getBreakpointResource(iJavaElement);
                            JSLineBreakpoint jSLineBreakpoint = BreakpointUtils.lineBreakpointExists(iResource, string, n = ((ITextSelection)iSelection).getStartLine() + 1);
                            if (jSLineBreakpoint != null) {
                                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)jSLineBreakpoint, true);
                                return Status.OK_STATUS;
                            }
                            hashMap = new HashMap(10);
                            IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
                            if (iDocumentProvider == null) {
                                return Status.CANCEL_STATUS;
                            }
                            iDocument = iDocumentProvider.getDocument((Object)iTextEditor.getEditorInput());
                            try {
                                IRegion iRegion = iDocument.getLineInformation(n - 1);
                                int n2 = iRegion.getOffset();
                                int n3 = n2 + iRegion.getLength() - 1;
                                BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(hashMap, iJavaElement, n2, n3);
                            }
                            catch (BadLocationException badLocationException) {
                                JDIDebugUIPlugin.log(badLocationException);
                            }
                        } else {
                            ToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_3, iWorkbenchPart);
                            return Status.OK_STATUS;
                        }
                        BreakpointUtils.createLineBreakpoint(iDocument, iTextEditor.getEditorInput(), n, -1, -1, 0, true, hashMap);
                    }
                    catch (CoreException coreException) {
                        return coreException.getStatus();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (this.isRemote(iWorkbenchPart, iSelection)) {
            return false;
        }
        return iSelection instanceof ITextSelection;
    }

    private String createQualifiedTypeName(IJavaElement iJavaElement) {
        ITypeRoot iTypeRoot = iJavaElement instanceof IMember ? ((IMember)iJavaElement).getTypeRoot() : (ITypeRoot)iJavaElement;
        String string = iTypeRoot.getElementName();
        iJavaElement.getJavaProject().exists();
        return string;
    }

    private IJavaElement getJavaElement(IEditorInput iEditorInput) {
        IJavaElement iJavaElement = JavaUI.getEditorInputJavaElement((IEditorInput)iEditorInput);
        if (iJavaElement != null) {
            return iJavaElement;
        }
        return ((WorkingCopyManager)JavaUI.getWorkingCopyManager()).getWorkingCopy(iEditorInput, false);
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (this.isRemote(iWorkbenchPart, iSelection)) {
            return false;
        }
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            return this.getMethods(iStructuredSelection).length > 0;
        }
        return iSelection instanceof ITextSelection && this.isMethod((ITextSelection)iSelection, iWorkbenchPart);
    }

    protected boolean isRemote(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        IStructuredSelection iStructuredSelection;
        Object object;
        if (iSelection instanceof IStructuredSelection && (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) instanceof IMember) {
            IMember iMember = (IMember)object;
            return !iMember.getJavaProject().getProject().exists();
        }
        iStructuredSelection = this.getTextEditor(iWorkbenchPart);
        if (iStructuredSelection != null) {
            object = iStructuredSelection.getEditorInput();
            Object object2 = Platform.getAdapterManager().getAdapter(object, "org.eclipse.team.core.history.IFileRevision");
            return object2 != null;
        }
        return false;
    }

    protected ITextEditor getTextEditor(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof ITextEditor) {
            return (ITextEditor)iWorkbenchPart;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ITextEditor)iWorkbenchPart.getAdapter((Class)clazz);
    }

    protected IMethod[] getMethods(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty()) {
            return new IMethod[0];
        }
        ArrayList<IMethod> arrayList = new ArrayList<IMethod>(iStructuredSelection.size());
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            try {
                IMethod iMethod;
                if (!(e instanceof IMethod) || Flags.isAbstract((int)(iMethod = (IMethod)e).getFlags())) continue;
                arrayList.add(iMethod);
            }
            catch (JavaModelException javaModelException) {}
        }
        return arrayList.toArray(new IMethod[arrayList.size()]);
    }

    private boolean isMethod(ITextSelection iTextSelection, IWorkbenchPart iWorkbenchPart) {
        IJavaElement iJavaElement;
        ITextEditor iTextEditor = this.getTextEditor(iWorkbenchPart);
        if (iTextEditor != null && (iJavaElement = this.getJavaElement(iTextEditor.getEditorInput())) != null) {
            try {
                if (iJavaElement instanceof ICompilationUnit) {
                    iJavaElement = ((ICompilationUnit)iJavaElement).getElementAt(iTextSelection.getOffset());
                } else if (iJavaElement instanceof IClassFile) {
                    iJavaElement = ((IClassFile)iJavaElement).getElementAt(iTextSelection.getOffset());
                }
                return iJavaElement != null && iJavaElement.getElementType() == 9;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return false;
    }

    protected List getFields(IStructuredSelection iStructuredSelection) throws CoreException {
        if (iStructuredSelection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList(iStructuredSelection.size());
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof IField)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    private boolean isInterface(ISelection iSelection, IWorkbenchPart iWorkbenchPart) {
        return false;
    }

    private boolean isField(ITextSelection iTextSelection, IWorkbenchPart iWorkbenchPart) {
        IJavaElement iJavaElement;
        ITextEditor iTextEditor = this.getTextEditor(iWorkbenchPart);
        if (iTextEditor != null && (iJavaElement = this.getJavaElement(iTextEditor.getEditorInput())) != null) {
            try {
                if (iJavaElement instanceof ICompilationUnit) {
                    iJavaElement = ((ICompilationUnit)iJavaElement).getElementAt(iTextSelection.getOffset());
                } else if (iJavaElement instanceof IClassFile) {
                    iJavaElement = ((IClassFile)iJavaElement).getElementAt(iTextSelection.getOffset());
                }
                return iJavaElement != null && iJavaElement.getElementType() == 8;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return false;
    }

    private boolean isFields(IStructuredSelection iStructuredSelection) {
        if (!iStructuredSelection.isEmpty()) {
            try {
                Iterator iterator = iStructuredSelection.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof IField)) continue;
                    int n = ((IField)e).getFlags();
                    return !Flags.isFinal((int)n) & !(Flags.isFinal((int)n) & Flags.isStatic((int)n));
                }
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return false;
    }

    public static String resolveMethodSignature(IType iType, String string) throws JavaModelException {
        String[] stringArray = Signature.getParameterTypes((String)string);
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = ToggleBreakpointAdapter.resolveType(iType, stringArray[n2]);
            if (stringArray2[n2] == null) {
                return null;
            }
            ++n2;
        }
        String string2 = ToggleBreakpointAdapter.resolveType(iType, Signature.getReturnType((String)string));
        if (string2 == null) {
            return null;
        }
        return Signature.createMethodSignature((String[])stringArray2, (String)string2);
    }

    private static String resolveType(IType iType, String string) throws JavaModelException {
        int n = Signature.getArrayCount((String)string);
        String string2 = Signature.getElementType((String)string);
        if (string2.length() == 1) {
            return string;
        }
        String string3 = Signature.toString((String)string2);
        String[][] stringArray = iType.resolveType(string3);
        if (stringArray == null || stringArray.length != 1) {
            ITypeParameter[] iTypeParameterArray = iType.getTypeParameters();
            int n2 = 0;
            while (n2 < iTypeParameterArray.length) {
                ITypeParameter iTypeParameter = iTypeParameterArray[n2];
                if (iTypeParameter.getElementName().equals(string3)) {
                    String[] stringArray2 = iTypeParameter.getBounds();
                    if (stringArray2.length == 0) {
                        return "Ljava/lang/Object;";
                    }
                    String string4 = Signature.createTypeSignature((String)stringArray2[0], (boolean)false);
                    return ToggleBreakpointAdapter.resolveType(iType, string4);
                }
                ++n2;
            }
            return null;
        }
        String[] stringArray3 = stringArray[0];
        stringArray3[1] = stringArray3[1].replace('.', '$');
        String string5 = Signature.toQualifiedName((String[])stringArray3);
        String string6 = EMPTY_STRING;
        if (stringArray3[0].equals(EMPTY_STRING)) {
            string5 = string5.substring(1);
            string6 = Signature.createTypeSignature((String)string5, (boolean)true);
        } else {
            string6 = Signature.createTypeSignature((String)string5, (boolean)true).replace('.', '/');
        }
        return Signature.createArraySignature((String)string6, (int)n);
    }

    protected static IResource getResource(IEditorPart iEditorPart) {
        IResource iResource;
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iResource = (IResource)iEditorInput.getAdapter((Class)clazz)) == null) {
            iResource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return iResource;
    }

    protected IMethod getMethodHandle(IEditorPart iEditorPart, String string, String string2, String string3) throws CoreException {
        Object[] objectArray;
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IJavaElement iJavaElement = (IJavaElement)iEditorInput.getAdapter((Class)clazz);
        IType iType = null;
        if (iJavaElement instanceof ICompilationUnit) {
            objectArray = ((ICompilationUnit)iJavaElement).getAllTypes();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n].getFullyQualifiedName().equals(string)) {
                    iType = objectArray[n];
                    break;
                }
                ++n;
            }
        } else if (iJavaElement instanceof IClassFile) {
            iType = ((IClassFile)iJavaElement).getType();
        }
        if (iType != null) {
            objectArray = Signature.getParameterTypes((String)string3);
            return iType.getMethod(string2, (String[])objectArray);
        }
        return null;
    }

    protected CompilationUnit parseCompilationUnit(ITextEditor iTextEditor) throws CoreException {
        IEditorInput iEditorInput = iTextEditor.getEditorInput();
        IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
        if (iDocumentProvider == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IDocument iDocument = iDocumentProvider.getDocument((Object)iEditorInput);
        ASTParser aSTParser = ASTParser.newParser((int)3);
        aSTParser.setSource(iDocument.get().toCharArray());
        return (CompilationUnit)aSTParser.createAST(null);
    }

    public boolean canToggleWatchpoints(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (this.isRemote(iWorkbenchPart, iSelection)) {
            return false;
        }
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            return this.isFields(iStructuredSelection);
        }
        return iSelection instanceof ITextSelection && this.isField((ITextSelection)iSelection, iWorkbenchPart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISelection translateToMembers(IWorkbenchPart iWorkbenchPart, ISelection iSelection) throws CoreException {
        ITextEditor iTextEditor = this.getTextEditor(iWorkbenchPart);
        if (iTextEditor != null && iSelection instanceof ITextSelection) {
            IClassFile iClassFile;
            Object object;
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            IEditorInput iEditorInput = iTextEditor.getEditorInput();
            IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
            if (iDocumentProvider == null) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            IDocument iDocument = iDocumentProvider.getDocument((Object)iEditorInput);
            int n = iTextSelection.getOffset();
            if (iDocument != null) {
                try {
                    object = iDocument.getLineInformationOfOffset(n);
                    int n2 = object.getOffset() + object.getLength();
                    while (Character.isWhitespace(iDocument.getChar(n)) && n < n2) {
                        ++n;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            object = null;
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.wst.jsdt.core.IClassFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iClassFile = (IClassFile)iEditorInput.getAdapter((Class)clazz)) != null) {
                IJavaElement iJavaElement = iClassFile.getElementAt(n);
                object = iJavaElement instanceof IMember ? (IMember)iJavaElement : iClassFile;
            } else {
                ICompilationUnit iCompilationUnit;
                IWorkingCopyManager iWorkingCopyManager = JavaUI.getWorkingCopyManager();
                ICompilationUnit iCompilationUnit2 = iWorkingCopyManager.getWorkingCopy(iEditorInput);
                if (iCompilationUnit2 != null) {
                    iCompilationUnit = iCompilationUnit2;
                    synchronized (iCompilationUnit) {
                        iCompilationUnit2.reconcile(0, false, null, null);
                    }
                }
                iCompilationUnit2 = ((WorkingCopyManager)JavaUI.getWorkingCopyManager()).getWorkingCopy(iEditorInput, false);
                if (iCompilationUnit2 != null) {
                    iCompilationUnit = iCompilationUnit2;
                    synchronized (iCompilationUnit) {
                        iCompilationUnit2.reconcile(0, false, null, null);
                    }
                }
                iCompilationUnit = iCompilationUnit2.getElementAt(n);
                object = iCompilationUnit instanceof IMember ? (IMember)iCompilationUnit : iCompilationUnit2;
            }
            if (object != null) {
                return new StructuredSelection(object);
            }
        }
        return iSelection;
    }

    public void toggleBreakpoints(IWorkbenchPart iWorkbenchPart, ISelection iSelection) throws CoreException {
        this.toggleLineBreakpoints(iWorkbenchPart, iSelection, true);
    }

    public boolean canToggleBreakpoints(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (this.isRemote(iWorkbenchPart, iSelection)) {
            return false;
        }
        return this.canToggleLineBreakpoints(iWorkbenchPart, iSelection);
    }

    public void toggleMethodBreakpoints(IWorkbenchPart iWorkbenchPart, ISelection iSelection) throws CoreException {
    }

    public void toggleWatchpoints(IWorkbenchPart iWorkbenchPart, ISelection iSelection) throws CoreException {
    }
}

