/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.wst.jsdt.web.core.internal.java.JsTranslation;
import org.eclipse.wst.jsdt.web.ui.internal.contentassist.JSDTCompletionProposal;

public class JSDTProposalCollector
extends CompletionProposalCollector {
    private Comparator fComparator;
    private JsTranslation fTranslation;

    static char[] getTypeTriggers() {
        return CompletionProposalCollector.TYPE_TRIGGERS;
    }

    public JSDTProposalCollector(JsTranslation jsTranslation) {
        super(jsTranslation.getCompilationUnit());
        if (jsTranslation == null) {
            throw new IllegalArgumentException("JSPTranslation cannot be null");
        }
        this.fTranslation = jsTranslation;
    }

    private int calculatePositionAfter(CompletionProposal completionProposal, String string, int n) {
        int n2 = string.length();
        int n3 = completionProposal.getKind();
        if (n3 == 1 || n3 == 7 || n3 == 11 || n3 == 6) {
            String[] stringArray = Signature.getParameterTypes((String)String.valueOf(completionProposal.getSignature()));
            if (string.length() > 0 && stringArray.length > 0) {
                --n2;
            }
        }
        return n2;
    }

    protected IJavaCompletionProposal createJavaCompletionProposal(CompletionProposal completionProposal) {
        JSDTCompletionProposal jSDTCompletionProposal = null;
        if (!completionProposal.isConstructor()) {
            jSDTCompletionProposal = this.createJspProposal(completionProposal);
        }
        return jSDTCompletionProposal;
    }

    private JSDTCompletionProposal createJspProposal(CompletionProposal completionProposal) {
        String string = String.valueOf(completionProposal.getCompletion());
        int n = completionProposal.getReplaceStart();
        int n2 = completionProposal.getReplaceEnd() - n;
        int n3 = this.calculatePositionAfter(completionProposal, string, n);
        IJavaCompletionProposal iJavaCompletionProposal = super.createJavaCompletionProposal(completionProposal);
        completionProposal.getDeclarationSignature();
        Image image = iJavaCompletionProposal.getImage();
        String string2 = iJavaCompletionProposal.getDisplayString();
        string2 = this.getTranslation().fixupMangledName(string2);
        IContextInformation iContextInformation = iJavaCompletionProposal.getContextInformation();
        int n4 = iJavaCompletionProposal.getRelevance();
        boolean bl = true;
        JSDTCompletionProposal jSDTCompletionProposal = new JSDTCompletionProposal(string, n, n2, n3, image, string2, iContextInformation, null, n4, bl);
        jSDTCompletionProposal.setJavaCompletionProposal((ICompletionProposal)iJavaCompletionProposal);
        return jSDTCompletionProposal;
    }

    private Comparator getComparator() {
        if (this.fComparator == null) {
            this.fComparator = new CompletionProposalComparator();
        }
        return this.fComparator;
    }

    public JSDTCompletionProposal[] getJSPCompletionProposals() {
        ArrayList<IJavaCompletionProposal> arrayList = new ArrayList<IJavaCompletionProposal>();
        IJavaCompletionProposal[] iJavaCompletionProposalArray = this.getJavaCompletionProposals();
        int n = 0;
        while (n < iJavaCompletionProposalArray.length) {
            if (iJavaCompletionProposalArray[n] instanceof JSDTCompletionProposal) {
                arrayList.add(iJavaCompletionProposalArray[n]);
            }
            ++n;
        }
        Collections.sort(arrayList, this.getComparator());
        return arrayList.toArray(new JSDTCompletionProposal[arrayList.size()]);
    }

    public JsTranslation getTranslation() {
        return this.fTranslation;
    }
}

