/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;

public class CharacterLiteral
extends Expression {
    public static final SimplePropertyDescriptor ESCAPED_VALUE_PROPERTY;
    private static final List PROPERTY_DESCRIPTORS;
    private String escapedValue = "'X'";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.CharacterLiteral");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ESCAPED_VALUE_PROPERTY = new SimplePropertyDescriptor(clazz2, "escapedValue", clazz, true);
        ArrayList arrayList = new ArrayList(2);
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.CharacterLiteral");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CharacterLiteral.createPropertyList(clazz3, arrayList);
        CharacterLiteral.addProperty(ESCAPED_VALUE_PROPERTY, arrayList);
        PROPERTY_DESCRIPTORS = CharacterLiteral.reapPropertyList(arrayList);
    }

    public static List propertyDescriptors(int n) {
        return PROPERTY_DESCRIPTORS;
    }

    CharacterLiteral(AST aST) {
        super(aST);
    }

    final List internalStructuralPropertiesForType(int n) {
        return CharacterLiteral.propertyDescriptors(n);
    }

    final Object internalGetSetObjectProperty(SimplePropertyDescriptor simplePropertyDescriptor, boolean bl, Object object) {
        if (simplePropertyDescriptor == ESCAPED_VALUE_PROPERTY) {
            if (bl) {
                return this.getEscapedValue();
            }
            this.setEscapedValue((String)object);
            return null;
        }
        return super.internalGetSetObjectProperty(simplePropertyDescriptor, bl, object);
    }

    final int getNodeType0() {
        return 13;
    }

    ASTNode clone0(AST aST) {
        CharacterLiteral characterLiteral = new CharacterLiteral(aST);
        characterLiteral.setSourceRange(this.getStartPosition(), this.getLength());
        characterLiteral.setEscapedValue(this.getEscapedValue());
        return characterLiteral;
    }

    final boolean subtreeMatch0(ASTMatcher aSTMatcher, Object object) {
        return aSTMatcher.match(this, object);
    }

    void accept0(ASTVisitor aSTVisitor) {
        aSTVisitor.visit(this);
        aSTVisitor.endVisit(this);
    }

    public String getEscapedValue() {
        return this.escapedValue;
    }

    public void setEscapedValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Scanner scanner = this.ast.scanner;
        char[] cArray = string.toCharArray();
        scanner.setSource(cArray);
        scanner.resetTo(0, cArray.length);
        try {
            int n = scanner.getNextToken();
            switch (n) {
                case 35: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(ESCAPED_VALUE_PROPERTY);
        this.escapedValue = string;
        this.postValueChange(ESCAPED_VALUE_PROPERTY);
    }

    void internalSetEscapedValue(String string) {
        this.preValueChange(ESCAPED_VALUE_PROPERTY);
        this.escapedValue = string;
        this.postValueChange(ESCAPED_VALUE_PROPERTY);
    }

    public char charValue() {
        Scanner scanner = this.ast.scanner;
        char[] cArray = this.escapedValue.toCharArray();
        scanner.setSource(cArray);
        scanner.resetTo(0, cArray.length);
        int n = scanner.getNextChar();
        int n2 = scanner.getNextChar();
        if (n == -1 || n != 39) {
            throw new IllegalArgumentException("illegal character literal");
        }
        char c = (char)n2;
        char c2 = (char)scanner.getNextChar();
        if (n2 == 92) {
            if (c2 == '\uffffffff') {
                throw new IllegalArgumentException("illegal character literal");
            }
            switch (c2) {
                case 'b': {
                    c = '\b';
                    break;
                }
                case 't': {
                    c = '\t';
                    break;
                }
                case 'n': {
                    c = '\n';
                    break;
                }
                case 'f': {
                    c = '\f';
                    break;
                }
                case 'r': {
                    c = '\r';
                    break;
                }
                case '\"': {
                    c = '\"';
                    break;
                }
                case '\'': {
                    c = '\'';
                    break;
                }
                case '\\': {
                    c = '\\';
                    break;
                }
                default: {
                    try {
                        if (ScannerHelper.isDigit(c2)) {
                            int n3 = ScannerHelper.getNumericValue(c2);
                            c2 = (char)scanner.getNextChar();
                            if (c2 == '\uffffffff') {
                                throw new IllegalArgumentException("illegal character literal");
                            }
                            if (c2 != '\'') {
                                if (!ScannerHelper.isDigit(c2)) {
                                    throw new IllegalArgumentException("illegal character literal");
                                }
                                n3 = n3 * 8 + ScannerHelper.getNumericValue(c2);
                                c2 = (char)scanner.getNextChar();
                                if (c2 == '\uffffffff') {
                                    throw new IllegalArgumentException("illegal character literal");
                                }
                                if (c2 != '\'') {
                                    if (!ScannerHelper.isDigit(c2)) {
                                        throw new IllegalArgumentException("illegal character literal");
                                    }
                                    n3 = n3 * 8 + ScannerHelper.getNumericValue(c2);
                                }
                            }
                            return (char)n3;
                        }
                        throw new IllegalArgumentException("illegal character literal");
                    }
                    catch (InvalidInputException invalidInputException) {
                        throw new IllegalArgumentException("illegal character literal");
                    }
                }
            }
            c2 = (char)scanner.getNextChar();
            if (c2 == '\uffffffff') {
                throw new IllegalArgumentException("illegal character literal");
            }
        }
        if (c2 == '\uffffffff' || c2 != '\'') {
            throw new IllegalArgumentException("illegal character literal");
        }
        return c;
    }

    public void setCharValue(char c) {
        StringBuffer stringBuffer = new StringBuffer(3);
        stringBuffer.append('\'');
        switch (c) {
            case '\b': {
                stringBuffer.append("\\b");
                break;
            }
            case '\t': {
                stringBuffer.append("\\t");
                break;
            }
            case '\n': {
                stringBuffer.append("\\n");
                break;
            }
            case '\f': {
                stringBuffer.append("\\f");
                break;
            }
            case '\r': {
                stringBuffer.append("\\r");
                break;
            }
            case '\"': {
                stringBuffer.append("\\\"");
                break;
            }
            case '\'': {
                stringBuffer.append("\\'");
                break;
            }
            case '\\': {
                stringBuffer.append("\\\\");
                break;
            }
            case '\u0000': {
                stringBuffer.append("\\0");
                break;
            }
            case '\u0001': {
                stringBuffer.append("\\1");
                break;
            }
            case '\u0002': {
                stringBuffer.append("\\2");
                break;
            }
            case '\u0003': {
                stringBuffer.append("\\3");
                break;
            }
            case '\u0004': {
                stringBuffer.append("\\4");
                break;
            }
            case '\u0005': {
                stringBuffer.append("\\5");
                break;
            }
            case '\u0006': {
                stringBuffer.append("\\6");
                break;
            }
            case '\u0007': {
                stringBuffer.append("\\7");
                break;
            }
            default: {
                stringBuffer.append(c);
            }
        }
        stringBuffer.append('\'');
        this.setEscapedValue(stringBuffer.toString());
    }

    int memSize() {
        int n = 44 + CharacterLiteral.stringSize(this.escapedValue);
        return n;
    }

    int treeSize() {
        return this.memSize();
    }
}

