/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.NodeEventHandler;
import org.eclipse.wst.jsdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.ASTRewriteAnalyzer;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.LineInformation;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.ListRewriteEvent;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.NodeInfoStore;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.NodeRewriteEvent;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.RewriteEventStore;

class InternalASTRewrite
extends NodeEventHandler {
    private CompilationUnit root;
    protected final RewriteEventStore eventStore;
    protected final NodeInfoStore nodeStore;
    protected final Hashtable clonedNodes;
    int cloneDepth = 0;

    public InternalASTRewrite(CompilationUnit compilationUnit) {
        this.root = compilationUnit;
        this.eventStore = new RewriteEventStore();
        this.nodeStore = new NodeInfoStore(compilationUnit.getAST());
        this.clonedNodes = new Hashtable();
    }

    public TextEdit rewriteAST(IDocument iDocument, Map map) {
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        final CompilationUnit compilationUnit = this.getRootNode();
        if (compilationUnit != null) {
            TargetSourceRangeComputer targetSourceRangeComputer = new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode aSTNode) {
                    int n = compilationUnit.getExtendedStartPosition(aSTNode);
                    int n2 = compilationUnit.getExtendedLength(aSTNode);
                    return new TargetSourceRangeComputer.SourceRange(n, n2);
                }
            };
            char[] cArray = iDocument.get().toCharArray();
            LineInformation lineInformation = LineInformation.create(iDocument);
            String string = TextUtilities.getDefaultLineDelimiter((IDocument)iDocument);
            List list = compilationUnit.getCommentList();
            ASTRewriteAnalyzer aSTRewriteAnalyzer = new ASTRewriteAnalyzer(cArray, lineInformation, string, (TextEdit)multiTextEdit, this.eventStore, this.nodeStore, list, map, targetSourceRangeComputer);
            compilationUnit.accept(aSTRewriteAnalyzer);
        }
        return multiTextEdit;
    }

    private void markAsMoveOrCopyTarget(ASTNode aSTNode, ASTNode aSTNode2) {
        ASTNode aSTNode3 = (ASTNode)this.clonedNodes.get(aSTNode2);
        if (aSTNode3 != null) {
            if (this.cloneDepth == 0) {
                RewriteEventStore.PropertyLocation propertyLocation = this.eventStore.getPropertyLocation(aSTNode3, 2);
                RewriteEventStore.CopySourceInfo copySourceInfo = this.eventStore.markAsCopySource(propertyLocation.getParent(), propertyLocation.getProperty(), aSTNode3, false);
                this.nodeStore.markAsCopyTarget(aSTNode2, copySourceInfo);
            }
        } else if ((aSTNode2.getFlags() & 2) != 0) {
            RewriteEventStore.PropertyLocation propertyLocation = this.eventStore.getPropertyLocation(aSTNode2, 2);
            RewriteEventStore.CopySourceInfo copySourceInfo = this.eventStore.markAsCopySource(propertyLocation.getParent(), propertyLocation.getProperty(), aSTNode2, true);
            this.nodeStore.markAsCopyTarget(aSTNode2, copySourceInfo);
        }
    }

    private CompilationUnit getRootNode() {
        return this.root;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Events:\n");
        stringBuffer.append(this.eventStore.toString());
        return stringBuffer.toString();
    }

    void preValueChangeEvent(ASTNode aSTNode, SimplePropertyDescriptor simplePropertyDescriptor) {
        this.getNodeEvent(aSTNode, simplePropertyDescriptor);
    }

    void postValueChangeEvent(ASTNode aSTNode, SimplePropertyDescriptor simplePropertyDescriptor) {
        NodeRewriteEvent nodeRewriteEvent = this.getNodeEvent(aSTNode, simplePropertyDescriptor);
        nodeRewriteEvent.setNewValue(aSTNode.getStructuralProperty(simplePropertyDescriptor));
    }

    void preAddChildEvent(ASTNode aSTNode, ASTNode aSTNode2, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        if (structuralPropertyDescriptor.isChildProperty()) {
            NodeRewriteEvent nodeRewriteEvent = this.getNodeEvent(aSTNode, structuralPropertyDescriptor);
            nodeRewriteEvent.setNewValue(aSTNode2);
            if (aSTNode2 != null) {
                this.markAsMoveOrCopyTarget(aSTNode, aSTNode2);
            }
        } else if (structuralPropertyDescriptor.isChildListProperty()) {
            this.getListEvent(aSTNode, structuralPropertyDescriptor);
        }
    }

    void postAddChildEvent(ASTNode aSTNode, ASTNode aSTNode2, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        if (structuralPropertyDescriptor.isChildListProperty()) {
            int n;
            int n2;
            ListRewriteEvent listRewriteEvent = this.getListEvent(aSTNode, structuralPropertyDescriptor);
            List list = (List)aSTNode.getStructuralProperty(structuralPropertyDescriptor);
            int n3 = list.indexOf(aSTNode2);
            if (n3 + 1 < (n2 = list.size())) {
                ASTNode aSTNode3 = (ASTNode)list.get(n3 + 1);
                n = listRewriteEvent.getIndex(aSTNode3, 1);
            } else {
                n = -1;
            }
            listRewriteEvent.insert(aSTNode2, n);
            if (aSTNode2 != null) {
                this.markAsMoveOrCopyTarget(aSTNode, aSTNode2);
            }
        }
    }

    void preRemoveChildEvent(ASTNode aSTNode, ASTNode aSTNode2, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        if (structuralPropertyDescriptor.isChildProperty()) {
            NodeRewriteEvent nodeRewriteEvent = this.getNodeEvent(aSTNode, structuralPropertyDescriptor);
            nodeRewriteEvent.setNewValue(null);
        } else if (structuralPropertyDescriptor.isChildListProperty()) {
            ListRewriteEvent listRewriteEvent = this.getListEvent(aSTNode, structuralPropertyDescriptor);
            int n = listRewriteEvent.getIndex(aSTNode2, 1);
            NodeRewriteEvent nodeRewriteEvent = (NodeRewriteEvent)listRewriteEvent.getChildren()[n];
            if (nodeRewriteEvent.getOriginalValue() == null) {
                listRewriteEvent.revertChange(nodeRewriteEvent);
            } else {
                nodeRewriteEvent.setNewValue(null);
            }
        }
    }

    void preReplaceChildEvent(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        if (structuralPropertyDescriptor.isChildProperty()) {
            NodeRewriteEvent nodeRewriteEvent = this.getNodeEvent(aSTNode, structuralPropertyDescriptor);
            nodeRewriteEvent.setNewValue(aSTNode3);
            if (aSTNode3 != null) {
                this.markAsMoveOrCopyTarget(aSTNode, aSTNode3);
            }
        } else if (structuralPropertyDescriptor.isChildListProperty()) {
            ListRewriteEvent listRewriteEvent = this.getListEvent(aSTNode, structuralPropertyDescriptor);
            int n = listRewriteEvent.getIndex(aSTNode2, 1);
            NodeRewriteEvent nodeRewriteEvent = (NodeRewriteEvent)listRewriteEvent.getChildren()[n];
            nodeRewriteEvent.setNewValue(aSTNode3);
            if (aSTNode3 != null) {
                this.markAsMoveOrCopyTarget(aSTNode, aSTNode3);
            }
        }
    }

    void preCloneNodeEvent(ASTNode aSTNode) {
        ++this.cloneDepth;
    }

    void postCloneNodeEvent(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode.ast == this.root.ast && aSTNode2.ast == this.root.ast) {
            if ((aSTNode.getFlags() & 2) != 0) {
                this.clonedNodes.put(aSTNode2, aSTNode);
            } else {
                Object v = this.clonedNodes.get(aSTNode);
                if (v != null) {
                    this.clonedNodes.put(aSTNode2, v);
                }
            }
        }
        --this.cloneDepth;
    }

    private NodeRewriteEvent getNodeEvent(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        return this.eventStore.getNodeEvent(aSTNode, structuralPropertyDescriptor, true);
    }

    private ListRewriteEvent getListEvent(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        return this.eventStore.getListEvent(aSTNode, structuralPropertyDescriptor, true);
    }
}

