/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AnnotationBinding;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.BindingComparator;
import org.eclipse.wst.jsdt.core.dom.BindingResolver;
import org.eclipse.wst.jsdt.core.dom.DefaultBindingResolver;
import org.eclipse.wst.jsdt.core.dom.IAnnotationBinding;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MemberValuePairBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.Member;
import org.eclipse.wst.jsdt.internal.core.util.Util;

class MethodBinding
implements IMethodBinding {
    private static final int VALID_MODIFIERS = 3391;
    private static final ITypeBinding[] NO_TYPE_BINDINGS = new ITypeBinding[0];
    private org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding binding;
    private BindingResolver resolver;
    private ITypeBinding[] parameterTypes;
    private ITypeBinding[] exceptionTypes;
    private String name;
    private ITypeBinding declaringClass;
    private ITypeBinding returnType;
    private String key;
    private ITypeBinding[] typeParameters;
    private ITypeBinding[] typeArguments;
    private IAnnotationBinding[] annotations;
    private IAnnotationBinding[] parameterAnnotations;

    MethodBinding(BindingResolver bindingResolver, org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding methodBinding) {
        this.resolver = bindingResolver;
        this.binding = methodBinding;
    }

    public boolean isAnnotationMember() {
        return this.getDeclaringClass().isAnnotation();
    }

    public boolean isConstructor() {
        return this.binding.isConstructor();
    }

    public boolean isDefaultConstructor() {
        ReferenceBinding referenceBinding = this.binding.declaringClass;
        if (referenceBinding.isRawType()) {
            RawTypeBinding rawTypeBinding = (RawTypeBinding)referenceBinding;
            if (rawTypeBinding.genericType().isBinaryBinding()) {
                return false;
            }
            return (this.binding.modifiers & 0x4000000) != 0;
        }
        if (referenceBinding.isBinaryBinding()) {
            return false;
        }
        return (this.binding.modifiers & 0x4000000) != 0;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.binding.isConstructor() ? this.getDeclaringClass().getName() : new String(this.binding.selector);
        }
        return this.name;
    }

    public IAnnotationBinding[] getAnnotations() {
        int n;
        if (this.annotations != null) {
            return this.annotations;
        }
        org.eclipse.wst.jsdt.internal.compiler.lookup.AnnotationBinding[] annotationBindingArray = this.binding.getAnnotations();
        int n2 = n = annotationBindingArray == null ? 0 : annotationBindingArray.length;
        if (n == 0) {
            this.annotations = AnnotationBinding.NoAnnotations;
            return AnnotationBinding.NoAnnotations;
        }
        IAnnotationBinding[] iAnnotationBindingArray = new AnnotationBinding[n];
        int n3 = 0;
        while (n3 < n) {
            IAnnotationBinding iAnnotationBinding = this.resolver.getAnnotationInstance(annotationBindingArray[n3]);
            if (iAnnotationBinding == null) {
                this.annotations = AnnotationBinding.NoAnnotations;
                return AnnotationBinding.NoAnnotations;
            }
            iAnnotationBindingArray[n3] = iAnnotationBinding;
            ++n3;
        }
        this.annotations = iAnnotationBindingArray;
        return iAnnotationBindingArray;
    }

    public ITypeBinding getDeclaringClass() {
        if (this.declaringClass == null) {
            this.declaringClass = this.resolver.getTypeBinding(this.binding.declaringClass);
        }
        return this.declaringClass;
    }

    public IAnnotationBinding[] getParameterAnnotations(int n) {
        int n2;
        if (this.parameterAnnotations != null) {
            return this.parameterAnnotations;
        }
        org.eclipse.wst.jsdt.internal.compiler.lookup.AnnotationBinding[] annotationBindingArray = this.binding.getParameterAnnotations(n);
        int n3 = n2 = annotationBindingArray == null ? 0 : annotationBindingArray.length;
        if (n2 == 0) {
            this.parameterAnnotations = AnnotationBinding.NoAnnotations;
            return AnnotationBinding.NoAnnotations;
        }
        IAnnotationBinding[] iAnnotationBindingArray = new AnnotationBinding[n2];
        int n4 = 0;
        while (n4 < n2) {
            IAnnotationBinding iAnnotationBinding = this.resolver.getAnnotationInstance(annotationBindingArray[n4]);
            if (iAnnotationBinding == null) {
                this.parameterAnnotations = AnnotationBinding.NoAnnotations;
                return AnnotationBinding.NoAnnotations;
            }
            iAnnotationBindingArray[n4] = iAnnotationBinding;
            ++n4;
        }
        this.parameterAnnotations = iAnnotationBindingArray;
        return iAnnotationBindingArray;
    }

    public ITypeBinding[] getParameterTypes() {
        int n;
        if (this.parameterTypes != null) {
            return this.parameterTypes;
        }
        TypeBinding[] typeBindingArray = this.binding.parameters;
        int n2 = n = typeBindingArray == null ? 0 : typeBindingArray.length;
        if (n == 0) {
            this.parameterTypes = NO_TYPE_BINDINGS;
            return NO_TYPE_BINDINGS;
        }
        ITypeBinding[] iTypeBindingArray = new ITypeBinding[n];
        int n3 = 0;
        while (n3 < n) {
            Object object;
            TypeBinding typeBinding = typeBindingArray[n3];
            if (typeBinding != null) {
                object = this.resolver.getTypeBinding(typeBinding);
                if (object == null) {
                    this.parameterTypes = NO_TYPE_BINDINGS;
                    return NO_TYPE_BINDINGS;
                }
            } else {
                object = new StringBuffer("Report method binding where a parameter is null:\n");
                ((StringBuffer)object).append(this.toString());
                Util.log(new IllegalArgumentException(), ((StringBuffer)object).toString());
                this.parameterTypes = NO_TYPE_BINDINGS;
                return NO_TYPE_BINDINGS;
            }
            iTypeBindingArray[n3] = object;
            ++n3;
        }
        this.parameterTypes = iTypeBindingArray;
        return iTypeBindingArray;
    }

    public ITypeBinding getReturnType() {
        if (this.returnType == null) {
            this.returnType = this.resolver.getTypeBinding(this.binding.returnType);
        }
        return this.returnType;
    }

    public Object getDefaultValue() {
        if (this.isAnnotationMember()) {
            return MemberValuePairBinding.buildDOMValue(this.binding.getDefaultValue(), this.resolver);
        }
        return null;
    }

    public ITypeBinding[] getExceptionTypes() {
        int n;
        if (this.exceptionTypes != null) {
            return this.exceptionTypes;
        }
        ReferenceBinding[] referenceBindingArray = this.binding.thrownExceptions;
        int n2 = n = referenceBindingArray == null ? 0 : referenceBindingArray.length;
        if (n == 0) {
            this.exceptionTypes = NO_TYPE_BINDINGS;
            return NO_TYPE_BINDINGS;
        }
        ITypeBinding[] iTypeBindingArray = new ITypeBinding[n];
        int n3 = 0;
        while (n3 < n) {
            ITypeBinding iTypeBinding = this.resolver.getTypeBinding(referenceBindingArray[n3]);
            if (iTypeBinding == null) {
                this.exceptionTypes = NO_TYPE_BINDINGS;
                return NO_TYPE_BINDINGS;
            }
            iTypeBindingArray[n3] = iTypeBinding;
            ++n3;
        }
        this.exceptionTypes = iTypeBindingArray;
        return iTypeBindingArray;
    }

    public IJavaElement getJavaElement() {
        JavaElement javaElement = this.getUnresolvedJavaElement();
        if (javaElement == null) {
            return null;
        }
        return javaElement.resolved(this.binding);
    }

    private JavaElement getUnresolvedJavaElement() {
        IJavaElement iJavaElement = this.getDeclaringClass().getJavaElement();
        if (iJavaElement == null) {
            return null;
        }
        if (!(this.resolver instanceof DefaultBindingResolver)) {
            return null;
        }
        ASTNode aSTNode = (ASTNode)((DefaultBindingResolver)this.resolver).bindingsToAstNodes.get(this);
        ITypeRoot iTypeRoot = null;
        IType iType = null;
        if (iJavaElement instanceof ITypeRoot) {
            iTypeRoot = (ITypeRoot)iJavaElement;
        } else if (iJavaElement instanceof IType) {
            iType = (IType)iJavaElement;
        }
        if (aSTNode != null && iJavaElement.getParent().getElementType() != 6) {
            if (aSTNode instanceof MethodDeclaration) {
                String[] stringArray;
                MethodDeclaration methodDeclaration = (MethodDeclaration)aSTNode;
                ArrayList<String> arrayList = new ArrayList<String>();
                Iterator iterator = methodDeclaration.parameters().iterator();
                while (iterator.hasNext()) {
                    SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)iterator.next();
                    stringArray = singleVariableDeclaration.getType();
                    String string = Util.getSignature((Type)stringArray);
                    int n = singleVariableDeclaration.getExtraDimensions();
                    if (singleVariableDeclaration.getAST().apiLevel() >= 3 && singleVariableDeclaration.isVarargs()) {
                        ++n;
                    }
                    if (n > 0) {
                        string = Signature.createArraySignature(string, n);
                    }
                    arrayList.add(string);
                }
                int n = arrayList.size();
                stringArray = new String[n];
                arrayList.toArray(stringArray);
                if (iTypeRoot != null) {
                    return (JavaElement)((Object)iTypeRoot.getMethod(this.getName(), stringArray));
                }
                return (JavaElement)((Object)iType.getMethod(this.getName(), stringArray));
            }
            AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration = (AnnotationTypeMemberDeclaration)aSTNode;
            return (JavaElement)((Object)iType.getMethod(annotationTypeMemberDeclaration.getName().getIdentifier(), CharOperation.NO_STRINGS));
        }
        org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding methodBinding = this.binding.original();
        String string = methodBinding.isConstructor() ? iType.getElementName() : new String(methodBinding.selector);
        boolean bl = iType.isBinary();
        ReferenceBinding referenceBinding = methodBinding.declaringClass.enclosingType();
        boolean bl2 = bl && methodBinding.isConstructor() && referenceBinding != null;
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        int n = typeBindingArray == null ? 0 : typeBindingArray.length;
        int n2 = bl2 ? 1 : 0;
        String[] stringArray = new String[n2 + n];
        if (bl2) {
            stringArray[0] = new String(referenceBinding.genericTypeSignature()).replace('/', '.');
        }
        int n3 = 0;
        while (n3 < n) {
            stringArray[n2 + n3] = new String(typeBindingArray[n3].genericTypeSignature()).replace('/', '.');
            ++n3;
        }
        IMethod iMethod = iType.getMethod(string, stringArray);
        if (bl) {
            return (JavaElement)((Object)iMethod);
        }
        IMethod[] iMethodArray = null;
        try {
            iMethodArray = iType.getMethods();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        IMethod[] iMethodArray2 = Member.findMethods(iMethod, iMethodArray);
        if (iMethodArray2 == null || iMethodArray2.length == 0) {
            return null;
        }
        return (JavaElement)((Object)iMethodArray2[0]);
    }

    public int getKind() {
        return 4;
    }

    public int getModifiers() {
        return this.binding.getAccessFlags() & 0xD3F;
    }

    public boolean isDeprecated() {
        return this.binding.isDeprecated();
    }

    public boolean isRecovered() {
        return false;
    }

    public boolean isSynthetic() {
        return this.binding.isSynthetic();
    }

    public boolean isVarargs() {
        return this.binding.isVarargs();
    }

    public String getKey() {
        if (this.key == null) {
            this.key = new String(this.binding.computeUniqueKey());
        }
        return this.key;
    }

    public boolean isEqualTo(IBinding iBinding) {
        if (iBinding == this) {
            return true;
        }
        if (iBinding == null) {
            return false;
        }
        if (!(iBinding instanceof MethodBinding)) {
            return false;
        }
        org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding methodBinding = ((MethodBinding)iBinding).binding;
        return BindingComparator.isEqual(this.binding, methodBinding);
    }

    public ITypeBinding[] getTypeParameters() {
        int n;
        if (this.typeParameters != null) {
            return this.typeParameters;
        }
        TypeVariableBinding[] typeVariableBindingArray = this.binding.typeVariables();
        int n2 = n = typeVariableBindingArray == null ? 0 : typeVariableBindingArray.length;
        if (n == 0) {
            this.typeParameters = NO_TYPE_BINDINGS;
            return NO_TYPE_BINDINGS;
        }
        ITypeBinding[] iTypeBindingArray = new ITypeBinding[n];
        int n3 = 0;
        while (n3 < n) {
            ITypeBinding iTypeBinding = this.resolver.getTypeBinding(typeVariableBindingArray[n3]);
            if (iTypeBinding == null) {
                this.typeParameters = NO_TYPE_BINDINGS;
                return NO_TYPE_BINDINGS;
            }
            iTypeBindingArray[n3] = iTypeBinding;
            ++n3;
        }
        this.typeParameters = iTypeBindingArray;
        return iTypeBindingArray;
    }

    public boolean isGenericMethod() {
        if (this.typeParameters != null) {
            return this.typeParameters.length > 0;
        }
        TypeVariableBinding[] typeVariableBindingArray = this.binding.typeVariables();
        return typeVariableBindingArray != null && typeVariableBindingArray.length > 0;
    }

    public ITypeBinding[] getTypeArguments() {
        if (this.typeArguments != null) {
            return this.typeArguments;
        }
        if (this.binding instanceof ParameterizedGenericMethodBinding) {
            int n;
            ParameterizedGenericMethodBinding parameterizedGenericMethodBinding = (ParameterizedGenericMethodBinding)this.binding;
            TypeBinding[] typeBindingArray = parameterizedGenericMethodBinding.typeArguments;
            int n2 = n = typeBindingArray == null ? 0 : typeBindingArray.length;
            if (n != 0) {
                ITypeBinding[] iTypeBindingArray = new ITypeBinding[n];
                int n3 = 0;
                while (n3 < n) {
                    ITypeBinding iTypeBinding = this.resolver.getTypeBinding(typeBindingArray[n3]);
                    if (iTypeBinding == null) {
                        this.typeArguments = NO_TYPE_BINDINGS;
                        return NO_TYPE_BINDINGS;
                    }
                    iTypeBindingArray[n3] = iTypeBinding;
                    ++n3;
                }
                this.typeArguments = iTypeBindingArray;
                return iTypeBindingArray;
            }
        }
        this.typeArguments = NO_TYPE_BINDINGS;
        return NO_TYPE_BINDINGS;
    }

    public boolean isParameterizedMethod() {
        return this.binding instanceof ParameterizedGenericMethodBinding && !((ParameterizedGenericMethodBinding)this.binding).isRaw;
    }

    public boolean isRawMethod() {
        return this.binding instanceof ParameterizedGenericMethodBinding && ((ParameterizedGenericMethodBinding)this.binding).isRaw;
    }

    public boolean isSubsignature(IMethodBinding iMethodBinding) {
        org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding methodBinding;
        block3: {
            try {
                methodBinding = ((MethodBinding)iMethodBinding).binding;
                if (CharOperation.equals(this.binding.selector, methodBinding.selector)) break block3;
                return false;
            }
            catch (AbortCompilation abortCompilation) {
                return false;
            }
        }
        return this.binding.areParameterErasuresEqual(methodBinding) && this.binding.areTypeVariableErasuresEqual(methodBinding);
    }

    public IMethodBinding getMethodDeclaration() {
        return this.resolver.getMethodBinding(this.binding.original());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean overrides(IMethodBinding iMethodBinding) {
        try {
            org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding methodBinding = ((MethodBinding)iMethodBinding).binding;
            if (this.binding == methodBinding) {
                return false;
            }
            char[] cArray = this.binding.selector;
            if (!CharOperation.equals(cArray, methodBinding.selector)) {
                return false;
            }
            TypeBinding typeBinding = this.binding.declaringClass.findSuperTypeWithSameErasure(methodBinding.declaringClass);
            if (!(typeBinding instanceof ReferenceBinding)) {
                return false;
            }
            org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding[] methodBindingArray = ((ReferenceBinding)typeBinding).getMethods(cArray);
            int n = 0;
            int n2 = methodBindingArray.length;
            while (true) {
                if (n >= n2) {
                    return false;
                }
                if (methodBindingArray[n].original() == methodBinding) {
                    LookupEnvironment lookupEnvironment = this.resolver.lookupEnvironment();
                    if (lookupEnvironment == null) {
                        return false;
                    }
                    MethodVerifier methodVerifier = lookupEnvironment.methodVerifier();
                    org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding methodBinding2 = methodBindingArray[n];
                    return !methodBinding2.isPrivate() && (!methodBinding2.isDefault() || methodBinding2.declaringClass.getPackage() == this.binding.declaringClass.getPackage()) && methodVerifier.doesMethodOverride(this.binding, methodBinding2);
                }
                ++n;
            }
        }
        catch (AbortCompilation abortCompilation) {
            return false;
        }
    }

    public String toString() {
        return this.binding.toString();
    }
}

