/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.Annotation;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.AssertStatement;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BlockComment;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionExpression;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.LineComment;
import org.eclipse.wst.jsdt.core.dom.ListExpression;
import org.eclipse.wst.jsdt.core.dom.MarkerAnnotation;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.MemberValuePair;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.MethodRef;
import org.eclipse.wst.jsdt.core.dom.MethodRefParameter;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NormalAnnotation;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.ProgramElement;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.RegularExpressionLiteral;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleMemberAnnotation;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.SynchronizedStatement;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.UndefinedLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WildcardType;
import org.eclipse.wst.jsdt.core.dom.WithStatement;

class NaiveASTFlattener
extends ASTVisitor {
    private StringBuffer buffer = new StringBuffer();
    private int indent = 0;

    NaiveASTFlattener() {
    }

    public String getResult() {
        return this.buffer.toString();
    }

    public void reset() {
        this.buffer.setLength(0);
    }

    void printIndent() {
        int n = 0;
        while (n < this.indent) {
            this.buffer.append("  ");
            ++n;
        }
    }

    void printModifiers(List list) {
    }

    void printModifiers(int n) {
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        if (annotationTypeDeclaration.getJavadoc() != null) {
            annotationTypeDeclaration.getJavadoc().accept(this);
        }
        this.printIndent();
        this.printModifiers(annotationTypeDeclaration.modifiers());
        this.buffer.append("@interface ");
        annotationTypeDeclaration.getName().accept(this);
        this.buffer.append(" {");
        Iterator iterator = annotationTypeDeclaration.bodyDeclarations().iterator();
        while (iterator.hasNext()) {
            BodyDeclaration bodyDeclaration = (BodyDeclaration)iterator.next();
            bodyDeclaration.accept(this);
        }
        this.buffer.append("}\n");
        return false;
    }

    public boolean visit(AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration) {
        if (annotationTypeMemberDeclaration.getJavadoc() != null) {
            annotationTypeMemberDeclaration.getJavadoc().accept(this);
        }
        this.printIndent();
        this.printModifiers(annotationTypeMemberDeclaration.modifiers());
        annotationTypeMemberDeclaration.getType().accept(this);
        this.buffer.append(" ");
        annotationTypeMemberDeclaration.getName().accept(this);
        this.buffer.append("()");
        if (annotationTypeMemberDeclaration.getDefault() != null) {
            this.buffer.append(" default ");
            annotationTypeMemberDeclaration.getDefault().accept(this);
        }
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
        this.buffer.append("{\n");
        ++this.indent;
        Iterator iterator = anonymousClassDeclaration.bodyDeclarations().iterator();
        while (iterator.hasNext()) {
            BodyDeclaration bodyDeclaration = (BodyDeclaration)iterator.next();
            bodyDeclaration.accept(this);
        }
        --this.indent;
        this.printIndent();
        this.buffer.append("}\n");
        return false;
    }

    public boolean visit(ArrayAccess arrayAccess) {
        arrayAccess.getArray().accept(this);
        this.buffer.append("[");
        arrayAccess.getIndex().accept(this);
        this.buffer.append("]");
        return false;
    }

    public boolean visit(ArrayCreation arrayCreation) {
        this.buffer.append("new ");
        ArrayType arrayType = arrayCreation.getType();
        int n = arrayType.getDimensions();
        Type type = arrayType.getElementType();
        type.accept(this);
        Iterator iterator = arrayCreation.dimensions().iterator();
        while (iterator.hasNext()) {
            this.buffer.append("[");
            Expression expression = (Expression)iterator.next();
            expression.accept(this);
            this.buffer.append("]");
            --n;
        }
        int n2 = 0;
        while (n2 < n) {
            this.buffer.append("[]");
            ++n2;
        }
        if (arrayCreation.getInitializer() != null) {
            arrayCreation.getInitializer().accept(this);
        }
        return false;
    }

    public boolean visit(ArrayInitializer arrayInitializer) {
        this.buffer.append("[");
        Iterator iterator = arrayInitializer.expressions().iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            expression.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append("]");
        return false;
    }

    public boolean visit(ArrayType arrayType) {
        arrayType.getComponentType().accept(this);
        this.buffer.append("[]");
        return false;
    }

    public boolean visit(AssertStatement assertStatement) {
        this.printIndent();
        this.buffer.append("assert ");
        assertStatement.getExpression().accept(this);
        if (assertStatement.getMessage() != null) {
            this.buffer.append(" : ");
            assertStatement.getMessage().accept(this);
        }
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(Assignment assignment) {
        assignment.getLeftHandSide().accept(this);
        this.buffer.append(assignment.getOperator().toString());
        assignment.getRightHandSide().accept(this);
        return false;
    }

    public boolean visit(Block block) {
        this.buffer.append("{\n");
        ++this.indent;
        Iterator iterator = block.statements().iterator();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            statement.accept(this);
        }
        --this.indent;
        this.printIndent();
        this.buffer.append("}\n");
        return false;
    }

    public boolean visit(BlockComment blockComment) {
        this.printIndent();
        this.buffer.append("/* */");
        return false;
    }

    public boolean visit(BooleanLiteral booleanLiteral) {
        if (booleanLiteral.booleanValue()) {
            this.buffer.append("true");
        } else {
            this.buffer.append("false");
        }
        return false;
    }

    public boolean visit(BreakStatement breakStatement) {
        this.printIndent();
        this.buffer.append("break");
        if (breakStatement.getLabel() != null) {
            this.buffer.append(" ");
            breakStatement.getLabel().accept(this);
        }
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(CastExpression castExpression) {
        this.buffer.append("(");
        castExpression.getType().accept(this);
        this.buffer.append(")");
        castExpression.getExpression().accept(this);
        return false;
    }

    public boolean visit(FunctionExpression functionExpression) {
        functionExpression.getMethod().accept(this);
        return false;
    }

    public boolean visit(CatchClause catchClause) {
        this.buffer.append("catch (");
        catchClause.getException().accept(this);
        this.buffer.append(") ");
        catchClause.getBody().accept(this);
        return false;
    }

    public boolean visit(CharacterLiteral characterLiteral) {
        this.buffer.append(characterLiteral.getEscapedValue());
        return false;
    }

    public boolean visit(RegularExpressionLiteral regularExpressionLiteral) {
        this.buffer.append(regularExpressionLiteral.getRegularExpression());
        return false;
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        if (classInstanceCreation.getExpression() != null) {
            classInstanceCreation.getExpression().accept(this);
            this.buffer.append(".");
        }
        this.buffer.append("new ");
        classInstanceCreation.getMember().accept(this);
        this.buffer.append("(");
        Iterator iterator = classInstanceCreation.arguments().iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            expression.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        if (classInstanceCreation.getAnonymousClassDeclaration() != null) {
            classInstanceCreation.getAnonymousClassDeclaration().accept(this);
        }
        return false;
    }

    public boolean visit(CompilationUnit compilationUnit) {
        ASTNode aSTNode;
        if (compilationUnit.getPackage() != null) {
            compilationUnit.getPackage().accept(this);
        }
        Iterator iterator = compilationUnit.imports().iterator();
        while (iterator.hasNext()) {
            aSTNode = (ImportDeclaration)iterator.next();
            aSTNode.accept(this);
        }
        iterator = compilationUnit.types().iterator();
        while (iterator.hasNext()) {
            aSTNode = (AbstractTypeDeclaration)iterator.next();
            aSTNode.accept(this);
        }
        iterator = compilationUnit.statements().iterator();
        while (iterator.hasNext()) {
            aSTNode = (ProgramElement)iterator.next();
            aSTNode.accept(this);
        }
        return false;
    }

    public boolean visit(ConditionalExpression conditionalExpression) {
        conditionalExpression.getExpression().accept(this);
        this.buffer.append(" ? ");
        conditionalExpression.getThenExpression().accept(this);
        this.buffer.append(" : ");
        conditionalExpression.getElseExpression().accept(this);
        return false;
    }

    public boolean visit(ConstructorInvocation constructorInvocation) {
        ASTNode aSTNode;
        Iterator iterator;
        this.printIndent();
        if (constructorInvocation.getAST().apiLevel() >= 3 && !constructorInvocation.typeArguments().isEmpty()) {
            this.buffer.append("<");
            iterator = constructorInvocation.typeArguments().iterator();
            while (iterator.hasNext()) {
                aSTNode = (Type)iterator.next();
                aSTNode.accept(this);
                if (!iterator.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(">");
        }
        this.buffer.append("this(");
        iterator = constructorInvocation.arguments().iterator();
        while (iterator.hasNext()) {
            aSTNode = (Expression)iterator.next();
            aSTNode.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(");\n");
        return false;
    }

    public boolean visit(ContinueStatement continueStatement) {
        this.printIndent();
        this.buffer.append("continue");
        if (continueStatement.getLabel() != null) {
            this.buffer.append(" ");
            continueStatement.getLabel().accept(this);
        }
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(DoStatement doStatement) {
        this.printIndent();
        this.buffer.append("do ");
        doStatement.getBody().accept(this);
        this.buffer.append(" while (");
        doStatement.getExpression().accept(this);
        this.buffer.append(");\n");
        return false;
    }

    public boolean visit(EmptyStatement emptyStatement) {
        this.printIndent();
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(EnhancedForStatement enhancedForStatement) {
        this.printIndent();
        this.buffer.append("for (");
        enhancedForStatement.getParameter().accept(this);
        this.buffer.append(" : ");
        enhancedForStatement.getExpression().accept(this);
        this.buffer.append(") ");
        enhancedForStatement.getBody().accept(this);
        return false;
    }

    public boolean visit(EnumConstantDeclaration enumConstantDeclaration) {
        if (enumConstantDeclaration.getJavadoc() != null) {
            enumConstantDeclaration.getJavadoc().accept(this);
        }
        this.printIndent();
        this.printModifiers(enumConstantDeclaration.modifiers());
        enumConstantDeclaration.getName().accept(this);
        if (!enumConstantDeclaration.arguments().isEmpty()) {
            this.buffer.append("(");
            Iterator iterator = enumConstantDeclaration.arguments().iterator();
            while (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                expression.accept(this);
                if (!iterator.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(")");
        }
        if (enumConstantDeclaration.getAnonymousClassDeclaration() != null) {
            enumConstantDeclaration.getAnonymousClassDeclaration().accept(this);
        }
        return false;
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        ASTNode aSTNode;
        Iterator iterator;
        if (enumDeclaration.getJavadoc() != null) {
            enumDeclaration.getJavadoc().accept(this);
        }
        this.printIndent();
        this.printModifiers(enumDeclaration.modifiers());
        this.buffer.append("enum ");
        enumDeclaration.getName().accept(this);
        this.buffer.append(" ");
        if (!enumDeclaration.superInterfaceTypes().isEmpty()) {
            this.buffer.append("implements ");
            iterator = enumDeclaration.superInterfaceTypes().iterator();
            while (iterator.hasNext()) {
                aSTNode = (Type)iterator.next();
                aSTNode.accept(this);
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(" ");
        }
        this.buffer.append("{");
        iterator = enumDeclaration.enumConstants().iterator();
        while (iterator.hasNext()) {
            aSTNode = (EnumConstantDeclaration)iterator.next();
            aSTNode.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        if (!enumDeclaration.bodyDeclarations().isEmpty()) {
            this.buffer.append("; ");
            iterator = enumDeclaration.bodyDeclarations().iterator();
            while (iterator.hasNext()) {
                aSTNode = (BodyDeclaration)iterator.next();
                aSTNode.accept(this);
            }
        }
        this.buffer.append("}\n");
        return false;
    }

    public boolean visit(ExpressionStatement expressionStatement) {
        this.printIndent();
        expressionStatement.getExpression().accept(this);
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(FieldAccess fieldAccess) {
        fieldAccess.getExpression().accept(this);
        this.buffer.append(".");
        fieldAccess.getName().accept(this);
        return false;
    }

    public boolean visit(FieldDeclaration fieldDeclaration) {
        if (fieldDeclaration.getJavadoc() != null) {
            fieldDeclaration.getJavadoc().accept(this);
        }
        this.printIndent();
        if (fieldDeclaration.getAST().apiLevel() == 2) {
            this.printModifiers(fieldDeclaration.getModifiers());
        }
        if (fieldDeclaration.getAST().apiLevel() >= 3) {
            this.printModifiers(fieldDeclaration.modifiers());
        }
        fieldDeclaration.getType().accept(this);
        this.buffer.append(" ");
        Iterator iterator = fieldDeclaration.fragments().iterator();
        while (iterator.hasNext()) {
            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)iterator.next();
            variableDeclarationFragment.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(ForStatement forStatement) {
        Expression expression;
        this.printIndent();
        this.buffer.append("for (");
        Iterator iterator = forStatement.initializers().iterator();
        while (iterator.hasNext()) {
            expression = (Expression)iterator.next();
            expression.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append("; ");
        if (forStatement.getExpression() != null) {
            forStatement.getExpression().accept(this);
        }
        this.buffer.append("; ");
        iterator = forStatement.updaters().iterator();
        while (iterator.hasNext()) {
            expression = (Expression)iterator.next();
            expression.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(") ");
        forStatement.getBody().accept(this);
        return false;
    }

    public boolean visit(ForInStatement forInStatement) {
        this.printIndent();
        this.buffer.append("for (");
        if (forInStatement.getIterationVariable() != null) {
            forInStatement.getIterationVariable().accept(this);
        }
        this.buffer.append(" in ");
        if (forInStatement.getCollection() != null) {
            forInStatement.getCollection().accept(this);
        }
        this.buffer.append(") ");
        forInStatement.getBody().accept(this);
        return false;
    }

    public boolean visit(IfStatement ifStatement) {
        this.printIndent();
        this.buffer.append("if (");
        ifStatement.getExpression().accept(this);
        this.buffer.append(") ");
        ifStatement.getThenStatement().accept(this);
        if (ifStatement.getElseStatement() != null) {
            this.buffer.append(" else ");
            ifStatement.getElseStatement().accept(this);
        }
        return false;
    }

    public boolean visit(ImportDeclaration importDeclaration) {
        this.printIndent();
        this.buffer.append("import ");
        if (importDeclaration.getAST().apiLevel() >= 3 && importDeclaration.isStatic()) {
            this.buffer.append("static ");
        }
        importDeclaration.getName().accept(this);
        if (importDeclaration.isOnDemand()) {
            this.buffer.append(".*");
        }
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(InfixExpression infixExpression) {
        infixExpression.getLeftOperand().accept(this);
        this.buffer.append(' ');
        this.buffer.append(infixExpression.getOperator().toString());
        this.buffer.append(' ');
        infixExpression.getRightOperand().accept(this);
        List list = infixExpression.extendedOperands();
        if (list.size() != 0) {
            this.buffer.append(' ');
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.buffer.append(infixExpression.getOperator().toString()).append(' ');
                Expression expression = (Expression)iterator.next();
                expression.accept(this);
            }
        }
        return false;
    }

    public boolean visit(InstanceofExpression instanceofExpression) {
        instanceofExpression.getLeftOperand().accept(this);
        this.buffer.append(" instanceof ");
        instanceofExpression.getRightOperand().accept(this);
        return false;
    }

    public boolean visit(Initializer initializer) {
        if (initializer.getJavadoc() != null) {
            initializer.getJavadoc().accept(this);
        }
        if (initializer.getAST().apiLevel() == 2) {
            this.printModifiers(initializer.getModifiers());
        }
        if (initializer.getAST().apiLevel() >= 3) {
            this.printModifiers(initializer.modifiers());
        }
        initializer.getBody().accept(this);
        return false;
    }

    public boolean visit(Javadoc javadoc) {
        this.printIndent();
        this.buffer.append("/** ");
        Iterator iterator = javadoc.tags().iterator();
        while (iterator.hasNext()) {
            ASTNode aSTNode = (ASTNode)iterator.next();
            aSTNode.accept(this);
        }
        this.buffer.append("\n */\n");
        return false;
    }

    public boolean visit(LabeledStatement labeledStatement) {
        this.printIndent();
        labeledStatement.getLabel().accept(this);
        this.buffer.append(": ");
        labeledStatement.getBody().accept(this);
        return false;
    }

    public boolean visit(LineComment lineComment) {
        this.buffer.append("//\n");
        return false;
    }

    public boolean visit(ListExpression listExpression) {
        Iterator iterator = listExpression.expressions().iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            expression.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(",");
        }
        return false;
    }

    public boolean visit(MarkerAnnotation markerAnnotation) {
        this.buffer.append("@");
        markerAnnotation.getTypeName().accept(this);
        return false;
    }

    public boolean visit(MemberRef memberRef) {
        if (memberRef.getQualifier() != null) {
            memberRef.getQualifier().accept(this);
        }
        this.buffer.append("#");
        memberRef.getName().accept(this);
        return false;
    }

    public boolean visit(MemberValuePair memberValuePair) {
        memberValuePair.getName().accept(this);
        this.buffer.append("=");
        memberValuePair.getValue().accept(this);
        return false;
    }

    public boolean visit(MethodRef methodRef) {
        if (methodRef.getQualifier() != null) {
            methodRef.getQualifier().accept(this);
        }
        this.buffer.append("#");
        methodRef.getName().accept(this);
        this.buffer.append("(");
        Iterator iterator = methodRef.parameters().iterator();
        while (iterator.hasNext()) {
            MethodRefParameter methodRefParameter = (MethodRefParameter)iterator.next();
            methodRefParameter.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        return false;
    }

    public boolean visit(MethodRefParameter methodRefParameter) {
        methodRefParameter.getType().accept(this);
        if (methodRefParameter.getAST().apiLevel() >= 3 && methodRefParameter.isVarargs()) {
            this.buffer.append("...");
        }
        if (methodRefParameter.getName() != null) {
            this.buffer.append(" ");
            methodRefParameter.getName().accept(this);
        }
        return false;
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        ASTNode aSTNode;
        Object object;
        Object object2;
        if (methodDeclaration.getJavadoc() != null) {
            methodDeclaration.getJavadoc().accept(this);
        }
        this.printIndent();
        if (methodDeclaration.getAST().apiLevel() == 2) {
            this.printModifiers(methodDeclaration.getModifiers());
        }
        if (methodDeclaration.getAST().apiLevel() >= 3) {
            this.printModifiers(methodDeclaration.modifiers());
            if (!methodDeclaration.typeParameters().isEmpty()) {
                this.buffer.append("<");
                object2 = methodDeclaration.typeParameters().iterator();
                while (object2.hasNext()) {
                    object = (TypeParameter)object2.next();
                    ((ASTNode)object).accept(this);
                    if (!object2.hasNext()) continue;
                    this.buffer.append(",");
                }
                this.buffer.append(">");
            }
        }
        this.buffer.append("function ");
        object2 = methodDeclaration.getName();
        if (object2 != null) {
            ((ASTNode)object2).accept(this);
        }
        this.buffer.append("(");
        object = methodDeclaration.parameters().iterator();
        while (object.hasNext()) {
            aSTNode = (SingleVariableDeclaration)object.next();
            aSTNode.accept(this);
            if (!object.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        int n = 0;
        while (n < methodDeclaration.getExtraDimensions()) {
            this.buffer.append("[]");
            ++n;
        }
        if (!methodDeclaration.thrownExceptions().isEmpty()) {
            this.buffer.append(" throws ");
            Iterator iterator = methodDeclaration.thrownExceptions().iterator();
            while (iterator.hasNext()) {
                aSTNode = (Name)iterator.next();
                aSTNode.accept(this);
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(" ");
        }
        if (methodDeclaration.getBody() == null) {
            this.buffer.append(";\n");
        } else {
            methodDeclaration.getBody().accept(this);
        }
        return false;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        ASTNode aSTNode;
        Iterator iterator;
        if (methodInvocation.getExpression() != null) {
            methodInvocation.getExpression().accept(this);
            if (methodInvocation.getName() != null) {
                this.buffer.append(".");
            }
        }
        if (methodInvocation.getAST().apiLevel() >= 3 && !methodInvocation.typeArguments().isEmpty()) {
            this.buffer.append("<");
            iterator = methodInvocation.typeArguments().iterator();
            while (iterator.hasNext()) {
                aSTNode = (Type)iterator.next();
                aSTNode.accept(this);
                if (!iterator.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(">");
        }
        if (methodInvocation.getName() != null) {
            methodInvocation.getName().accept(this);
        }
        this.buffer.append("(");
        iterator = methodInvocation.arguments().iterator();
        while (iterator.hasNext()) {
            aSTNode = (Expression)iterator.next();
            aSTNode.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        return false;
    }

    public boolean visit(Modifier modifier) {
        this.buffer.append(modifier.getKeyword().toString());
        return false;
    }

    public boolean visit(NormalAnnotation normalAnnotation) {
        this.buffer.append("@");
        normalAnnotation.getTypeName().accept(this);
        this.buffer.append("(");
        Iterator iterator = normalAnnotation.values().iterator();
        while (iterator.hasNext()) {
            MemberValuePair memberValuePair = (MemberValuePair)iterator.next();
            memberValuePair.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        return false;
    }

    public boolean visit(NullLiteral nullLiteral) {
        this.buffer.append("null");
        return false;
    }

    public boolean visit(UndefinedLiteral undefinedLiteral) {
        this.buffer.append("undefined");
        return false;
    }

    public boolean visit(NumberLiteral numberLiteral) {
        this.buffer.append(numberLiteral.getToken());
        return false;
    }

    public boolean visit(ObjectLiteral objectLiteral) {
        if (objectLiteral.fields().isEmpty()) {
            this.buffer.append("{}");
        } else {
            this.buffer.append("{\n");
            Iterator iterator = objectLiteral.fields().iterator();
            while (iterator.hasNext()) {
                ObjectLiteralField objectLiteralField = (ObjectLiteralField)iterator.next();
                objectLiteralField.accept(this);
                if (!iterator.hasNext()) continue;
                this.buffer.append(",\n");
            }
            this.buffer.append("\n}");
        }
        return false;
    }

    public boolean visit(ObjectLiteralField objectLiteralField) {
        objectLiteralField.getFieldName().accept(this);
        this.buffer.append(" : ");
        objectLiteralField.getInitializer().accept(this);
        return false;
    }

    public boolean visit(PackageDeclaration packageDeclaration) {
        if (packageDeclaration.getAST().apiLevel() >= 3) {
            if (packageDeclaration.getJavadoc() != null) {
                packageDeclaration.getJavadoc().accept(this);
            }
            Iterator iterator = packageDeclaration.annotations().iterator();
            while (iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                annotation.accept(this);
                this.buffer.append(" ");
            }
        }
        this.printIndent();
        this.buffer.append("package ");
        packageDeclaration.getName().accept(this);
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(ParameterizedType parameterizedType) {
        parameterizedType.getType().accept(this);
        this.buffer.append("<");
        Iterator iterator = parameterizedType.typeArguments().iterator();
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            type.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(">");
        return false;
    }

    public boolean visit(ParenthesizedExpression parenthesizedExpression) {
        this.buffer.append("(");
        parenthesizedExpression.getExpression().accept(this);
        this.buffer.append(")");
        return false;
    }

    public boolean visit(PostfixExpression postfixExpression) {
        postfixExpression.getOperand().accept(this);
        this.buffer.append(postfixExpression.getOperator().toString());
        return false;
    }

    public boolean visit(PrefixExpression prefixExpression) {
        this.buffer.append(prefixExpression.getOperator().toString());
        prefixExpression.getOperand().accept(this);
        return false;
    }

    public boolean visit(PrimitiveType primitiveType) {
        this.buffer.append(primitiveType.getPrimitiveTypeCode().toString());
        return false;
    }

    public boolean visit(QualifiedName qualifiedName) {
        qualifiedName.getQualifier().accept(this);
        this.buffer.append(".");
        qualifiedName.getName().accept(this);
        return false;
    }

    public boolean visit(QualifiedType qualifiedType) {
        qualifiedType.getQualifier().accept(this);
        this.buffer.append(".");
        qualifiedType.getName().accept(this);
        return false;
    }

    public boolean visit(ReturnStatement returnStatement) {
        this.printIndent();
        this.buffer.append("return");
        if (returnStatement.getExpression() != null) {
            this.buffer.append(" ");
            returnStatement.getExpression().accept(this);
        }
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(SimpleName simpleName) {
        this.buffer.append(simpleName.getIdentifier());
        return false;
    }

    public boolean visit(SimpleType simpleType) {
        return true;
    }

    public boolean visit(SingleMemberAnnotation singleMemberAnnotation) {
        this.buffer.append("@");
        singleMemberAnnotation.getTypeName().accept(this);
        this.buffer.append("(");
        singleMemberAnnotation.getValue().accept(this);
        this.buffer.append(")");
        return false;
    }

    public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
        this.printIndent();
        if (singleVariableDeclaration.getAST().apiLevel() == 2) {
            this.printModifiers(singleVariableDeclaration.getModifiers());
        }
        if (singleVariableDeclaration.getAST().apiLevel() >= 3) {
            this.printModifiers(singleVariableDeclaration.modifiers());
        }
        singleVariableDeclaration.getType().accept(this);
        if (singleVariableDeclaration.getAST().apiLevel() >= 3 && singleVariableDeclaration.isVarargs()) {
            this.buffer.append("...");
        }
        this.buffer.append(" ");
        singleVariableDeclaration.getName().accept(this);
        int n = 0;
        while (n < singleVariableDeclaration.getExtraDimensions()) {
            this.buffer.append("[]");
            ++n;
        }
        if (singleVariableDeclaration.getInitializer() != null) {
            this.buffer.append("=");
            singleVariableDeclaration.getInitializer().accept(this);
        }
        return false;
    }

    public boolean visit(StringLiteral stringLiteral) {
        this.buffer.append(stringLiteral.getEscapedValue());
        return false;
    }

    public boolean visit(SuperConstructorInvocation superConstructorInvocation) {
        ASTNode aSTNode;
        Iterator iterator;
        this.printIndent();
        if (superConstructorInvocation.getExpression() != null) {
            superConstructorInvocation.getExpression().accept(this);
            this.buffer.append(".");
        }
        if (superConstructorInvocation.getAST().apiLevel() >= 3 && !superConstructorInvocation.typeArguments().isEmpty()) {
            this.buffer.append("<");
            iterator = superConstructorInvocation.typeArguments().iterator();
            while (iterator.hasNext()) {
                aSTNode = (Type)iterator.next();
                aSTNode.accept(this);
                if (!iterator.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(">");
        }
        this.buffer.append("super(");
        iterator = superConstructorInvocation.arguments().iterator();
        while (iterator.hasNext()) {
            aSTNode = (Expression)iterator.next();
            aSTNode.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(");\n");
        return false;
    }

    public boolean visit(SuperFieldAccess superFieldAccess) {
        if (superFieldAccess.getQualifier() != null) {
            superFieldAccess.getQualifier().accept(this);
            this.buffer.append(".");
        }
        this.buffer.append("super.");
        superFieldAccess.getName().accept(this);
        return false;
    }

    public boolean visit(SuperMethodInvocation superMethodInvocation) {
        ASTNode aSTNode;
        Iterator iterator;
        if (superMethodInvocation.getQualifier() != null) {
            superMethodInvocation.getQualifier().accept(this);
            this.buffer.append(".");
        }
        this.buffer.append("super.");
        if (superMethodInvocation.getAST().apiLevel() >= 3 && !superMethodInvocation.typeArguments().isEmpty()) {
            this.buffer.append("<");
            iterator = superMethodInvocation.typeArguments().iterator();
            while (iterator.hasNext()) {
                aSTNode = (Type)iterator.next();
                aSTNode.accept(this);
                if (!iterator.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(">");
        }
        superMethodInvocation.getName().accept(this);
        this.buffer.append("(");
        iterator = superMethodInvocation.arguments().iterator();
        while (iterator.hasNext()) {
            aSTNode = (Expression)iterator.next();
            aSTNode.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        return false;
    }

    public boolean visit(SwitchCase switchCase) {
        if (switchCase.isDefault()) {
            this.buffer.append("default :\n");
        } else {
            this.buffer.append("case ");
            switchCase.getExpression().accept(this);
            this.buffer.append(":\n");
        }
        ++this.indent;
        return false;
    }

    public boolean visit(SwitchStatement switchStatement) {
        this.buffer.append("switch (");
        switchStatement.getExpression().accept(this);
        this.buffer.append(") ");
        this.buffer.append("{\n");
        ++this.indent;
        Iterator iterator = switchStatement.statements().iterator();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            statement.accept(this);
            --this.indent;
        }
        --this.indent;
        this.printIndent();
        this.buffer.append("}\n");
        return false;
    }

    public boolean visit(SynchronizedStatement synchronizedStatement) {
        this.buffer.append("synchronized (");
        synchronizedStatement.getExpression().accept(this);
        this.buffer.append(") ");
        synchronizedStatement.getBody().accept(this);
        return false;
    }

    public boolean visit(TagElement tagElement) {
        if (tagElement.isNested()) {
            this.buffer.append("{");
        } else {
            this.buffer.append("\n * ");
        }
        boolean bl = false;
        if (tagElement.getTagName() != null) {
            this.buffer.append(tagElement.getTagName());
            bl = true;
        }
        boolean bl2 = false;
        Iterator iterator = tagElement.fragments().iterator();
        while (iterator.hasNext()) {
            ASTNode aSTNode = (ASTNode)iterator.next();
            boolean bl3 = aSTNode instanceof TextElement;
            if (bl2 && bl3) {
                this.buffer.append("\n * ");
            }
            bl2 = bl3;
            if (bl && !bl3) {
                this.buffer.append(" ");
            }
            aSTNode.accept(this);
            boolean bl4 = bl = !bl3 && !(aSTNode instanceof TagElement);
        }
        if (tagElement.isNested()) {
            this.buffer.append("}");
        }
        return false;
    }

    public boolean visit(TextElement textElement) {
        this.buffer.append(textElement.getText());
        return false;
    }

    public boolean visit(ThisExpression thisExpression) {
        if (thisExpression.getQualifier() != null) {
            thisExpression.getQualifier().accept(this);
            this.buffer.append(".");
        }
        this.buffer.append("this");
        return false;
    }

    public boolean visit(ThrowStatement throwStatement) {
        this.printIndent();
        this.buffer.append("throw ");
        throwStatement.getExpression().accept(this);
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(TryStatement tryStatement) {
        this.printIndent();
        this.buffer.append("try ");
        tryStatement.getBody().accept(this);
        this.buffer.append(" ");
        Iterator iterator = tryStatement.catchClauses().iterator();
        while (iterator.hasNext()) {
            CatchClause catchClause = (CatchClause)iterator.next();
            catchClause.accept(this);
        }
        if (tryStatement.getFinally() != null) {
            this.buffer.append(" finally ");
            tryStatement.getFinally().accept(this);
        }
        return false;
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        ASTNode aSTNode;
        Iterator iterator;
        if (typeDeclaration.getJavadoc() != null) {
            typeDeclaration.getJavadoc().accept(this);
        }
        if (typeDeclaration.getAST().apiLevel() == 2) {
            this.printModifiers(typeDeclaration.getModifiers());
        }
        if (typeDeclaration.getAST().apiLevel() >= 3) {
            this.printModifiers(typeDeclaration.modifiers());
        }
        this.buffer.append(typeDeclaration.isInterface() ? "interface " : "class ");
        typeDeclaration.getName().accept(this);
        if (typeDeclaration.getAST().apiLevel() >= 3 && !typeDeclaration.typeParameters().isEmpty()) {
            this.buffer.append("<");
            iterator = typeDeclaration.typeParameters().iterator();
            while (iterator.hasNext()) {
                aSTNode = (TypeParameter)iterator.next();
                aSTNode.accept(this);
                if (!iterator.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(">");
        }
        this.buffer.append(" ");
        if (typeDeclaration.getAST().apiLevel() == 2) {
            if (typeDeclaration.internalGetSuperclass() != null) {
                this.buffer.append("extends ");
                typeDeclaration.internalGetSuperclass().accept(this);
                this.buffer.append(" ");
            }
            if (!typeDeclaration.internalSuperInterfaces().isEmpty()) {
                this.buffer.append(typeDeclaration.isInterface() ? "extends " : "implements ");
                iterator = typeDeclaration.internalSuperInterfaces().iterator();
                while (iterator.hasNext()) {
                    aSTNode = (Name)iterator.next();
                    aSTNode.accept(this);
                    if (!iterator.hasNext()) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(" ");
            }
        }
        if (typeDeclaration.getAST().apiLevel() >= 3) {
            if (typeDeclaration.getSuperclassType() != null) {
                this.buffer.append("extends ");
                typeDeclaration.getSuperclassType().accept(this);
                this.buffer.append(" ");
            }
            if (!typeDeclaration.superInterfaceTypes().isEmpty()) {
                this.buffer.append(typeDeclaration.isInterface() ? "extends " : "implements ");
                iterator = typeDeclaration.superInterfaceTypes().iterator();
                while (iterator.hasNext()) {
                    aSTNode = (Type)iterator.next();
                    aSTNode.accept(this);
                    if (!iterator.hasNext()) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(" ");
            }
        }
        this.buffer.append("{\n");
        ++this.indent;
        iterator = typeDeclaration.bodyDeclarations().iterator();
        while (iterator.hasNext()) {
            aSTNode = (BodyDeclaration)iterator.next();
            aSTNode.accept(this);
        }
        --this.indent;
        this.printIndent();
        this.buffer.append("}\n");
        return false;
    }

    public boolean visit(TypeDeclarationStatement typeDeclarationStatement) {
        if (typeDeclarationStatement.getAST().apiLevel() == 2) {
            typeDeclarationStatement.internalGetTypeDeclaration().accept(this);
        }
        if (typeDeclarationStatement.getAST().apiLevel() >= 3) {
            typeDeclarationStatement.getDeclaration().accept(this);
        }
        return false;
    }

    public boolean visit(TypeLiteral typeLiteral) {
        typeLiteral.getType().accept(this);
        this.buffer.append(".class");
        return false;
    }

    public boolean visit(TypeParameter typeParameter) {
        typeParameter.getName().accept(this);
        if (!typeParameter.typeBounds().isEmpty()) {
            this.buffer.append(" extends ");
            Iterator iterator = typeParameter.typeBounds().iterator();
            while (iterator.hasNext()) {
                Type type = (Type)iterator.next();
                type.accept(this);
                if (!iterator.hasNext()) continue;
                this.buffer.append(" & ");
            }
        }
        return false;
    }

    public boolean visit(VariableDeclarationExpression variableDeclarationExpression) {
        if (variableDeclarationExpression.getAST().apiLevel() == 2) {
            this.printModifiers(variableDeclarationExpression.getModifiers());
        }
        if (variableDeclarationExpression.getAST().apiLevel() >= 3) {
            this.printModifiers(variableDeclarationExpression.modifiers());
        }
        variableDeclarationExpression.getType().accept(this);
        this.buffer.append(" ");
        Iterator iterator = variableDeclarationExpression.fragments().iterator();
        while (iterator.hasNext()) {
            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)iterator.next();
            variableDeclarationFragment.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        return false;
    }

    public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
        variableDeclarationFragment.getName().accept(this);
        int n = 0;
        while (n < variableDeclarationFragment.getExtraDimensions()) {
            this.buffer.append("[]");
            ++n;
        }
        if (variableDeclarationFragment.getInitializer() != null) {
            this.buffer.append("=");
            variableDeclarationFragment.getInitializer().accept(this);
        }
        return false;
    }

    public boolean visit(VariableDeclarationStatement variableDeclarationStatement) {
        this.printIndent();
        if (variableDeclarationStatement.getAST().apiLevel() == 2) {
            this.printModifiers(variableDeclarationStatement.getModifiers());
        }
        if (variableDeclarationStatement.getAST().apiLevel() >= 3) {
            this.printModifiers(variableDeclarationStatement.modifiers());
        }
        this.buffer.append("var ");
        Iterator iterator = variableDeclarationStatement.fragments().iterator();
        while (iterator.hasNext()) {
            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)iterator.next();
            variableDeclarationFragment.accept(this);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(WildcardType wildcardType) {
        this.buffer.append("?");
        Type type = wildcardType.getBound();
        if (type != null) {
            if (wildcardType.isUpperBound()) {
                this.buffer.append(" extends ");
            } else {
                this.buffer.append(" super ");
            }
            type.accept(this);
        }
        return false;
    }

    public boolean visit(WhileStatement whileStatement) {
        this.printIndent();
        this.buffer.append("while (");
        whileStatement.getExpression().accept(this);
        this.buffer.append(") ");
        whileStatement.getBody().accept(this);
        return false;
    }

    public boolean visit(WithStatement withStatement) {
        this.printIndent();
        this.buffer.append("with (");
        withStatement.getExpression().accept(this);
        this.buffer.append(") ");
        withStatement.getBody().accept(this);
        return false;
    }
}

