/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AnnotationBinding;
import org.eclipse.wst.jsdt.core.dom.BindingResolver;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IAnnotationBinding;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;

class RecoveredVariableBinding
implements IVariableBinding {
    private VariableDeclaration variableDeclaration;
    private BindingResolver resolver;

    RecoveredVariableBinding(BindingResolver bindingResolver, VariableDeclaration variableDeclaration) {
        this.resolver = bindingResolver;
        this.variableDeclaration = variableDeclaration;
    }

    public Object getConstantValue() {
        return null;
    }

    public ITypeBinding getDeclaringClass() {
        ASTNode aSTNode = this.variableDeclaration.getParent();
        while (aSTNode != null && aSTNode.getNodeType() != 55) {
            aSTNode = aSTNode.getParent();
        }
        if (aSTNode != null) {
            return ((TypeDeclaration)aSTNode).resolveBinding();
        }
        return null;
    }

    public IMethodBinding getDeclaringMethod() {
        ASTNode aSTNode = this.variableDeclaration.getParent();
        while (aSTNode != null && aSTNode.getNodeType() != 31) {
            aSTNode = aSTNode.getParent();
        }
        if (aSTNode != null) {
            return ((MethodDeclaration)aSTNode).resolveBinding();
        }
        return null;
    }

    public String getName() {
        return this.variableDeclaration.getName().getIdentifier();
    }

    public ITypeBinding getType() {
        return this.resolver.getTypeBinding(this.variableDeclaration);
    }

    public IVariableBinding getVariableDeclaration() {
        return this;
    }

    public int getVariableId() {
        return 0;
    }

    public boolean isEnumConstant() {
        return false;
    }

    public boolean isField() {
        return this.variableDeclaration.getParent() instanceof FieldDeclaration;
    }

    public boolean isParameter() {
        return this.variableDeclaration instanceof SingleVariableDeclaration;
    }

    public IAnnotationBinding[] getAnnotations() {
        return AnnotationBinding.NoAnnotations;
    }

    public IJavaElement getJavaElement() {
        return null;
    }

    public String getKey() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Recovered#");
        if (this.variableDeclaration != null) {
            stringBuffer.append("variableDeclaration").append(this.variableDeclaration.getName().getIdentifier()).append(this.variableDeclaration.getExtraDimensions());
        }
        return String.valueOf(stringBuffer);
    }

    public int getKind() {
        return 3;
    }

    public int getModifiers() {
        return 0;
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean isEqualTo(IBinding iBinding) {
        if (iBinding.isRecovered() && iBinding.getKind() == 3) {
            return this.getKey().equals(iBinding.getKey());
        }
        return false;
    }

    public boolean isRecovered() {
        return true;
    }

    public boolean isSynthetic() {
        return false;
    }

    public boolean isGlobal() {
        return false;
    }
}

