/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class Argument
extends LocalDeclaration {
    private static final char[] SET = "set".toCharArray();

    public Argument(char[] cArray, long l, TypeReference typeReference, int n) {
        super(cArray, (int)(l >>> 32), (int)l);
        this.declarationSourceEnd = (int)l;
        this.modifiers = n;
        this.type = typeReference;
        this.bits |= 0x40000000;
    }

    public void bind(MethodScope methodScope, TypeBinding typeBinding, boolean bl) {
        Binding binding = methodScope.getLocalBinding(this.name, 3, this, false);
        if (binding != null && binding.isValidBinding() && binding instanceof LocalVariableBinding) {
            LocalVariableBinding localVariableBinding = (LocalVariableBinding)binding;
            if (localVariableBinding.declaringScope.compilationUnitScope() == methodScope.compilationUnitScope()) {
                methodScope.problemReporter().localVariableHiding(this, binding, false);
            }
        }
        if (this.binding == null) {
            this.binding = new LocalVariableBinding(this, typeBinding, this.modifiers, true);
        }
        methodScope.addLocalVariable(this.binding);
        this.binding.declaration = this;
        this.binding.useFlag = bl ? 1 : 0;
    }

    public int getKind() {
        return 5;
    }

    public boolean isVarArgs() {
        return this.type != null && (this.type.bits & 0x4000) != 0;
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        Argument.printIndent(n, stringBuffer);
        Argument.printModifiers(this.modifiers, stringBuffer);
        return stringBuffer.append(this.name);
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        return this.print(n, stringBuffer).append(';');
    }

    public TypeBinding resolveForCatch(BlockScope blockScope) {
        Binding binding;
        BaseTypeBinding baseTypeBinding;
        TypeBinding typeBinding = baseTypeBinding = this.type != null ? this.type.resolveType(blockScope, true) : TypeBinding.UNKNOWN;
        if (baseTypeBinding == null) {
            return null;
        }
        boolean bl = false;
        if (baseTypeBinding.isBoundParameterizedType()) {
            blockScope.problemReporter().invalidParameterizedExceptionType(baseTypeBinding, this);
            bl = true;
        }
        if (baseTypeBinding.isTypeVariable()) {
            blockScope.problemReporter().invalidTypeVariableAsException(baseTypeBinding, this);
            bl = true;
        }
        if (baseTypeBinding.isArrayType() && ((ArrayBinding)((Object)baseTypeBinding)).leafComponentType == TypeBinding.VOID) {
            blockScope.problemReporter().variableTypeCannotBeVoidArray(this);
            bl = true;
        }
        if (baseTypeBinding != TypeBinding.ANY && baseTypeBinding != TypeBinding.UNKNOWN && baseTypeBinding.findSuperTypeErasingTo(21, true) == null) {
            blockScope.problemReporter().cannotThrowType(this.type, baseTypeBinding);
            bl = true;
        }
        if ((binding = blockScope.getBinding(this.name, 3, (InvocationSite)this, false)) != null && binding.isValidBinding()) {
            if (binding instanceof LocalVariableBinding && this.hiddenVariableDepth == 0) {
                blockScope.problemReporter().redefineArgument(this);
            } else {
                blockScope.problemReporter().localVariableHiding(this, binding, false);
            }
        }
        this.binding = new LocalVariableBinding(this, (TypeBinding)baseTypeBinding, this.modifiers, false);
        Argument.resolveAnnotations(blockScope, this.annotations, this.binding);
        blockScope.addLocalVariable(this.binding);
        this.binding.setConstant(Constant.NotAConstant);
        if (bl) {
            return null;
        }
        return baseTypeBinding;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.annotations != null) {
                int n = this.annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    this.annotations[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            if (this.annotations != null) {
                int n = this.annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    this.annotations[n2].traverse(aSTVisitor, classScope);
                    ++n2;
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, classScope);
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

