/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.CastExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.NullLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.SynchronizedStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.TryStatement;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class ReturnStatement
extends Statement {
    public Expression expression;
    public SubRoutineStatement[] subroutines;
    public LocalVariableBinding saveValueVariable;
    public int initStateIndex = -1;

    public ReturnStatement(Expression expression, int n, int n2) {
        this.sourceStart = n;
        this.sourceEnd = n2;
        this.expression = expression;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        boolean bl;
        if (this.expression != null) {
            flowInfo = this.expression.analyseCode(blockScope, flowContext, flowInfo);
        }
        FlowContext flowContext2 = flowContext;
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = bl = this.expression != null && this.expression.constant == Constant.NotAConstant && !(this.expression instanceof NullLiteral);
        do {
            SubRoutineStatement subRoutineStatement;
            if ((subRoutineStatement = flowContext2.subroutine()) != null) {
                if (this.subroutines == null) {
                    this.subroutines = new SubRoutineStatement[5];
                }
                if (n == this.subroutines.length) {
                    this.subroutines = new SubRoutineStatement[n * 2];
                    System.arraycopy(this.subroutines, 0, this.subroutines, 0, n);
                }
                this.subroutines[n++] = subRoutineStatement;
                if (subRoutineStatement.isSubRoutineEscaping()) {
                    bl2 = false;
                    this.bits |= 0x20000000;
                    break;
                }
            }
            flowContext2.recordReturnFrom(flowInfo.unconditionalInits());
            if (flowContext2 instanceof InsideSubRoutineFlowContext) {
                ASTNode aSTNode = flowContext2.associatedNode;
                if (aSTNode instanceof SynchronizedStatement) {
                    this.bits |= 0x40000000;
                    continue;
                }
                if (!(aSTNode instanceof TryStatement)) continue;
                TryStatement tryStatement = (TryStatement)aSTNode;
                flowInfo.addInitializationsFrom(tryStatement.subRoutineInits);
                if (!bl) continue;
                if (this.saveValueVariable == null) {
                    this.prepareSaveValueLocation(tryStatement);
                }
                bl2 = true;
                continue;
            }
            if (!(flowContext2 instanceof InitializationFlowContext)) continue;
            blockScope.problemReporter().cannotReturnOutsideFunction(this);
            return FlowInfo.DEAD_END;
        } while ((flowContext2 = flowContext2.parent) != null);
        if (this.subroutines != null && n != this.subroutines.length) {
            this.subroutines = new SubRoutineStatement[n];
            System.arraycopy(this.subroutines, 0, this.subroutines, 0, n);
        }
        if (bl2) {
            if (this.saveValueVariable != null) {
                this.saveValueVariable.useFlag = 1;
            }
        } else {
            this.saveValueVariable = null;
            if ((this.bits & 0x40000000) == 0 && this.expression != null && this.expression.resolvedType == TypeBinding.BOOLEAN) {
                this.expression.bits |= 0x10;
            }
        }
        return FlowInfo.DEAD_END;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        boolean bl = false;
        if (this.expression != null && this.expression.constant == Constant.NotAConstant && !(this.expression instanceof NullLiteral)) {
            bl = true;
            this.expression.generateCode(blockScope, codeStream, this.needValue());
            this.generateStoreSaveValueIfNecessary(codeStream);
        }
        if (this.subroutines != null) {
            BaseTypeBinding baseTypeBinding = this.expression == null ? TypeBinding.VOID : this.expression.reusableJSRTarget();
            int n2 = 0;
            int n3 = this.subroutines.length;
            while (n2 < n3) {
                SubRoutineStatement subRoutineStatement = this.subroutines[n2];
                boolean bl2 = subRoutineStatement.generateSubRoutineInvocation(blockScope, codeStream, baseTypeBinding, this.initStateIndex, this.saveValueVariable);
                if (bl2) {
                    codeStream.recordPositionsFrom(n, this.sourceStart);
                    SubRoutineStatement.reenterAllExceptionHandlers(this.subroutines, n2, codeStream);
                    return;
                }
                ++n2;
            }
        }
        if (this.saveValueVariable != null) {
            codeStream.addVariable(this.saveValueVariable);
            codeStream.load(this.saveValueVariable);
        }
        if (this.expression != null && !bl) {
            this.expression.generateCode(blockScope, codeStream, true);
            this.generateStoreSaveValueIfNecessary(codeStream);
        }
        this.generateReturnBytecode(codeStream);
        if (this.saveValueVariable != null) {
            codeStream.removeVariable(this.saveValueVariable);
        }
        if (this.initStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.initStateIndex);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.initStateIndex);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
        SubRoutineStatement.reenterAllExceptionHandlers(this.subroutines, -1, codeStream);
    }

    public void generateReturnBytecode(CodeStream codeStream) {
        codeStream.generateReturnBytecode(this.expression);
    }

    public void generateStoreSaveValueIfNecessary(CodeStream codeStream) {
        if (this.saveValueVariable != null) {
            codeStream.store(this.saveValueVariable, false);
        }
    }

    public boolean needValue() {
        return this.saveValueVariable != null || (this.bits & 0x40000000) != 0 || (this.bits & 0x20000000) == 0;
    }

    public void prepareSaveValueLocation(TryStatement tryStatement) {
        this.saveValueVariable = tryStatement.secretReturnValue;
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        ReturnStatement.printIndent(n, stringBuffer).append("return ");
        if (this.expression != null) {
            this.expression.printExpression(0, stringBuffer);
        }
        return stringBuffer.append(';');
    }

    public void resolve(BlockScope blockScope) {
        BaseTypeBinding baseTypeBinding;
        MethodBinding methodBinding;
        MethodScope methodScope = blockScope.methodScope();
        if (methodScope == null) {
            blockScope.problemReporter().cannotReturnOutsideFunction(this);
            return;
        }
        Object object = methodScope.referenceContext instanceof AbstractMethodDeclaration ? ((methodBinding = ((AbstractMethodDeclaration)methodScope.referenceContext).binding) == null ? null : methodBinding.returnType) : (baseTypeBinding = TypeBinding.VOID);
        if (baseTypeBinding == TypeBinding.VOID) {
            if (this.expression == null) {
                return;
            }
            TypeBinding typeBinding = this.expression.resolveType(blockScope);
            if (typeBinding != null) {
                blockScope.problemReporter().attemptToReturnNonVoidExpression(this, typeBinding);
            }
            return;
        }
        if (this.expression == null) {
            if (baseTypeBinding != null) {
                blockScope.problemReporter().shouldReturn(baseTypeBinding, this);
            }
            return;
        }
        this.expression.setExpectedType(baseTypeBinding);
        TypeBinding typeBinding = this.expression.resolveType(blockScope);
        if (typeBinding == null) {
            return;
        }
        if (typeBinding == TypeBinding.VOID) {
            blockScope.problemReporter().attemptToReturnVoidValue(this);
            return;
        }
        if (baseTypeBinding == null) {
            return;
        }
        if (baseTypeBinding != typeBinding) {
            blockScope.compilationUnitScope().recordTypeConversion(baseTypeBinding, typeBinding);
        }
        if (this.expression.isConstantValueOfTypeAssignableToType(typeBinding, baseTypeBinding) || typeBinding.isCompatibleWith(baseTypeBinding)) {
            this.expression.computeConversion(blockScope, baseTypeBinding, typeBinding);
            if (typeBinding.needsUncheckedConversion(baseTypeBinding)) {
                blockScope.problemReporter().unsafeTypeConversion(this.expression, typeBinding, baseTypeBinding);
            }
            if (this.expression instanceof CastExpression && (this.expression.bits & 0x4020) == 0) {
                CastExpression.checkNeedForAssignedCast(blockScope, baseTypeBinding, (CastExpression)this.expression);
            }
            return;
        }
        if (blockScope.isBoxingCompatibleWith(typeBinding, baseTypeBinding) || typeBinding.isBaseType() && blockScope.compilerOptions().sourceLevel >= 0x310000L && !baseTypeBinding.isBaseType() && this.expression.isConstantValueOfTypeAssignableToType(typeBinding, blockScope.environment().computeBoxingType(baseTypeBinding))) {
            this.expression.computeConversion(blockScope, baseTypeBinding, typeBinding);
            if (this.expression instanceof CastExpression && (this.expression.bits & 0x4020) == 0) {
                CastExpression.checkNeedForAssignedCast(blockScope, baseTypeBinding, (CastExpression)this.expression);
            }
            return;
        }
        blockScope.problemReporter().typeMismatchError(typeBinding, baseTypeBinding, this.expression);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.expression != null) {
            this.expression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

