/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.problem;

import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.infer.InferredType;

public class AbortCompilation
extends RuntimeException {
    public CompilationResult compilationResult;
    public Throwable exception;
    public CategorizedProblem problem;
    public boolean isSilent;
    public RuntimeException silentException;
    private static final long serialVersionUID = -2047226595083244852L;

    public AbortCompilation() {
    }

    public AbortCompilation(CompilationResult compilationResult, CategorizedProblem categorizedProblem) {
        this();
        this.compilationResult = compilationResult;
        this.problem = categorizedProblem;
    }

    public AbortCompilation(CompilationResult compilationResult, Throwable throwable) {
        this();
        this.compilationResult = compilationResult;
        this.exception = throwable;
    }

    public AbortCompilation(boolean bl, RuntimeException runtimeException) {
        this();
        this.isSilent = bl;
        this.silentException = runtimeException;
    }

    public void updateContext(InvocationSite invocationSite, CompilationResult compilationResult) {
        if (this.problem == null) {
            return;
        }
        if (this.problem.getSourceStart() != 0 || this.problem.getSourceEnd() != 0) {
            return;
        }
        this.problem.setSourceStart(invocationSite.sourceStart());
        this.problem.setSourceEnd(invocationSite.sourceEnd());
        int[] nArray = compilationResult.getLineSeparatorPositions();
        this.problem.setSourceLineNumber(Util.getLineNumber(invocationSite.sourceStart(), nArray, 0, nArray.length - 1));
        this.compilationResult = compilationResult;
    }

    public void updateContext(ASTNode aSTNode, CompilationResult compilationResult) {
        if (this.problem == null) {
            return;
        }
        if (this.problem.getSourceStart() != 0 || this.problem.getSourceEnd() != 0) {
            return;
        }
        this.problem.setSourceStart(aSTNode.sourceStart());
        this.problem.setSourceEnd(aSTNode.sourceEnd());
        int[] nArray = compilationResult.getLineSeparatorPositions();
        this.problem.setSourceLineNumber(Util.getLineNumber(aSTNode.sourceStart(), nArray, 0, nArray.length - 1));
    }

    public void updateContext(InferredType inferredType, CompilationResult compilationResult) {
        if (this.problem == null) {
            return;
        }
        if (this.problem.getSourceStart() != 0 || this.problem.getSourceEnd() != 0) {
            return;
        }
        this.problem.setSourceStart(inferredType.sourceStart);
        this.problem.setSourceEnd(inferredType.sourceEnd);
        int[] nArray = compilationResult.getLineSeparatorPositions();
        this.problem.setSourceLineNumber(Util.getLineNumber(inferredType.sourceStart, nArray, 0, nArray.length - 1));
        this.compilationResult = compilationResult;
    }
}

