/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class GenericXMLWriter
extends PrintWriter {
    private static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private String lineSeparator;
    private int tab = 0;

    private static void appendEscapedChar(StringBuffer stringBuffer, char c) {
        String string = GenericXMLWriter.getReplacement(c);
        if (string != null) {
            stringBuffer.append('&');
            stringBuffer.append(string);
            stringBuffer.append(';');
        } else {
            stringBuffer.append(c);
        }
    }

    private static String getEscaped(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        int n = 0;
        while (n < string.length()) {
            GenericXMLWriter.appendEscapedChar(stringBuffer, string.charAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }

    public GenericXMLWriter(OutputStream outputStream, String string, boolean bl) {
        this(new PrintWriter(outputStream), string, bl);
    }

    public GenericXMLWriter(Writer writer, String string, boolean bl) {
        super(writer);
        this.lineSeparator = string;
        if (bl) {
            this.print(XML_VERSION);
            this.print(this.lineSeparator);
        }
    }

    public void endTag(String string, boolean bl, boolean bl2) {
        --this.tab;
        this.printTag(String.valueOf('/') + string, null, bl, bl2, false);
    }

    public void printString(String string, boolean bl, boolean bl2) {
        if (bl) {
            this.printTabulation();
        }
        this.print(string);
        if (bl2) {
            this.print(this.lineSeparator);
        }
    }

    private void printTabulation() {
        int n = 0;
        while (n < this.tab) {
            this.print('\t');
            ++n;
        }
    }

    public void printTag(String string, HashMap hashMap, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            this.printTabulation();
        }
        this.print('<');
        this.print(string);
        if (hashMap != null) {
            int n = hashMap.size();
            Map.Entry[] entryArray = new Map.Entry[n];
            hashMap.entrySet().toArray(entryArray);
            Arrays.sort(entryArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    Map.Entry entry = (Map.Entry)object;
                    Map.Entry entry2 = (Map.Entry)object2;
                    return ((String)entry.getKey()).compareTo((String)entry2.getKey());
                }
            });
            int n2 = 0;
            while (n2 < n) {
                this.print(' ');
                this.print(entryArray[n2].getKey());
                this.print("=\"");
                this.print(GenericXMLWriter.getEscaped(String.valueOf(entryArray[n2].getValue())));
                this.print('\"');
                ++n2;
            }
        }
        if (bl3) {
            this.print("/>");
        } else {
            this.print(">");
        }
        if (bl2) {
            this.print(this.lineSeparator);
        }
        if (hashMap != null && !bl3) {
            ++this.tab;
        }
    }

    public void startTag(String string, boolean bl) {
        this.printTag(string, null, bl, true, false);
        ++this.tab;
    }
}

