/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.util;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;

public final class HashtableOfBinding {
    public char[][] keyTable;
    public Binding[] valueTable;
    public int elementSize = 0;
    int threshold;

    public HashtableOfBinding() {
        this(3);
    }

    public HashtableOfBinding(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.keyTable = new char[n2][];
        this.valueTable = new Binding[n2];
    }

    public boolean containsKey(char[] cArray) {
        char[] cArray2;
        int n = this.keyTable.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                return true;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return false;
    }

    public Binding get(char[] cArray) {
        char[] cArray2;
        int n = this.keyTable.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    public Binding put(char[] cArray, Binding binding) {
        char[] cArray2;
        int n = this.keyTable.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                this.valueTable[n2] = binding;
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.keyTable[n2] = cArray;
        this.valueTable[n2] = binding;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return binding;
    }

    private void rehash() {
        HashtableOfBinding hashtableOfBinding = new HashtableOfBinding(this.elementSize < 100 ? 100 : this.elementSize * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            char[] cArray = this.keyTable[n];
            if (cArray == null) continue;
            hashtableOfBinding.put(cArray, this.valueTable[n]);
        }
        this.keyTable = hashtableOfBinding.keyTable;
        this.valueTable = hashtableOfBinding.valueTable;
        this.threshold = hashtableOfBinding.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String string = "";
        int n = 0;
        int n2 = this.valueTable.length;
        while (n < n2) {
            Binding binding = this.valueTable[n];
            if (binding != null) {
                string = String.valueOf(string) + binding.toString() + "\n";
            }
            ++n;
        }
        return string;
    }
}

