/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryField;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryNestedType;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.BinaryField;
import org.eclipse.wst.jsdt.internal.core.BinaryMember;
import org.eclipse.wst.jsdt.internal.core.BinaryMethod;
import org.eclipse.wst.jsdt.internal.core.BinaryType;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.OpenableElementInfo;
import org.eclipse.wst.jsdt.internal.core.TypeParameter;
import org.eclipse.wst.jsdt.internal.core.TypeParameterElementInfo;

class ClassFileInfo
extends OpenableElementInfo
implements SuffixConstants {
    protected JavaElement[] binaryChildren = null;
    protected ITypeParameter[] typeParameters;

    ClassFileInfo() {
    }

    private void generateFieldInfos(IType iType, IBinaryType iBinaryType, HashMap hashMap, ArrayList arrayList) {
        IBinaryField[] iBinaryFieldArray = iBinaryType.getFields();
        if (iBinaryFieldArray == null) {
            return;
        }
        JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
        int n = 0;
        int n2 = iBinaryFieldArray.length;
        while (n < n2) {
            IBinaryField iBinaryField = iBinaryFieldArray[n];
            BinaryField binaryField = new BinaryField((JavaElement)((Object)iType), javaModelManager.intern(new String(iBinaryField.getName())));
            hashMap.put(binaryField, iBinaryField);
            arrayList.add(binaryField);
            ++n;
        }
    }

    private void generateInnerClassHandles(IType iType, IBinaryType iBinaryType, ArrayList arrayList) {
        IBinaryNestedType[] iBinaryNestedTypeArray = iBinaryType.getMemberTypes();
        if (iBinaryNestedTypeArray != null) {
            IPackageFragment iPackageFragment = (IPackageFragment)iType.getAncestor(4);
            int n = 0;
            int n2 = iBinaryNestedTypeArray.length;
            while (n < n2) {
                IBinaryNestedType iBinaryNestedType = iBinaryNestedTypeArray[n];
                IClassFile iClassFile = iPackageFragment.getClassFile(String.valueOf(new String(ClassFile.unqualifiedName(iBinaryNestedType.getName()))) + ".js");
                BinaryType binaryType = new BinaryType((JavaElement)((Object)iClassFile), ClassFile.simpleName(iBinaryNestedType.getName()));
                arrayList.add(binaryType);
                ++n;
            }
        }
    }

    private void generateMethodInfos(IType iType, IBinaryType iBinaryType, HashMap hashMap, ArrayList arrayList, ArrayList arrayList2) {
        IBinaryMethod[] iBinaryMethodArray = iBinaryType.getMethods();
        if (iBinaryMethodArray == null) {
            return;
        }
        int n = 0;
        int n2 = iBinaryMethodArray.length;
        while (n < n2) {
            IBinaryMethod iBinaryMethod = iBinaryMethodArray[n];
            char[] cArray = iBinaryMethod.getGenericSignature();
            if (cArray == null) {
                cArray = iBinaryMethod.getMethodDescriptor();
            }
            String[] stringArray = null;
            try {
                stringArray = Signature.getParameterTypes(new String(cArray));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                cArray = iBinaryMethod.getMethodDescriptor();
                stringArray = Signature.getParameterTypes(new String(cArray));
            }
            char[][] cArrayArray = new char[stringArray.length][];
            int n3 = 0;
            while (n3 < stringArray.length) {
                cArrayArray[n3] = stringArray[n3].toCharArray();
                ++n3;
            }
            char[][] cArray2 = ClassFile.translatedNames(cArrayArray);
            JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
            String string = new String(iBinaryMethod.getSelector());
            if (iBinaryMethod.isConstructor()) {
                string = iType.getElementName();
            }
            string = javaModelManager.intern(string);
            int n4 = 0;
            while (n4 < stringArray.length) {
                stringArray[n4] = javaModelManager.intern(new String(cArray2[n4]));
                ++n4;
            }
            BinaryMethod binaryMethod = new BinaryMethod((JavaElement)((Object)iType), string, stringArray);
            arrayList.add(binaryMethod);
            while (hashMap.containsKey(binaryMethod)) {
                ++binaryMethod.occurrenceCount;
            }
            hashMap.put(binaryMethod, iBinaryMethod);
            this.generateTypeParameterInfos(binaryMethod, cArray, hashMap, arrayList2);
            ++n;
        }
    }

    private void generateTypeParameterInfos(BinaryMember binaryMember, char[] cArray, HashMap hashMap, ArrayList arrayList) {
        if (cArray == null) {
            return;
        }
        char[][] cArray2 = Signature.getTypeParameters(cArray);
        int n = 0;
        int n2 = cArray2.length;
        while (n < n2) {
            char[] cArray3 = cArray2[n];
            char[] cArray4 = Signature.getTypeVariable(cArray3);
            char[][] cArray5 = Signature.getTypeParameterBounds(cArray3);
            int n3 = cArray5.length;
            char[][] cArrayArray = new char[n3][];
            int n4 = 0;
            while (n4 < n3) {
                cArrayArray[n4] = Signature.toCharArray(cArray5[n4]);
                CharOperation.replace(cArrayArray[n4], '/', '.');
                ++n4;
            }
            TypeParameter typeParameter = new TypeParameter(binaryMember, new String(cArray4));
            TypeParameterElementInfo typeParameterElementInfo = new TypeParameterElementInfo();
            typeParameterElementInfo.bounds = cArrayArray;
            arrayList.add(typeParameter);
            while (hashMap.containsKey(typeParameter)) {
                ++typeParameter.occurrenceCount;
            }
            hashMap.put(typeParameter, typeParameterElementInfo);
            ++n;
        }
    }

    boolean hasReadBinaryChildren() {
        return this.binaryChildren != null;
    }

    protected void readBinaryChildren(ClassFile classFile, HashMap hashMap, IBinaryType iBinaryType) {
        ArrayList arrayList = new ArrayList();
        BinaryType binaryType = (BinaryType)classFile.getType();
        ArrayList arrayList2 = new ArrayList();
        if (iBinaryType != null) {
            this.generateTypeParameterInfos(binaryType, iBinaryType.getGenericSignature(), hashMap, arrayList2);
            this.generateFieldInfos(binaryType, iBinaryType, hashMap, arrayList);
            this.generateMethodInfos(binaryType, iBinaryType, hashMap, arrayList, arrayList2);
            this.generateInnerClassHandles(binaryType, iBinaryType, arrayList);
        }
        this.binaryChildren = new JavaElement[arrayList.size()];
        arrayList.toArray(this.binaryChildren);
        int n = arrayList2.size();
        if (n == 0) {
            this.typeParameters = TypeParameter.NO_TYPE_PARAMETERS;
        } else {
            this.typeParameters = new ITypeParameter[n];
            arrayList2.toArray(this.typeParameters);
        }
    }

    void removeBinaryChildren() throws JavaModelException {
        JavaElement javaElement;
        int n;
        JavaModelManager javaModelManager;
        if (this.binaryChildren != null) {
            javaModelManager = JavaModelManager.getJavaModelManager();
            n = 0;
            while (n < this.binaryChildren.length) {
                javaElement = this.binaryChildren[n];
                if (javaElement instanceof BinaryType) {
                    javaModelManager.removeInfoAndChildren((JavaElement)javaElement.getParent());
                } else {
                    javaModelManager.removeInfoAndChildren(javaElement);
                }
                ++n;
            }
            this.binaryChildren = JavaElement.NO_ELEMENTS;
        }
        if (this.typeParameters != null) {
            javaModelManager = JavaModelManager.getJavaModelManager();
            n = 0;
            while (n < this.typeParameters.length) {
                javaElement = (TypeParameter)this.typeParameters[n];
                javaModelManager.removeInfoAndChildren(javaElement);
                ++n;
            }
            this.typeParameters = TypeParameter.NO_TYPE_PARAMETERS;
        }
    }
}

