/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IClasspathAttribute;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.core.ClasspathAttribute;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.NameLookup;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;
import org.eclipse.wst.jsdt.internal.core.search.IRestrictedAccessBindingRequestor;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchScope;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class DocumentContextFragmentRoot
extends PackageFragmentRoot {
    private static final ClasspathAttribute HIDE = new ClasspathAttribute("hide", "true");
    private String[] includedFiles;
    private IFile fRelativeFile;
    private IResource absolutePath;
    private IPath webContext;
    private IClasspathEntry rawClassPathEntry;
    private static final boolean DEBUG = false;
    private static int instances = 0;
    private ICompilationUnit[] workingCopies;
    private String[] fSystemFiles;
    private RestrictedDocumentBinding importPolice;

    public String[] getProjectSystemFiles() {
        int n;
        if (this.fSystemFiles != null) {
            return this.fSystemFiles;
        }
        IJavaProject iJavaProject = this.getJavaProject();
        int n2 = 0;
        IPackageFragmentRoot[] iPackageFragmentRootArray = null;
        try {
            iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
            n = 0;
            while (n < iPackageFragmentRootArray.length) {
                if (iPackageFragmentRootArray[n].isLanguageRuntime()) {
                    iPackageFragmentRootArray[n2++] = iPackageFragmentRootArray[n];
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {
            iPackageFragmentRootArray = new IPackageFragmentRoot[]{};
        }
        this.fSystemFiles = new String[n2];
        n = 0;
        while (n < this.fSystemFiles.length) {
            this.fSystemFiles[n] = iPackageFragmentRootArray[n].getPath().toString().intern();
            ++n;
        }
        return this.fSystemFiles;
    }

    public void classpathChange() {
        this.fSystemFiles = null;
    }

    public DocumentContextFragmentRoot(IJavaProject iJavaProject, IFile iFile, IPath iPath, IPath iPath2, IClasspathEntry iClasspathEntry) {
        super((IResource)iFile, (JavaProject)iJavaProject);
        this.fRelativeFile = iFile;
        this.absolutePath = ((IContainer)iJavaProject.getResource()).findMember(iPath);
        this.webContext = iPath2;
        this.rawClassPathEntry = iClasspathEntry;
    }

    public void finalize() {
    }

    public IClasspathEntry getRawClasspathEntry() throws JavaModelException {
        if (this.rawClassPathEntry != null) {
            return this.rawClassPathEntry;
        }
        return super.getRawClasspathEntry();
    }

    protected RestrictedDocumentBinding getRestrictedAccessRequestor() {
        if (this.importPolice == null) {
            this.importPolice = new RestrictedDocumentBinding();
        }
        this.importPolice.reset();
        return this.importPolice;
    }

    public DocumentContextFragmentRoot(IJavaProject iJavaProject, IFile iFile, IPath iPath, IPath iPath2) {
        this(iJavaProject, iFile, iPath, iPath2, null);
    }

    public DocumentContextFragmentRoot(IJavaProject iJavaProject, IFile iFile) {
        this(iJavaProject, iFile, (IPath)new Path(""), (IPath)new Path(""));
    }

    public void setIncludedFiles(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            File file = this.isValidImport(stringArray[n2]);
            if (file != null) {
                IPath iPath = this.resolveChildPath(stringArray[n2]);
                stringArray2[n++] = iPath.toString();
            }
            ++n2;
        }
        n2 = this.includedFiles != null && n == this.includedFiles.length ? 1 : 0;
        int n3 = 0;
        while (n2 != 0 && n3 < n) {
            if (stringArray2[n3].compareTo(this.includedFiles[n3]) != 0) {
                n2 = 0;
            }
            ++n3;
        }
        if (n2 != 0) {
            return;
        }
        this.includedFiles = new String[n];
        System.arraycopy(stringArray2, 0, this.includedFiles, 0, n);
        this.updateClasspathIfNeeded();
    }

    private void removeStaleClasspath(String[] stringArray) {
    }

    private void updateClasspathIfNeeded() {
        IClasspathEntry[] iClasspathEntryArray;
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
        IJavaProject iJavaProject = this.getJavaProject();
        IResource iResource = this.getResource();
        IContainer iContainer = (IContainer)iResource;
        int n = 0;
        while (n < this.includedFiles.length) {
            iClasspathEntryArray = iContainer.findMember(this.includedFiles[n]);
            if (!iJavaProject.isOnClasspath((IResource)iClasspathEntryArray)) {
                IClasspathEntry iClasspathEntry = JavaCore.newLibraryEntry(iClasspathEntryArray.getLocation().makeAbsolute(), null, null, new IAccessRule[0], new IClasspathAttribute[]{HIDE}, true);
                arrayList.add(iClasspathEntry);
            }
            ++n;
        }
        IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[]{};
        try {
            iClasspathEntryArray2 = iJavaProject.getRawClasspath();
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
        iClasspathEntryArray = new IClasspathEntry[arrayList.size() + iClasspathEntryArray2.length];
        System.arraycopy(iClasspathEntryArray2, 0, iClasspathEntryArray, 0, iClasspathEntryArray2.length);
        int n2 = 0;
        int n3 = iClasspathEntryArray2.length;
        while (n3 < iClasspathEntryArray.length) {
            iClasspathEntryArray[n3] = (IClasspathEntry)arrayList.get(n2++);
            ++n3;
        }
        try {
            iJavaProject.setRawClasspath(iClasspathEntryArray, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException javaModelException) {}
    }

    public IPath resolveChildPath(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new Path("");
        }
        Path path = null;
        switch (string.charAt(0)) {
            default: {
                path = new Path(string);
                IResource iResource = ((IContainer)this.getResource()).findMember((IPath)path);
                if (iResource != null && iResource.exists()) break;
            }
            case '/': 
            case '\\': {
                Path path2 = new Path(string);
                IPath iPath = path2.removeFirstSegments(path2.matchingFirstSegments(this.webContext));
                IResource iResource = ((IContainer)this.getResource()).findMember(iPath);
                path = iPath;
                if (iResource != null && iResource.exists()) break;
            }
            case '.': {
                IPath iPath = null;
                try {
                    iPath = this.fRelativeFile.getFullPath().removeLastSegments(1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                IPath iPath2 = this.getResource().getFullPath();
                if (!iPath2.isPrefixOf(iPath)) break;
                IPath iPath3 = iPath.removeFirstSegments(iPath2.matchingFirstSegments(iPath));
                path = iPath3.append(string);
            }
        }
        return path;
    }

    public IPath getPath() {
        return this.fRelativeFile.getFullPath().removeLastSegments(1);
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof DocumentContextFragmentRoot)) {
            return false;
        }
        DocumentContextFragmentRoot documentContextFragmentRoot = (DocumentContextFragmentRoot)object;
        boolean bl2 = bl = this.fRelativeFile.equals((Object)documentContextFragmentRoot.fRelativeFile) && this.includedFiles != null && documentContextFragmentRoot.includedFiles != null && this.includedFiles.length == documentContextFragmentRoot.includedFiles.length;
        if (!bl) {
            return bl;
        }
        int n = 0;
        while (n < this.includedFiles.length) {
            if (!this.includedFiles[n].equals(documentContextFragmentRoot.includedFiles[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getElementName() {
        return this.fRelativeFile.getName();
    }

    public int hashCode() {
        return this.fRelativeFile.hashCode();
    }

    public boolean isExternal() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    protected boolean resourceExists() {
        return true;
    }

    public SearchableEnvironment newSearchableNameEnvironment(WorkingCopyOwner workingCopyOwner) throws JavaModelException {
        SearchableEnvironment searchableEnvironment = super.newSearchableNameEnvironment(workingCopyOwner);
        int n = 15;
        searchableEnvironment.nameLookup.setRestrictedAccessRequestor(this.getRestrictedAccessRequestor());
        ((JavaSearchScope)searchableEnvironment.searchScope).add((JavaProject)this.getJavaProject(), n, new HashSet(2));
        return searchableEnvironment;
    }

    public NameLookup newNameLookup(ICompilationUnit[] iCompilationUnitArray) throws JavaModelException {
        this.workingCopies = iCompilationUnitArray;
        NameLookup nameLookup = super.newNameLookup(this.workingCopies);
        nameLookup.setRestrictedAccessRequestor(this.getRestrictedAccessRequestor());
        return nameLookup;
    }

    public NameLookup newNameLookup(WorkingCopyOwner workingCopyOwner) throws JavaModelException {
        NameLookup nameLookup = super.newNameLookup(workingCopyOwner);
        nameLookup.setRestrictedAccessRequestor(this.getRestrictedAccessRequestor());
        return nameLookup;
    }

    public File isValidImport(String string) {
        boolean bl;
        IPath iPath = this.resolveChildPath(string);
        if (iPath == null) {
            return null;
        }
        File file = iPath.toFile();
        if (file.isFile()) {
            return file;
        }
        new Path(string);
        IFile iFile = null;
        try {
            iFile = ((IContainer)this.getResource()).getFile((IPath)new Path(file.getPath()));
        }
        catch (Exception exception) {}
        boolean bl2 = bl = iFile != null && iFile.exists();
        if (string.charAt(0) == '\\' || string.charAt(0) == '/') {
            int n = iFile.getFullPath().matchingFirstSegments(this.webContext);
            boolean bl3 = bl = bl && this.webContext != new Path("") && n > 0;
        }
        if (bl) {
            return new File(iFile.getLocation().toString());
        }
        return null;
    }

    public int getKind() throws JavaModelException {
        return 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Relative to: " + this.fRelativeFile.getName() + "\n");
        stringBuffer.append("Absolute to: " + this.webContext + "\n");
        stringBuffer.append("Included File\t\t\tLast Moddified\n");
        int n = 0;
        while (n < this.includedFiles.length) {
            stringBuffer.append(String.valueOf(this.includedFiles[n]) + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public IResource getResource() {
        return this.absolutePath;
    }

    class RestrictedDocumentBinding
    implements IRestrictedAccessBindingRequestor {
        private ArrayList foundPaths = new ArrayList();
        private String exclude;
        private boolean shown;

        RestrictedDocumentBinding() {
        }

        public void reset() {
            this.foundPaths.clear();
            this.shown = false;
        }

        public boolean acceptBinding(int n, int n2, char[] cArray, char[] cArray2, String string, AccessRestriction accessRestriction) {
            if (string != null && this.exclude != null && string.compareTo(this.exclude) == 0) {
                return false;
            }
            int n3 = 0;
            while (DocumentContextFragmentRoot.this.workingCopies != null && n3 < DocumentContextFragmentRoot.this.workingCopies.length) {
                if (DocumentContextFragmentRoot.this.workingCopies[n3].getPath().toString().equals(string)) {
                    return false;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < DocumentContextFragmentRoot.this.includedFiles.length) {
                if (Util.isSameResourceString(string, DocumentContextFragmentRoot.this.includedFiles[n3])) {
                    this.foundPaths.add(string);
                    return true;
                }
                ++n3;
            }
            String[] stringArray = DocumentContextFragmentRoot.this.getProjectSystemFiles();
            int n4 = 0;
            while (n4 < stringArray.length) {
                if (Util.isSameResourceString(string, stringArray[n4])) {
                    this.foundPaths.add(string);
                    return true;
                }
                ++n4;
            }
            return false;
        }

        public String getFoundPath() {
            return this.foundPaths.size() > 0 ? (String)this.foundPaths.get(0) : null;
        }

        public ArrayList getFoundPaths() {
            return this.foundPaths;
        }

        public void setExcludePath(String string) {
            this.exclude = string;
        }
    }
}

