/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.core.JarPackageFragment;
import org.eclipse.wst.jsdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.OverflowingLRUCache;
import org.eclipse.wst.jsdt.internal.core.util.LRUCache;

public class ElementCache
extends OverflowingLRUCache {
    IJavaElement spaceLimitParent = null;

    public ElementCache(int n) {
        super(n);
    }

    public ElementCache(int n, int n2) {
        super(n, n2);
    }

    protected boolean close(LRUCache.LRUCacheEntry lRUCacheEntry) {
        Openable openable;
        block5: {
            openable = (Openable)lRUCacheEntry._fKey;
            try {
                if (openable.canBeRemovedFromCache()) break block5;
                return false;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        if (openable instanceof JarPackageFragment) {
            JarPackageFragment jarPackageFragment = (JarPackageFragment)openable;
            JarPackageFragmentRoot jarPackageFragmentRoot = (JarPackageFragmentRoot)jarPackageFragment.getParent();
            jarPackageFragmentRoot.close();
        } else {
            openable.close();
        }
        return true;
    }

    protected void ensureSpaceLimit(int n, IJavaElement iJavaElement) {
        int n2 = 1 + (int)((1.0 + this.fLoadFactor) * (double)(n + this.fOverflow));
        if (this.fSpaceLimit < n2) {
            this.shrink();
            this.setSpaceLimit(n2);
            this.spaceLimitParent = iJavaElement;
        }
    }

    protected LRUCache newInstance(int n, int n2) {
        return new ElementCache(n, n2);
    }

    protected void resetSpaceLimit(int n, IJavaElement iJavaElement) {
        if (iJavaElement.equals(this.spaceLimitParent)) {
            this.setSpaceLimit(n);
            this.spaceLimitParent = null;
        }
    }
}

