/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.CopyElementsOperation;
import org.eclipse.wst.jsdt.internal.core.CopyResourceElementsOperation;
import org.eclipse.wst.jsdt.internal.core.DeleteElementsOperation;
import org.eclipse.wst.jsdt.internal.core.DeleteResourceElementsOperation;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModelInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.MoveElementsOperation;
import org.eclipse.wst.jsdt.internal.core.MoveResourceElementsOperation;
import org.eclipse.wst.jsdt.internal.core.MultiOperation;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.OpenableElementInfo;
import org.eclipse.wst.jsdt.internal.core.RenameElementsOperation;
import org.eclipse.wst.jsdt.internal.core.RenameResourceElementsOperation;
import org.eclipse.wst.jsdt.internal.core.util.MementoTokenizer;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class JavaModel
extends Openable
implements IJavaModel {
    public static HashSet existingExternalFiles = new HashSet();
    public static HashSet existingExternalConfirmedFiles = new HashSet();

    protected JavaModel() throws Error {
        super(null);
    }

    protected boolean buildStructure(OpenableElementInfo openableElementInfo, IProgressMonitor iProgressMonitor, Map map, IResource iResource) {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        IJavaElement[] iJavaElementArray = new IJavaElement[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            IProject iProject = iProjectArray[n3];
            if (JavaProject.hasJavaNature(iProject)) {
                iJavaElementArray[n2++] = this.getJavaProject((IResource)iProject);
            }
            ++n3;
        }
        if (n2 < n) {
            IJavaElement[] iJavaElementArray2 = iJavaElementArray;
            iJavaElementArray = new IJavaElement[n2];
            System.arraycopy(iJavaElementArray2, 0, iJavaElementArray, 0, n2);
        }
        openableElementInfo.setChildren(iJavaElementArray);
        map.put(this, openableElementInfo);
        return true;
    }

    public boolean contains(IResource iResource) {
        IJavaProject[] iJavaProjectArray;
        switch (iResource.getType()) {
            case 4: 
            case 8: {
                return true;
            }
        }
        try {
            iJavaProjectArray = this.getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        int n = 0;
        int n2 = iJavaProjectArray.length;
        while (n < n2) {
            JavaProject javaProject = (JavaProject)iJavaProjectArray[n];
            if (!javaProject.contains(iResource)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void copy(IJavaElement[] iJavaElementArray, IJavaElement[] iJavaElementArray2, IJavaElement[] iJavaElementArray3, String[] stringArray, boolean bl, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (iJavaElementArray != null && iJavaElementArray.length > 0 && iJavaElementArray[0] != null && iJavaElementArray[0].getElementType() < 7) {
            this.runOperation(new CopyResourceElementsOperation(iJavaElementArray, iJavaElementArray2, bl), iJavaElementArray, iJavaElementArray3, stringArray, iProgressMonitor);
        } else {
            this.runOperation(new CopyElementsOperation(iJavaElementArray, iJavaElementArray2, bl), iJavaElementArray, iJavaElementArray3, stringArray, iProgressMonitor);
        }
    }

    protected Object createElementInfo() {
        return new JavaModelInfo();
    }

    public void delete(IJavaElement[] iJavaElementArray, boolean bl, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (iJavaElementArray != null && iJavaElementArray.length > 0 && iJavaElementArray[0] != null && iJavaElementArray[0].getElementType() < 7) {
            new DeleteResourceElementsOperation(iJavaElementArray, bl).runOperation(iProgressMonitor);
        } else {
            new DeleteElementsOperation(iJavaElementArray, bl).runOperation(iProgressMonitor);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof JavaModel)) {
            return false;
        }
        return super.equals(object);
    }

    public int getElementType() {
        return 1;
    }

    public static void flushExternalFileCache() {
        existingExternalFiles = new HashSet();
        existingExternalConfirmedFiles = new HashSet();
    }

    public IJavaElement getHandleFromMemento(String string, MementoTokenizer mementoTokenizer, WorkingCopyOwner workingCopyOwner) {
        switch (string.charAt(0)) {
            case '=': {
                if (!mementoTokenizer.hasMoreTokens()) {
                    return this;
                }
                String string2 = mementoTokenizer.nextToken();
                JavaElement javaElement = (JavaElement)((Object)this.getJavaProject(string2));
                return javaElement.getHandleFromMemento(mementoTokenizer, workingCopyOwner);
            }
        }
        return null;
    }

    protected void getHandleMemento(StringBuffer stringBuffer) {
        stringBuffer.append(this.getElementName());
    }

    protected char getHandleMementoDelimiter() {
        Assert.isTrue((boolean)false, (String)"Should not be called");
        return '\u0000';
    }

    public IJavaProject getJavaProject(String string) {
        return new JavaProject(ResourcesPlugin.getWorkspace().getRoot().getProject(string), this);
    }

    public IJavaProject getJavaProject(IResource iResource) {
        switch (iResource.getType()) {
            case 2: {
                return new JavaProject(((IFolder)iResource).getProject(), this);
            }
            case 1: {
                return new JavaProject(((IFile)iResource).getProject(), this);
            }
            case 4: {
                return new JavaProject((IProject)iResource, this);
            }
        }
        throw new IllegalArgumentException(Messages.element_invalidResourceForProject);
    }

    public IJavaProject[] getJavaProjects() throws JavaModelException {
        ArrayList arrayList = this.getChildrenOfType(2);
        IJavaProject[] iJavaProjectArray = new IJavaProject[arrayList.size()];
        arrayList.toArray(iJavaProjectArray);
        return iJavaProjectArray;
    }

    public Object[] getNonJavaResources() throws JavaModelException {
        return ((JavaModelInfo)this.getElementInfo()).getNonJavaResources();
    }

    public IPath getPath() {
        return Path.ROOT;
    }

    public IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public IResource getUnderlyingResource() {
        return null;
    }

    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void move(IJavaElement[] iJavaElementArray, IJavaElement[] iJavaElementArray2, IJavaElement[] iJavaElementArray3, String[] stringArray, boolean bl, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (iJavaElementArray != null && iJavaElementArray.length > 0 && iJavaElementArray[0] != null && iJavaElementArray[0].getElementType() < 7) {
            this.runOperation(new MoveResourceElementsOperation(iJavaElementArray, iJavaElementArray2, bl), iJavaElementArray, iJavaElementArray3, stringArray, iProgressMonitor);
        } else {
            this.runOperation(new MoveElementsOperation(iJavaElementArray, iJavaElementArray2, bl), iJavaElementArray, iJavaElementArray3, stringArray, iProgressMonitor);
        }
    }

    public void refreshExternalArchives(IJavaElement[] iJavaElementArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (iJavaElementArray == null) {
            iJavaElementArray = new IJavaElement[]{this};
        }
        JavaModelManager.getJavaModelManager().getDeltaProcessor().checkExternalArchiveChanges(iJavaElementArray, iProgressMonitor);
    }

    public void rename(IJavaElement[] iJavaElementArray, IJavaElement[] iJavaElementArray2, String[] stringArray, boolean bl, IProgressMonitor iProgressMonitor) throws JavaModelException {
        MultiOperation multiOperation = iJavaElementArray != null && iJavaElementArray.length > 0 && iJavaElementArray[0] != null && iJavaElementArray[0].getElementType() < 7 ? new RenameResourceElementsOperation(iJavaElementArray, iJavaElementArray2, stringArray, bl) : new RenameElementsOperation(iJavaElementArray, iJavaElementArray2, stringArray, bl);
        multiOperation.runOperation(iProgressMonitor);
    }

    protected void runOperation(MultiOperation multiOperation, IJavaElement[] iJavaElementArray, IJavaElement[] iJavaElementArray2, String[] stringArray, IProgressMonitor iProgressMonitor) throws JavaModelException {
        multiOperation.setRenamings(stringArray);
        if (iJavaElementArray2 != null) {
            int n = 0;
            while (n < iJavaElementArray.length) {
                multiOperation.setInsertBefore(iJavaElementArray[n], iJavaElementArray2[n]);
                ++n;
            }
        }
        multiOperation.runOperation(iProgressMonitor);
    }

    protected void toStringInfo(int n, StringBuffer stringBuffer, Object object, boolean bl) {
        stringBuffer.append(this.tabString(n));
        stringBuffer.append("Java Model");
        if (object == null) {
            stringBuffer.append(" (not open)");
        }
    }

    public static Object getTarget(IContainer iContainer, IPath iPath, boolean bl) {
        IResource iResource;
        if (iPath == null) {
            return null;
        }
        if (iPath.getDevice() == null && (iResource = iContainer.findMember(iPath)) != null) {
            if (!bl || iResource.exists()) {
                return iResource;
            }
            return null;
        }
        if (!iPath.isAbsolute()) {
            return null;
        }
        return JavaModel.getTargetAsExternalFile(iPath, bl);
    }

    private static synchronized Object getTargetAsExternalFile(IPath iPath, boolean bl) {
        File file = new File(iPath.toOSString());
        if (!bl) {
            return file;
        }
        if (existingExternalFiles.contains(file)) {
            return file;
        }
        if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
            System.out.println("(" + Thread.currentThread() + ") [JavaModel.getTarget(...)] Checking existence of " + iPath.toString());
        }
        if (file.exists()) {
            existingExternalFiles.add(file);
            return file;
        }
        return null;
    }

    public static boolean isFile(Object object) {
        return JavaModel.getFile(object) != null;
    }

    public static synchronized File getFile(Object object) {
        File file;
        if (existingExternalConfirmedFiles.contains(object)) {
            return (File)object;
        }
        if (object instanceof File && (file = (File)object).isFile()) {
            existingExternalConfirmedFiles.add(file);
            return file;
        }
        return null;
    }
}

