/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.DocumentAdapter;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaElementDelta;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public abstract class JavaModelOperation
implements IWorkspaceRunnable,
IProgressMonitor {
    protected static final int APPEND = 1;
    protected static final int REMOVEALL_APPEND = 2;
    protected static final int KEEP_EXISTING = 3;
    protected static boolean POST_ACTION_VERBOSE;
    protected IPostAction[] actions;
    protected int actionsStart = 0;
    protected int actionsEnd = -1;
    protected HashMap attributes;
    public static final String HAS_MODIFIED_RESOURCE_ATTR = "hasModifiedResource";
    public static final String TRUE = "true";
    protected IJavaElement[] elementsToProcess;
    protected IJavaElement[] parentElements;
    protected static IJavaElement[] NO_ELEMENTS;
    protected IJavaElement[] resultElements = NO_ELEMENTS;
    public IProgressMonitor progressMonitor = null;
    protected boolean isNested = false;
    protected boolean force = false;
    protected static ThreadLocal operationStacks;

    static {
        NO_ELEMENTS = new IJavaElement[0];
        operationStacks = new ThreadLocal();
    }

    protected JavaModelOperation() {
    }

    protected JavaModelOperation(IJavaElement[] iJavaElementArray) {
        this.elementsToProcess = iJavaElementArray;
    }

    protected JavaModelOperation(IJavaElement[] iJavaElementArray, IJavaElement[] iJavaElementArray2) {
        this.elementsToProcess = iJavaElementArray;
        this.parentElements = iJavaElementArray2;
    }

    protected JavaModelOperation(IJavaElement[] iJavaElementArray, IJavaElement[] iJavaElementArray2, boolean bl) {
        this.elementsToProcess = iJavaElementArray;
        this.parentElements = iJavaElementArray2;
        this.force = bl;
    }

    protected JavaModelOperation(IJavaElement[] iJavaElementArray, boolean bl) {
        this.elementsToProcess = iJavaElementArray;
        this.force = bl;
    }

    protected JavaModelOperation(IJavaElement iJavaElement) {
        this.elementsToProcess = new IJavaElement[]{iJavaElement};
    }

    protected JavaModelOperation(IJavaElement iJavaElement, boolean bl) {
        this.elementsToProcess = new IJavaElement[]{iJavaElement};
        this.force = bl;
    }

    protected void addAction(IPostAction iPostAction) {
        int n = this.actions.length;
        if (n == ++this.actionsEnd) {
            this.actions = new IPostAction[n * 2];
            System.arraycopy(this.actions, 0, this.actions, 0, n);
        }
        this.actions[this.actionsEnd] = iPostAction;
    }

    protected void addDelta(IJavaElementDelta iJavaElementDelta) {
        JavaModelManager.getJavaModelManager().getDeltaProcessor().registerJavaModelDelta(iJavaElementDelta);
    }

    protected void addReconcileDelta(ICompilationUnit iCompilationUnit, IJavaElementDelta iJavaElementDelta) {
        HashMap hashMap = JavaModelManager.getJavaModelManager().getDeltaProcessor().reconcileDeltas;
        JavaElementDelta javaElementDelta = (JavaElementDelta)hashMap.get(iCompilationUnit);
        if (javaElementDelta != null) {
            IJavaElementDelta[] iJavaElementDeltaArray = iJavaElementDelta.getAffectedChildren();
            int n = 0;
            int n2 = iJavaElementDeltaArray.length;
            while (n < n2) {
                JavaElementDelta javaElementDelta2 = (JavaElementDelta)iJavaElementDeltaArray[n];
                javaElementDelta.insertDeltaTree(javaElementDelta2.getElement(), javaElementDelta2);
                ++n;
            }
            if ((iJavaElementDelta.getFlags() & 0x80000) != 0) {
                javaElementDelta.changedAST(iJavaElementDelta.getCompilationUnitAST());
            }
        } else {
            hashMap.put(iCompilationUnit, iJavaElementDelta);
        }
    }

    protected void removeReconcileDelta(ICompilationUnit iCompilationUnit) {
        JavaModelManager.getJavaModelManager().getDeltaProcessor().reconcileDeltas.remove(iCompilationUnit);
    }

    public void beginTask(String string, int n) {
        if (this.progressMonitor != null) {
            this.progressMonitor.beginTask(string, n);
        }
    }

    protected boolean canModifyRoots() {
        return false;
    }

    protected void checkCanceled() {
        if (this.isCanceled()) {
            throw new OperationCanceledException(Messages.operation_cancelled);
        }
    }

    protected IJavaModelStatus commonVerify() {
        if (this.elementsToProcess == null || this.elementsToProcess.length == 0) {
            return new JavaModelStatus(968);
        }
        int n = 0;
        while (n < this.elementsToProcess.length) {
            if (this.elementsToProcess[n] == null) {
                return new JavaModelStatus(968);
            }
            ++n;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    protected void copyResources(IResource[] iResourceArray, IPath iPath) throws JavaModelException {
        IProgressMonitor iProgressMonitor = this.getSubProgressMonitor(iResourceArray.length);
        IWorkspace iWorkspace = iResourceArray[0].getWorkspace();
        try {
            iWorkspace.copy(iResourceArray, iPath, false, iProgressMonitor);
            JavaModelOperation.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException coreException) {
            throw new JavaModelException(coreException);
        }
    }

    protected void createFile(IContainer iContainer, String string, InputStream inputStream, boolean bl) throws JavaModelException {
        IFile iFile = iContainer.getFile((IPath)new Path(string));
        try {
            iFile.create(inputStream, bl ? 3 : 2, this.getSubProgressMonitor(1));
            JavaModelOperation.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException coreException) {
            throw new JavaModelException(coreException);
        }
    }

    protected void createFolder(IContainer iContainer, String string, boolean bl) throws JavaModelException {
        IFolder iFolder = iContainer.getFolder((IPath)new Path(string));
        try {
            iFolder.create(bl ? 3 : 2, true, this.getSubProgressMonitor(1));
            JavaModelOperation.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException coreException) {
            throw new JavaModelException(coreException);
        }
    }

    protected void deleteEmptyPackageFragment(IPackageFragment iPackageFragment, boolean bl, IResource iResource) throws JavaModelException {
        IContainer iContainer = (IContainer)iPackageFragment.getResource();
        try {
            iContainer.delete(bl ? 3 : 2, this.getSubProgressMonitor(1));
            JavaModelOperation.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
            while (iContainer instanceof IFolder) {
                if ((iContainer = iContainer.getParent()).equals((Object)iResource) || iContainer.members().length != 0) continue;
                iContainer.delete(bl ? 3 : 2, this.getSubProgressMonitor(1));
                JavaModelOperation.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
            }
        }
        catch (CoreException coreException) {
            throw new JavaModelException(coreException);
        }
    }

    protected void deleteResource(IResource iResource, int n) throws JavaModelException {
        try {
            iResource.delete(n, this.getSubProgressMonitor(1));
            JavaModelOperation.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException coreException) {
            throw new JavaModelException(coreException);
        }
    }

    protected void deleteResources(IResource[] iResourceArray, boolean bl) throws JavaModelException {
        if (iResourceArray == null || iResourceArray.length == 0) {
            return;
        }
        IProgressMonitor iProgressMonitor = this.getSubProgressMonitor(iResourceArray.length);
        IWorkspace iWorkspace = iResourceArray[0].getWorkspace();
        try {
            iWorkspace.delete(iResourceArray, bl ? 3 : 2, iProgressMonitor);
            JavaModelOperation.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException coreException) {
            throw new JavaModelException(coreException);
        }
    }

    public void done() {
        if (this.progressMonitor != null) {
            this.progressMonitor.done();
        }
    }

    protected boolean equalsOneOf(IPath iPath, IPath[] iPathArray) {
        int n = 0;
        int n2 = iPathArray.length;
        while (n < n2) {
            if (iPath.equals((Object)iPathArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void executeNestedOperation(JavaModelOperation javaModelOperation, int n) throws JavaModelException {
        IJavaModelStatus iJavaModelStatus = javaModelOperation.verify();
        if (!iJavaModelStatus.isOK()) {
            throw new JavaModelException(iJavaModelStatus);
        }
        IProgressMonitor iProgressMonitor = this.getSubProgressMonitor(n);
        try {
            javaModelOperation.setNested(true);
            javaModelOperation.run(iProgressMonitor);
        }
        catch (CoreException coreException) {
            Throwable throwable;
            if (coreException instanceof JavaModelException) {
                throw (JavaModelException)coreException;
            }
            if (coreException.getStatus().getCode() == 76 && (throwable = coreException.getStatus().getException()) instanceof JavaModelException) {
                throw (JavaModelException)((Object)throwable);
            }
            throw new JavaModelException(coreException);
        }
    }

    protected abstract void executeOperation() throws JavaModelException;

    protected static Object getAttribute(Object object) {
        ArrayList arrayList = JavaModelOperation.getCurrentOperationStack();
        if (arrayList.size() == 0) {
            return null;
        }
        JavaModelOperation javaModelOperation = (JavaModelOperation)arrayList.get(0);
        if (javaModelOperation.attributes == null) {
            return null;
        }
        return javaModelOperation.attributes.get(object);
    }

    protected ICompilationUnit getCompilationUnitFor(IJavaElement iJavaElement) {
        return ((JavaElement)iJavaElement).getCompilationUnit();
    }

    protected static ArrayList getCurrentOperationStack() {
        ArrayList arrayList = (ArrayList)operationStacks.get();
        if (arrayList == null) {
            arrayList = new ArrayList();
            operationStacks.set(arrayList);
        }
        return arrayList;
    }

    protected IDocument getDocument(ICompilationUnit iCompilationUnit) throws JavaModelException {
        IBuffer iBuffer = iCompilationUnit.getBuffer();
        if (iBuffer instanceof IDocument) {
            return (IDocument)iBuffer;
        }
        return new DocumentAdapter(iBuffer);
    }

    protected IJavaElement[] getElementsToProcess() {
        return this.elementsToProcess;
    }

    protected IJavaElement getElementToProcess() {
        if (this.elementsToProcess == null || this.elementsToProcess.length == 0) {
            return null;
        }
        return this.elementsToProcess[0];
    }

    public IJavaModel getJavaModel() {
        return JavaModelManager.getJavaModelManager().getJavaModel();
    }

    protected IPath[] getNestedFolders(IPackageFragmentRoot iPackageFragmentRoot) throws JavaModelException {
        IPath iPath = iPackageFragmentRoot.getPath();
        IClasspathEntry[] iClasspathEntryArray = iPackageFragmentRoot.getJavaProject().getRawClasspath();
        int n = iClasspathEntryArray.length;
        IPath[] iPathArray = new IPath[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            IPath iPath2 = iClasspathEntryArray[n3].getPath();
            if (iPath.isPrefixOf(iPath2) && !iPath.equals((Object)iPath2)) {
                iPathArray[n2++] = iPath2;
            }
            ++n3;
        }
        if (n2 < n) {
            IPath[] iPathArray2 = iPathArray;
            iPathArray = new IPath[n2];
            System.arraycopy(iPathArray2, 0, iPathArray, 0, n2);
        }
        return iPathArray;
    }

    protected IJavaElement getParentElement() {
        if (this.parentElements == null || this.parentElements.length == 0) {
            return null;
        }
        return this.parentElements[0];
    }

    protected IJavaElement[] getParentElements() {
        return this.parentElements;
    }

    public IJavaElement[] getResultElements() {
        return this.resultElements;
    }

    protected ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected IProgressMonitor getSubProgressMonitor(int n) {
        SubProgressMonitor subProgressMonitor = null;
        if (this.progressMonitor != null) {
            subProgressMonitor = new SubProgressMonitor(this.progressMonitor, n, 4);
        }
        return subProgressMonitor;
    }

    public boolean hasModifiedResource() {
        return !this.isReadOnly() && JavaModelOperation.getAttribute(HAS_MODIFIED_RESOURCE_ATTR) == TRUE;
    }

    public void internalWorked(double d) {
        if (this.progressMonitor != null) {
            this.progressMonitor.internalWorked(d);
        }
    }

    public boolean isCanceled() {
        if (this.progressMonitor != null) {
            return this.progressMonitor.isCanceled();
        }
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    protected boolean isTopLevelOperation() {
        ArrayList arrayList = JavaModelOperation.getCurrentOperationStack();
        return arrayList.size() > 0 && arrayList.get(0) == this;
    }

    protected int firstActionWithID(String string, int n) {
        int n2 = n;
        while (n2 <= this.actionsEnd) {
            if (this.actions[n2].getID().equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    protected void moveResources(IResource[] iResourceArray, IPath iPath) throws JavaModelException {
        SubProgressMonitor subProgressMonitor = null;
        if (this.progressMonitor != null) {
            subProgressMonitor = new SubProgressMonitor(this.progressMonitor, iResourceArray.length, 4);
        }
        IWorkspace iWorkspace = iResourceArray[0].getWorkspace();
        try {
            iWorkspace.move(iResourceArray, iPath, false, (IProgressMonitor)subProgressMonitor);
            JavaModelOperation.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException coreException) {
            throw new JavaModelException(coreException);
        }
    }

    public JavaElementDelta newJavaElementDelta() {
        return new JavaElementDelta(this.getJavaModel());
    }

    protected JavaModelOperation popOperation() {
        ArrayList arrayList = JavaModelOperation.getCurrentOperationStack();
        int n = arrayList.size();
        if (n > 0) {
            if (n == 1) {
                operationStacks.set(null);
            }
            return (JavaModelOperation)arrayList.remove(n - 1);
        }
        return null;
    }

    protected void postAction(IPostAction iPostAction, int n) {
        if (POST_ACTION_VERBOSE) {
            System.out.print("(" + Thread.currentThread() + ") [JavaModelOperation.postAction(IPostAction, int)] Posting action " + iPostAction.getID());
            switch (n) {
                case 2: {
                    System.out.println(" (REMOVEALL_APPEND)");
                    break;
                }
                case 3: {
                    System.out.println(" (KEEP_EXISTING)");
                    break;
                }
                case 1: {
                    System.out.println(" (APPEND)");
                }
            }
        }
        JavaModelOperation javaModelOperation = (JavaModelOperation)JavaModelOperation.getCurrentOperationStack().get(0);
        IPostAction[] iPostActionArray = javaModelOperation.actions;
        if (iPostActionArray == null) {
            javaModelOperation.actions = iPostActionArray = new IPostAction[1];
            iPostActionArray[0] = iPostAction;
            javaModelOperation.actionsEnd = 0;
        } else {
            String string = iPostAction.getID();
            switch (n) {
                case 2: {
                    int n2 = this.actionsStart - 1;
                    while ((n2 = javaModelOperation.firstActionWithID(string, n2 + 1)) >= 0) {
                        System.arraycopy(iPostActionArray, n2 + 1, iPostActionArray, n2, javaModelOperation.actionsEnd - n2);
                        iPostActionArray[javaModelOperation.actionsEnd--] = null;
                    }
                    javaModelOperation.addAction(iPostAction);
                    break;
                }
                case 3: {
                    if (javaModelOperation.firstActionWithID(string, 0) >= 0) break;
                    javaModelOperation.addAction(iPostAction);
                    break;
                }
                case 1: {
                    javaModelOperation.addAction(iPostAction);
                }
            }
        }
    }

    protected boolean prefixesOneOf(IPath iPath, IPath[] iPathArray) {
        int n = 0;
        int n2 = iPathArray.length;
        while (n < n2) {
            if (iPath.isPrefixOf(iPathArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void pushOperation(JavaModelOperation javaModelOperation) {
        JavaModelOperation.getCurrentOperationStack().add(javaModelOperation);
    }

    protected void removeAllPostAction(String string) {
        if (POST_ACTION_VERBOSE) {
            System.out.println("(" + Thread.currentThread() + ") [JavaModelOperation.removeAllPostAction(String)] Removing actions " + string);
        }
        JavaModelOperation javaModelOperation = (JavaModelOperation)JavaModelOperation.getCurrentOperationStack().get(0);
        IPostAction[] iPostActionArray = javaModelOperation.actions;
        if (iPostActionArray == null) {
            return;
        }
        int n = this.actionsStart - 1;
        while ((n = javaModelOperation.firstActionWithID(string, n + 1)) >= 0) {
            System.arraycopy(iPostActionArray, n + 1, iPostActionArray, n, javaModelOperation.actionsEnd - n);
            iPostActionArray[javaModelOperation.actionsEnd--] = null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor var1_1) throws CoreException {
        var2_2 = JavaModelManager.getJavaModelManager();
        var3_3 = var2_2.getDeltaProcessor();
        var4_4 = var3_3.javaModelDeltas.size();
        try {
            this.progressMonitor = var1_1;
            this.pushOperation(this);
            try {
                if (this.canModifyRoots()) {
                    JavaModelManager.getJavaModelManager().deltaState.initializeRoots();
                }
                this.executeOperation();
            }
            catch (Throwable var6_5) {
                var5_6 = null;
                if (this.isTopLevelOperation() == false) throw var6_5;
                this.runPostActions();
                throw var6_5;
            }
            {
                var5_7 = null;
                if (this.isTopLevelOperation()) {
                    this.runPostActions();
                }
            }
        }
        catch (Throwable var8_8) {
            var7_9 = null;
            try {
                var3_3 = var2_2.getDeltaProcessor();
                var9_11 = var4_4;
                var10_13 = var3_3.javaModelDeltas.size();
                while (true) {
                    if (var9_11 >= var10_13) break;
                    var3_3.updateJavaModel((IJavaElementDelta)var3_3.javaModelDeltas.get(var9_11));
                    ++var9_11;
                }
                var9_11 = 0;
                var10_13 = this.resultElements.length;
                while (true) {
                    block28: {
                        if (var9_11 < var10_13) break block28;
                        var3_3.resetProjectCaches();
                        if (!(!this.isTopLevelOperation() || var3_3.javaModelDeltas.size() <= var4_4 && var3_3.reconcileDeltas.isEmpty() || this.hasModifiedResource())) {
                            var3_3.fire(null, 0);
                        }
                        ** GOTO lbl-1000
                    }
                    var11_15 = this.resultElements[var9_11];
                    var12_17 = (Openable)var11_15.getOpenable();
                    if (!(var12_17 instanceof CompilationUnit) || !((CompilationUnit)var12_17).isWorkingCopy()) {
                        ((JavaElement)var12_17.getParent()).close();
                    }
                    switch (var11_15.getElementType()) {
                        case 3: 
                        case 4: {
                            var3_3.projectCachesToReset.add(var11_15.getJavaProject());
                            break;
                        }
                    }
                    ++var9_11;
                }
            }
            catch (Throwable var14_19) {
                v0 = null;
lbl56:
                // 2 sources

                while (true) {
                    var13_21 = v0;
                    this.popOperation();
                    throw var8_8;
                }
            }
        }
        {
            var7_10 = null;
        }
        ** try [egrp 3[TRYBLOCK] [4 : 90->306)] { 
lbl63:
        // 1 sources

        var3_3 = var2_2.getDeltaProcessor();
        var9_12 = var4_4;
        var10_14 = var3_3.javaModelDeltas.size();
        while (true) {
            if (var9_12 >= var10_14) break;
            var3_3.updateJavaModel((IJavaElementDelta)var3_3.javaModelDeltas.get(var9_12));
            ++var9_12;
        }
        var9_12 = 0;
        var10_14 = this.resultElements.length;
        while (true) {
            block29: {
                if (var9_12 < var10_14) break block29;
                var3_3.resetProjectCaches();
                if (!(!this.isTopLevelOperation() || var3_3.javaModelDeltas.size() <= var4_4 && var3_3.reconcileDeltas.isEmpty() || this.hasModifiedResource())) {
                    var3_3.fire(null, 0);
                }
                ** GOTO lbl100
            }
            var11_16 = this.resultElements[var9_12];
            var12_18 = (Openable)var11_16.getOpenable();
            if (!(var12_18 instanceof CompilationUnit) || !((CompilationUnit)var12_18).isWorkingCopy()) {
                ((JavaElement)var12_18.getParent()).close();
            }
            switch (var11_16.getElementType()) {
                case 3: 
                case 4: {
                    var3_3.projectCachesToReset.add(var11_16.getJavaProject());
                    break;
                }
            }
            ++var9_12;
        }
lbl91:
        // 1 sources

        catch (Throwable var14_20) {
            v1 = null;
lbl93:
            // 2 sources

            while (true) {
                var13_22 = v1;
                this.popOperation();
                return;
            }
        }
lbl-1000:
        // 1 sources

        {
            v0 = null;
            ** continue;
lbl100:
            // 1 sources

            v1 = null;
            ** continue;
        }
    }

    public void runOperation(IProgressMonitor iProgressMonitor) throws JavaModelException {
        IJavaModelStatus iJavaModelStatus = this.verify();
        if (!iJavaModelStatus.isOK()) {
            throw new JavaModelException(iJavaModelStatus);
        }
        try {
            if (this.isReadOnly()) {
                this.run(iProgressMonitor);
            } else {
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)this, this.getSchedulingRule(), 1, iProgressMonitor);
            }
        }
        catch (CoreException coreException) {
            Throwable throwable;
            if (coreException instanceof JavaModelException) {
                throw (JavaModelException)coreException;
            }
            if (coreException.getStatus().getCode() == 76 && (throwable = coreException.getStatus().getException()) instanceof JavaModelException) {
                throw (JavaModelException)((Object)throwable);
            }
            throw new JavaModelException(coreException);
        }
    }

    protected void runPostActions() throws JavaModelException {
        while (this.actionsStart <= this.actionsEnd) {
            IPostAction iPostAction = this.actions[this.actionsStart++];
            if (POST_ACTION_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [JavaModelOperation.runPostActions()] Running action " + iPostAction.getID());
            }
            iPostAction.run();
        }
    }

    protected static void setAttribute(Object object, Object object2) {
        ArrayList arrayList = JavaModelOperation.getCurrentOperationStack();
        if (arrayList.size() == 0) {
            return;
        }
        JavaModelOperation javaModelOperation = (JavaModelOperation)arrayList.get(0);
        if (javaModelOperation.attributes == null) {
            javaModelOperation.attributes = new HashMap();
        }
        javaModelOperation.attributes.put(object, object2);
    }

    public void setCanceled(boolean bl) {
        if (this.progressMonitor != null) {
            this.progressMonitor.setCanceled(bl);
        }
    }

    protected void setNested(boolean bl) {
        this.isNested = bl;
    }

    public void setTaskName(String string) {
        if (this.progressMonitor != null) {
            this.progressMonitor.setTaskName(string);
        }
    }

    public void subTask(String string) {
        if (this.progressMonitor != null) {
            this.progressMonitor.subTask(string);
        }
    }

    protected IJavaModelStatus verify() {
        return this.commonVerify();
    }

    public void worked(int n) {
        if (this.progressMonitor != null) {
            this.progressMonitor.worked(n);
            this.checkCanceled();
        }
    }

    protected static interface IPostAction {
        public String getID();

        public void run() throws JavaModelException;
    }
}

