/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.core.ClasspathContainerInitializer;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.IJavaModelStatusConstants;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class JavaModelStatus
extends Status
implements IJavaModelStatus,
IJavaModelStatusConstants,
IResourceStatus {
    protected IJavaElement[] elements = new IJavaElement[0];
    protected IPath path;
    protected String string;
    protected static final IStatus[] NO_CHILDREN = new IStatus[0];
    protected IStatus[] children = NO_CHILDREN;
    public static final IJavaModelStatus VERIFIED_OK = new JavaModelStatus(0, 0, Messages.status_OK);

    public JavaModelStatus() {
        super(4, "org.eclipse.wst.jsdt.core", 0, "JavaModelStatus", null);
    }

    public JavaModelStatus(int n) {
        super(4, "org.eclipse.wst.jsdt.core", n, "JavaModelStatus", null);
        this.elements = JavaElement.NO_ELEMENTS;
    }

    public JavaModelStatus(int n, IJavaElement[] iJavaElementArray) {
        super(4, "org.eclipse.wst.jsdt.core", n, "JavaModelStatus", null);
        this.elements = iJavaElementArray;
        this.path = null;
    }

    public JavaModelStatus(int n, String string) {
        this(4, n, string);
    }

    public JavaModelStatus(int n, int n2, String string) {
        super(n, "org.eclipse.wst.jsdt.core", n2, "JavaModelStatus", null);
        this.elements = JavaElement.NO_ELEMENTS;
        this.path = null;
        this.string = string;
    }

    public JavaModelStatus(int n, Throwable throwable) {
        super(4, "org.eclipse.wst.jsdt.core", n, "JavaModelStatus", throwable);
        this.elements = JavaElement.NO_ELEMENTS;
    }

    public JavaModelStatus(int n, IPath iPath) {
        super(4, "org.eclipse.wst.jsdt.core", n, "JavaModelStatus", null);
        this.elements = JavaElement.NO_ELEMENTS;
        this.path = iPath;
    }

    public JavaModelStatus(int n, IJavaElement iJavaElement) {
        this(n, new IJavaElement[]{iJavaElement});
    }

    public JavaModelStatus(int n, IJavaElement iJavaElement, String string) {
        this(n, new IJavaElement[]{iJavaElement});
        this.string = string;
    }

    public JavaModelStatus(int n, IJavaElement iJavaElement, IPath iPath) {
        this(n, new IJavaElement[]{iJavaElement});
        this.path = iPath;
    }

    public JavaModelStatus(int n, IJavaElement iJavaElement, IPath iPath, String string) {
        this(n, new IJavaElement[]{iJavaElement});
        this.path = iPath;
        this.string = string;
    }

    public JavaModelStatus(int n, int n2, IJavaElement iJavaElement, IPath iPath, String string) {
        super(n, "org.eclipse.wst.jsdt.core", n2, "JavaModelStatus", null);
        this.elements = new IJavaElement[]{iJavaElement};
        this.path = iPath;
        this.string = string;
    }

    public JavaModelStatus(CoreException coreException) {
        super(4, "org.eclipse.wst.jsdt.core", 966, "JavaModelStatus", (Throwable)coreException);
        this.elements = JavaElement.NO_ELEMENTS;
    }

    protected int getBits() {
        int n = 1 << this.getCode() % 100 / 33;
        int n2 = 1 << this.getCode() / 100 + 3;
        return n | n2;
    }

    public IStatus[] getChildren() {
        return this.children;
    }

    public IJavaElement[] getElements() {
        return this.elements;
    }

    public String getMessage() {
        Throwable throwable = this.getException();
        if (throwable == null) {
            switch (this.getCode()) {
                case 966: {
                    return Messages.status_coreException;
                }
                case 990: {
                    return Messages.build_initializationError;
                }
                case 991: {
                    return Messages.build_serializationError;
                }
                case 973: {
                    return Messages.bind(Messages.status_cannotUseDeviceOnPath, this.getPath().toString());
                }
                case 986: {
                    return Messages.status_JDOMError;
                }
                case 969: {
                    return Messages.bind(Messages.element_doesNotExist, ((JavaElement)this.elements[0]).toStringWithAncestors());
                }
                case 1006: {
                    return Messages.bind(Messages.element_notOnClasspath, ((JavaElement)this.elements[0]).toStringWithAncestors());
                }
                case 992: {
                    return Messages.bind(Messages.status_evaluationError, this.string);
                }
                case 980: {
                    return Messages.status_indexOutOfBounds;
                }
                case 984: {
                    return Messages.status_invalidContents;
                }
                case 978: {
                    return Messages.bind(Messages.status_invalidDestination, ((JavaElement)this.elements[0]).toStringWithAncestors());
                }
                case 967: {
                    StringBuffer stringBuffer = new StringBuffer(Messages.operation_notSupported);
                    int n = 0;
                    while (n < this.elements.length) {
                        if (n > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(((JavaElement)this.elements[n]).toStringWithAncestors());
                        ++n;
                    }
                    return stringBuffer.toString();
                }
                case 983: {
                    return Messages.bind(Messages.status_invalidName, this.string);
                }
                case 998: {
                    return Messages.bind(Messages.status_invalidPackage, this.string);
                }
                case 979: {
                    if (this.string != null) {
                        return this.string;
                    }
                    return Messages.bind(Messages.status_invalidPath, new String[]{this.getPath() == null ? "null" : this.getPath().toString()});
                }
                case 997: {
                    return Messages.bind(Messages.status_invalidProject, this.string);
                }
                case 995: {
                    return Messages.bind(Messages.status_invalidResource, this.string);
                }
                case 996: {
                    return Messages.bind(Messages.status_invalidResourceType, this.string);
                }
                case 993: {
                    if (this.string != null) {
                        return Messages.bind(Messages.status_invalidSibling, this.string);
                    }
                    return Messages.bind(Messages.status_invalidSibling, ((JavaElement)this.elements[0]).toStringWithAncestors());
                }
                case 985: {
                    return Messages.status_IOException;
                }
                case 977: {
                    IJavaElement iJavaElement;
                    if (this.elements != null && this.elements.length > 0 && (iJavaElement = this.elements[0]) instanceof PackageFragment && ((PackageFragment)iJavaElement).isDefaultPackage()) {
                        return Messages.operation_cannotRenameDefaultPackage;
                    }
                    if (this.string != null) {
                        return this.string;
                    }
                    return Messages.bind(Messages.status_nameCollision, "");
                }
                case 968: {
                    return Messages.operation_needElements;
                }
                case 982: {
                    return Messages.operation_needName;
                }
                case 970: {
                    return Messages.operation_needPath;
                }
                case 974: {
                    return Messages.operation_needString;
                }
                case 971: {
                    return Messages.bind(Messages.operation_pathOutsideProject, new String[]{this.string, ((JavaElement)this.elements[0]).toStringWithAncestors()});
                }
                case 976: {
                    IJavaElement iJavaElement = this.elements[0];
                    String string = iJavaElement.getElementName();
                    if (iJavaElement instanceof IPackageFragment && string.equals("")) {
                        return Messages.status_defaultPackageReadOnly;
                    }
                    return Messages.bind(Messages.status_readOnly, string);
                }
                case 972: {
                    return Messages.bind(Messages.operation_needAbsolutePath, this.getPath().toString());
                }
                case 987: {
                    return Messages.status_targetException;
                }
                case 981: {
                    return Messages.status_updateConflict;
                }
                case 999: {
                    return Messages.bind(Messages.status_noLocalContents, this.getPath().toString());
                }
                case 963: {
                    IJavaProject iJavaProject = (IJavaProject)this.elements[0];
                    ClasspathContainerInitializer classpathContainerInitializer = JavaCore.getClasspathContainerInitializer(this.path.segment(0));
                    String string = null;
                    if (classpathContainerInitializer != null) {
                        string = classpathContainerInitializer.getDescription(this.path, iJavaProject);
                    }
                    if (string == null) {
                        string = this.path.makeRelative().toString();
                    }
                    return Messages.bind(Messages.classpath_unboundContainerPath, new String[]{string, iJavaProject.getElementName()});
                }
                case 962: {
                    IJavaProject iJavaProject = (IJavaProject)this.elements[0];
                    IClasspathContainer iClasspathContainer = null;
                    String string = null;
                    try {
                        iClasspathContainer = JavaCore.getClasspathContainer(this.path, iJavaProject);
                    }
                    catch (JavaModelException javaModelException) {}
                    if (iClasspathContainer == null) {
                        ClasspathContainerInitializer classpathContainerInitializer = JavaCore.getClasspathContainerInitializer(this.path.segment(0));
                        if (classpathContainerInitializer != null) {
                            string = classpathContainerInitializer.getDescription(this.path, iJavaProject);
                        }
                    } else {
                        string = iClasspathContainer.getDescription();
                    }
                    if (string == null) {
                        string = this.path.makeRelative().toString();
                    }
                    return Messages.bind(Messages.classpath_invalidContainer, new String[]{string, iJavaProject.getElementName()});
                }
                case 965: {
                    IJavaProject iJavaProject = (IJavaProject)this.elements[0];
                    return Messages.bind(Messages.classpath_unboundVariablePath, new String[]{this.path.makeRelative().toString(), iJavaProject.getElementName()});
                }
                case 1001: {
                    IJavaProject iJavaProject = (IJavaProject)this.elements[0];
                    return Messages.bind(Messages.classpath_cycle, iJavaProject.getElementName());
                }
                case 1002: {
                    IJavaProject iJavaProject = (IJavaProject)this.elements[0];
                    String string = iJavaProject.getElementName();
                    IPath iPath = this.path;
                    if (this.path.segment(0).toString().equals(string)) {
                        iPath = this.path.removeFirstSegments(1);
                    }
                    return Messages.bind(Messages.classpath_disabledInclusionExclusionPatterns, new String[]{iPath.makeRelative().toString(), string});
                }
                case 1003: {
                    IJavaProject iJavaProject = (IJavaProject)this.elements[0];
                    String string = iJavaProject.getElementName();
                    IPath iPath = this.path;
                    if (this.path.segment(0).toString().equals(string)) {
                        iPath = this.path.removeFirstSegments(1);
                    }
                    return Messages.bind(Messages.classpath_disabledMultipleOutputLocations, new String[]{iPath.makeRelative().toString(), string});
                }
                case 1004: {
                    IJavaProject iJavaProject = (IJavaProject)this.elements[0];
                    return Messages.bind(Messages.classpath_incompatibleLibraryJDKLevel, new String[]{iJavaProject.getElementName(), iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", true), this.path.makeRelative().toString(), this.string});
                }
                case 1008: {
                    if (this.elements != null && this.elements.length == 1) {
                        if (this.string != null) {
                            return Messages.bind(Messages.status_cannot_retrieve_attached_javadoc, ((JavaElement)this.elements[0]).toStringWithAncestors(), this.string);
                        }
                        return Messages.bind(Messages.status_cannot_retrieve_attached_javadoc, ((JavaElement)this.elements[0]).toStringWithAncestors(), "");
                    }
                    if (this.string == null) break;
                    return Messages.bind(Messages.status_cannot_retrieve_attached_javadoc, this.string, "");
                }
                case 1009: {
                    return Messages.bind(Messages.status_unknown_javadoc_format, ((JavaElement)this.elements[0]).toStringWithAncestors());
                }
                case 1010: {
                    IJavaProject iJavaProject = (IJavaProject)this.elements[0];
                    return Messages.bind(Messages.classpath_deprecated_variable, new String[]{this.path.segment(0).toString(), iJavaProject.getElementName(), this.string});
                }
            }
            if (this.string != null) {
                return this.string;
            }
            return "";
        }
        String string = throwable.getMessage();
        if (string != null) {
            return string;
        }
        return throwable.toString();
    }

    public IPath getPath() {
        return this.path;
    }

    public int getSeverity() {
        if (this.children == NO_CHILDREN) {
            return super.getSeverity();
        }
        int n = -1;
        int n2 = 0;
        int n3 = this.children.length;
        while (n2 < n3) {
            int n4 = this.children[n2].getSeverity();
            if (n4 > n) {
                n = n4;
            }
            ++n2;
        }
        return n;
    }

    public String getString() {
        return this.string;
    }

    public boolean isDoesNotExist() {
        int n = this.getCode();
        return n == 969 || n == 1006;
    }

    public boolean isMultiStatus() {
        return this.children != NO_CHILDREN;
    }

    public boolean isOK() {
        return this.getCode() == 0;
    }

    public boolean matches(int n) {
        if (!this.isMultiStatus()) {
            return this.matches(this, n);
        }
        int n2 = 0;
        int n3 = this.children.length;
        while (n2 < n3) {
            if (this.matches((JavaModelStatus)this.children[n2], n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean matches(JavaModelStatus javaModelStatus, int n) {
        int n2 = n & 7;
        int n3 = n & 0xFFFFFFF8;
        int n4 = javaModelStatus.getBits();
        return !(n2 != 0 && (n4 & n2) == 0 || n3 != 0 && (n4 & n3) == 0);
    }

    public static IJavaModelStatus newMultiStatus(IJavaModelStatus[] iJavaModelStatusArray) {
        JavaModelStatus javaModelStatus = new JavaModelStatus();
        javaModelStatus.children = iJavaModelStatusArray;
        return javaModelStatus;
    }

    public String toString() {
        if (this == VERIFIED_OK) {
            return "JavaModelStatus[OK]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Java Model Status [");
        stringBuffer.append(this.getMessage());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

