/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.LocalVariable;
import org.eclipse.wst.jsdt.internal.core.MemberElementInfo;
import org.eclipse.wst.jsdt.internal.core.SourceRange;
import org.eclipse.wst.jsdt.internal.core.SourceRefElement;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.core.SourceTypeElementInfo;
import org.eclipse.wst.jsdt.internal.core.TypeParameter;
import org.eclipse.wst.jsdt.internal.core.util.MementoTokenizer;

public abstract class Member
extends SourceRefElement
implements IMember {
    protected Member(JavaElement javaElement) {
        super(javaElement);
    }

    protected static boolean areSimilarMethods(String string, String[] stringArray, String string2, String[] stringArray2, String[] stringArray3) {
        int n;
        if (string.equals(string2) && (n = stringArray.length) == stringArray2.length) {
            int n2 = 0;
            while (n2 < n) {
                String string3;
                String string4 = stringArray3 == null ? Signature.getSimpleName(Signature.toString(Signature.getTypeErasure(stringArray[n2]))) : stringArray3[n2];
                if (!string4.equals(string3 = Signature.getSimpleName(Signature.toString(Signature.getTypeErasure(stringArray2[n2]))))) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    protected static Object convertConstant(Constant constant) {
        if (constant == null) {
            return null;
        }
        if (constant == Constant.NotAConstant) {
            return null;
        }
        switch (constant.typeID()) {
            case 5: {
                return constant.booleanValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return new Byte(constant.byteValue());
            }
            case 2: {
                return new Character(constant.charValue());
            }
            case 8: {
                return new Double(constant.doubleValue());
            }
            case 9: {
                return new Float(constant.floatValue());
            }
            case 10: {
                return new Integer(constant.intValue());
            }
            case 7: {
                return new Long(constant.longValue());
            }
            case 4: {
                return new Short(constant.shortValue());
            }
            case 11: {
                return constant.stringValue();
            }
        }
        return null;
    }

    public static IMethod[] findMethods(IMethod iMethod, IMethod[] iMethodArray) {
        String string = iMethod.getElementName();
        String[] stringArray = iMethod.getParameterTypes();
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String string2 = Signature.getTypeErasure(stringArray[n2]);
            stringArray2[n2] = Signature.getSimpleName(Signature.toString(string2));
            ++n2;
        }
        ArrayList<IMethod> arrayList = new ArrayList<IMethod>();
        int n3 = 0;
        int n4 = iMethodArray.length;
        while (n3 < n4) {
            IMethod iMethod2 = iMethodArray[n3];
            if (Member.areSimilarMethods(string, stringArray, iMethod2.getElementName(), iMethod2.getParameterTypes(), stringArray2)) {
                arrayList.add(iMethod2);
            }
            ++n3;
        }
        n3 = arrayList.size();
        if (n3 == 0) {
            return null;
        }
        IMethod[] iMethodArray2 = new IMethod[n3];
        arrayList.toArray(iMethodArray2);
        return iMethodArray2;
    }

    public String[] getCategories() throws JavaModelException {
        IType iType = (IType)this.getAncestor(7);
        if (iType == null) {
            return CharOperation.NO_STRINGS;
        }
        if (iType.isBinary()) {
            return CharOperation.NO_STRINGS;
        }
        SourceTypeElementInfo sourceTypeElementInfo = (SourceTypeElementInfo)((SourceType)iType).getElementInfo();
        HashMap hashMap = sourceTypeElementInfo.getCategories();
        if (hashMap == null) {
            return CharOperation.NO_STRINGS;
        }
        String[] stringArray = (String[])hashMap.get(this);
        if (stringArray == null) {
            return CharOperation.NO_STRINGS;
        }
        return stringArray;
    }

    public IClassFile getClassFile() {
        IJavaElement iJavaElement = this.getParent();
        while (iJavaElement instanceof IMember) {
            iJavaElement = iJavaElement.getParent();
        }
        if (iJavaElement instanceof IClassFile) {
            return (IClassFile)iJavaElement;
        }
        return null;
    }

    public IType getDeclaringType() {
        JavaElement javaElement = (JavaElement)this.getParent();
        if (javaElement.getElementType() == 7) {
            return (IType)((Object)javaElement);
        }
        return null;
    }

    public int getFlags() throws JavaModelException {
        MemberElementInfo memberElementInfo = (MemberElementInfo)this.getElementInfo();
        return memberElementInfo.getModifiers();
    }

    public IJavaElement getHandleFromMemento(String string, MementoTokenizer mementoTokenizer, WorkingCopyOwner workingCopyOwner) {
        switch (string.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(mementoTokenizer, workingCopyOwner);
            }
            case '[': {
                String string2;
                if (mementoTokenizer.hasMoreTokens()) {
                    string2 = mementoTokenizer.nextToken();
                    char c = string2.charAt(0);
                    if (c == '^' || c == '|' || c == '~' || c == '[' || c == '!') {
                        string = string2;
                        string2 = "";
                    } else {
                        string = null;
                    }
                } else {
                    string2 = "";
                    string = null;
                }
                JavaElement javaElement = (JavaElement)((Object)this.getType(string2, 1));
                if (string == null) {
                    return javaElement.getHandleFromMemento(mementoTokenizer, workingCopyOwner);
                }
                return javaElement.getHandleFromMemento(string, mementoTokenizer, workingCopyOwner);
            }
            case '@': {
                if (!mementoTokenizer.hasMoreTokens()) {
                    return this;
                }
                String string3 = mementoTokenizer.nextToken();
                if (!mementoTokenizer.hasMoreTokens()) {
                    return this;
                }
                mementoTokenizer.nextToken();
                if (!mementoTokenizer.hasMoreTokens()) {
                    return this;
                }
                int n = Integer.parseInt(mementoTokenizer.nextToken());
                if (!mementoTokenizer.hasMoreTokens()) {
                    return this;
                }
                mementoTokenizer.nextToken();
                if (!mementoTokenizer.hasMoreTokens()) {
                    return this;
                }
                int n2 = Integer.parseInt(mementoTokenizer.nextToken());
                if (!mementoTokenizer.hasMoreTokens()) {
                    return this;
                }
                mementoTokenizer.nextToken();
                if (!mementoTokenizer.hasMoreTokens()) {
                    return this;
                }
                int n3 = Integer.parseInt(mementoTokenizer.nextToken());
                if (!mementoTokenizer.hasMoreTokens()) {
                    return this;
                }
                mementoTokenizer.nextToken();
                if (!mementoTokenizer.hasMoreTokens()) {
                    return this;
                }
                int n4 = Integer.parseInt(mementoTokenizer.nextToken());
                if (!mementoTokenizer.hasMoreTokens()) {
                    return this;
                }
                mementoTokenizer.nextToken();
                if (!mementoTokenizer.hasMoreTokens()) {
                    return this;
                }
                String string4 = mementoTokenizer.nextToken();
                return new LocalVariable(this, string3, n, n2, n3, n4, string4);
            }
            case ']': {
                if (!mementoTokenizer.hasMoreTokens()) {
                    return this;
                }
                String string5 = mementoTokenizer.nextToken();
                TypeParameter typeParameter = new TypeParameter(this, string5);
                return typeParameter.getHandleFromMemento(mementoTokenizer, workingCopyOwner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '[';
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Member getOuterMostLocalContext() {
        Member member = this;
        Member member2 = null;
        while (true) {
            void var1_2;
            switch (var1_2.getElementType()) {
                case 5: 
                case 6: {
                    return member2;
                }
                case 7: {
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    member2 = (Member)var1_2;
                }
            }
            IJavaElement iJavaElement = var1_2.getParent();
        }
    }

    public ISourceRange getJavadocRange() throws JavaModelException {
        ISourceRange iSourceRange = this.getSourceRange();
        if (iSourceRange == null) {
            return null;
        }
        IBuffer iBuffer = null;
        if (this.isBinary()) {
            iBuffer = this.getClassFile().getBuffer();
        } else {
            ICompilationUnit iCompilationUnit = this.getCompilationUnit();
            if (!iCompilationUnit.isConsistent()) {
                return null;
            }
            iBuffer = iCompilationUnit.getBuffer();
        }
        int n = iSourceRange.getOffset();
        int n2 = iSourceRange.getLength();
        if (n2 > 0 && iBuffer.getChar(n) == '/') {
            IScanner iScanner = ToolFactory.createScanner(true, false, false, false);
            iScanner.setSource(iBuffer.getText(n, n2).toCharArray());
            try {
                int n3 = -1;
                int n4 = -1;
                int n5 = iScanner.getNextToken();
                block6: while (true) {
                    switch (n5) {
                        case 1003: {
                            n3 = iScanner.getCurrentTokenStartPosition();
                            n4 = iScanner.getCurrentTokenEndPosition() + 1;
                            n5 = iScanner.getNextToken();
                            continue block6;
                        }
                        case 1001: 
                        case 1002: {
                            n5 = iScanner.getNextToken();
                            continue block6;
                        }
                    }
                    break;
                }
                if (n3 != -1) {
                    return new SourceRange(n3 + n, n4 - n3 + 1);
                }
            }
            catch (InvalidInputException invalidInputException) {}
        }
        return null;
    }

    public ISourceRange getNameRange() throws JavaModelException {
        MemberElementInfo memberElementInfo = (MemberElementInfo)this.getElementInfo();
        return new SourceRange(memberElementInfo.getNameSourceStart(), memberElementInfo.getNameSourceEnd() - memberElementInfo.getNameSourceStart() + 1);
    }

    public IType getType(String string, int n) {
        if (this.isBinary()) {
            throw new IllegalArgumentException("Not a source member " + this.toStringWithAncestors());
        }
        SourceType sourceType = new SourceType(this, string);
        sourceType.occurrenceCount = n;
        return sourceType;
    }

    public ITypeRoot getTypeRoot() {
        IJavaElement iJavaElement = this.getParent();
        while (iJavaElement instanceof IMember) {
            iJavaElement = iJavaElement.getParent();
        }
        return (ITypeRoot)iJavaElement;
    }

    public boolean isBinary() {
        return this.getClassFile() != null;
    }

    protected boolean isMainMethod(IMethod iMethod) throws JavaModelException {
        String[] stringArray;
        int n;
        if ("main".equals(iMethod.getElementName()) && "V".equals(iMethod.getReturnType()) && Flags.isStatic(n = iMethod.getFlags()) && Flags.isPublic(n) && (stringArray = iMethod.getParameterTypes()).length == 1) {
            String string = Signature.toString(stringArray[0]);
            return "String[]".equals(Signature.getSimpleName(string));
        }
        return false;
    }

    public boolean isReadOnly() {
        return this.getClassFile() != null;
    }

    public String readableName() {
        IType iType = this.getDeclaringType();
        if (iType != null) {
            String string = ((JavaElement)((Object)this.getDeclaringType())).readableName();
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append('.');
            stringBuffer.append(this.getElementName());
            return stringBuffer.toString();
        }
        return super.readableName();
    }

    protected void updateNameRange(int n, int n2) {
        try {
            MemberElementInfo memberElementInfo = (MemberElementInfo)this.getElementInfo();
            memberElementInfo.setNameSourceStart(n);
            memberElementInfo.setNameSourceEnd(n2);
        }
        catch (JavaModelException javaModelException) {
            return;
        }
    }
}

