/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.wst.jsdt.core.BindingKey;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.Member;

public abstract class NamedMember
extends Member {
    protected String name;

    public NamedMember(JavaElement javaElement, String string) {
        super(javaElement);
        this.name = string;
    }

    private void appendTypeParameters(StringBuffer stringBuffer) throws JavaModelException {
        ITypeParameter[] iTypeParameterArray = this.getTypeParameters();
        int n = iTypeParameterArray.length;
        if (n == 0) {
            return;
        }
        stringBuffer.append('<');
        int n2 = 0;
        while (n2 < n) {
            ITypeParameter iTypeParameter = iTypeParameterArray[n2];
            stringBuffer.append(iTypeParameter.getElementName());
            String[] stringArray = iTypeParameter.getBounds();
            int n3 = stringArray.length;
            if (n3 > 0) {
                stringBuffer.append(" extends ");
                int n4 = 0;
                while (n4 < n3) {
                    stringBuffer.append(stringArray[n4]);
                    if (n4 < n3 - 1) {
                        stringBuffer.append(" & ");
                    }
                    ++n4;
                }
            }
            if (n2 < n - 1) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append('>');
    }

    public String getElementName() {
        return this.name;
    }

    protected String getKey(IField iField, boolean bl) throws JavaModelException {
        StringBuffer stringBuffer = new StringBuffer();
        IJavaElement iJavaElement = iField.getParent();
        String string = "??";
        if (iJavaElement instanceof ICompilationUnit) {
            string = this.getKey((ICompilationUnit)iJavaElement, bl);
        } else if (iJavaElement instanceof IType) {
            string = this.getKey((IType)iJavaElement, bl);
        }
        stringBuffer.append(string);
        stringBuffer.append('.');
        stringBuffer.append(iField.getElementName());
        return stringBuffer.toString();
    }

    protected String getKey(IMethod iMethod, boolean bl) throws JavaModelException {
        int n;
        Object[] objectArray;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        IJavaElement iJavaElement = iMethod.getParent();
        String string = "??";
        if (iJavaElement instanceof ICompilationUnit) {
            string = this.getKey((ICompilationUnit)iJavaElement, bl);
        } else if (iJavaElement instanceof IType) {
            string = this.getKey((IType)iJavaElement, bl);
        }
        stringBuffer.append(string);
        stringBuffer.append('.');
        String string2 = iMethod.getElementName();
        stringBuffer.append(string2);
        if (bl && (n2 = (objectArray = iMethod.getTypeParameters()).length) > 0) {
            stringBuffer.append('<');
            n = 0;
            while (n < n2) {
                Object object = objectArray[n];
                String[] stringArray = object.getBounds();
                int n3 = stringArray.length;
                char[][] cArrayArray = new char[n3][];
                int n4 = 0;
                while (n4 < n3) {
                    cArrayArray[n4] = Signature.createCharArrayTypeSignature(stringArray[n4].toCharArray(), iMethod.isBinary());
                    CharOperation.replace(cArrayArray[n4], '.', '/');
                    ++n4;
                }
                char[] cArray = Signature.createTypeParameterSignature(object.getElementName().toCharArray(), cArrayArray);
                stringBuffer.append(cArray);
                ++n;
            }
            stringBuffer.append('>');
        }
        stringBuffer.append('(');
        objectArray = iMethod.getParameterNames();
        n2 = 0;
        n = objectArray.length;
        while (n2 < n) {
            stringBuffer.append(((String)objectArray[n2]).replace('.', '/'));
            ++n2;
        }
        stringBuffer.append(')');
        if (bl) {
            if (iMethod.getReturnType() != null) {
                stringBuffer.append(iMethod.getReturnType().replace('.', '/'));
            }
        } else {
            stringBuffer.append('V');
        }
        return stringBuffer.toString();
    }

    protected String getKey(ICompilationUnit iCompilationUnit, boolean bl) throws JavaModelException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('U');
        String string = iCompilationUnit.getParent().getElementName();
        stringBuffer.append(string.replace('.', '/'));
        if (string.length() > 0) {
            stringBuffer.append('/');
        }
        stringBuffer.append(iCompilationUnit.getElementName());
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    protected String getKey(IType iType, boolean bl) throws JavaModelException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('L');
        String string = iType.getPackageFragment().getElementName();
        stringBuffer.append(string.replace('.', '/'));
        if (string.length() > 0) {
            stringBuffer.append('/');
        }
        String string2 = iType.getTypeQualifiedName('$');
        ICompilationUnit iCompilationUnit = (ICompilationUnit)iType.getAncestor(5);
        if (iCompilationUnit != null) {
            String string3;
            String string4 = iCompilationUnit.getElementName();
            String string5 = string4.substring(0, string4.lastIndexOf(46));
            int n = string2.indexOf(36);
            if (n == -1) {
                n = string2.length();
            }
            if (!string5.equals(string3 = string2.substring(0, n))) {
                stringBuffer.append(string5);
                stringBuffer.append('~');
            }
        }
        stringBuffer.append(string2);
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    protected String getFullyQualifiedParameterizedName(String string, String string2) throws JavaModelException {
        String[] stringArray = new BindingKey(string2).getTypeArguments();
        int n = stringArray.length;
        if (n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append('<');
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray[n2];
            stringBuffer.append(Signature.toString(string3));
            if (n2 < n - 1) {
                stringBuffer.append(',');
            }
            ++n2;
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    protected IPackageFragment getPackageFragment() {
        return null;
    }

    public String getFullyQualifiedName(char c, boolean bl) throws JavaModelException {
        String string = this.getPackageFragment().getElementName();
        if (string.equals("")) {
            return this.getTypeQualifiedName(c, bl);
        }
        return String.valueOf(string) + '.' + this.getTypeQualifiedName(c, bl);
    }

    public String getTypeQualifiedName(char c, boolean bl) throws JavaModelException {
        NamedMember namedMember;
        switch (this.parent.getElementType()) {
            case 5: {
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer(this.name);
                    this.appendTypeParameters(stringBuffer);
                    return stringBuffer.toString();
                }
                return this.name;
            }
            case 6: {
                String string = this.parent.getElementName();
                String string2 = string.indexOf(36) == -1 ? this.name : string.substring(0, string.lastIndexOf(46));
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer(string2);
                    this.appendTypeParameters(stringBuffer);
                    return stringBuffer.toString();
                }
                return string2;
            }
            case 7: {
                namedMember = (NamedMember)this.parent;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                namedMember = (NamedMember)((Object)((IMember)((Object)this.parent)).getDeclaringType());
                break;
            }
            default: {
                return null;
            }
        }
        String string = namedMember != null ? namedMember.getTypeQualifiedName(c, bl) : "";
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(c);
        String string3 = this.name.length() == 0 ? Integer.toString(this.occurrenceCount) : this.name;
        stringBuffer.append(string3);
        if (bl) {
            this.appendTypeParameters(stringBuffer);
        }
        return stringBuffer.toString();
    }

    protected ITypeParameter[] getTypeParameters() throws JavaModelException {
        return null;
    }
}

