/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.CreateCompilationUnitOperation;
import org.eclipse.wst.jsdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.OpenableElementInfo;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentInfo;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.util.LRUCache;
import org.eclipse.wst.jsdt.internal.core.util.MementoTokenizer;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class PackageFragment
extends Openable
implements IPackageFragment,
SuffixConstants {
    protected static final IClassFile[] NO_CLASSFILES = new IClassFile[0];
    protected static final ICompilationUnit[] NO_COMPILATION_UNITS = new ICompilationUnit[0];
    public String[] names;

    protected PackageFragment(PackageFragmentRoot packageFragmentRoot, String[] stringArray) {
        super(packageFragmentRoot);
        this.names = stringArray;
    }

    protected boolean buildStructure(OpenableElementInfo openableElementInfo, IProgressMonitor iProgressMonitor, Map map, IResource iResource) throws JavaModelException {
        Object object;
        IJavaElement[] iJavaElementArray;
        if (!iResource.isAccessible()) {
            throw this.newNotPresentException();
        }
        int n = this.getKind();
        if (n == 1 && Util.isExcluded(this)) {
            throw this.newNotPresentException();
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        try {
            iJavaElementArray = this.getPackageFragmentRoot();
            char[][] cArray = iJavaElementArray.fullInclusionPatternChars();
            char[][] cArray2 = iJavaElementArray.fullExclusionPatternChars();
            object = ((IContainer)iResource).members();
            int n2 = ((IResource[])object).length;
            if (n2 > 0) {
                IJavaProject iJavaProject = this.getJavaProject();
                String string = iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
                String string2 = iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
                int n3 = 0;
                while (n3 < n2) {
                    IResource iResource2 = object[n3];
                    if (iResource2.getType() != 2 && !Util.isExcluded(iResource2, cArray, cArray2)) {
                        ITypeRoot iTypeRoot;
                        if (n == 1 && Util.isValidCompilationUnitName(iResource2.getName(), string, string2)) {
                            iTypeRoot = new CompilationUnit(this, iResource2.getName(), DefaultWorkingCopyOwner.PRIMARY);
                            hashSet.add(iTypeRoot);
                        } else if (n == 2 && Util.isValidClassFileName(iResource2.getName(), string, string2)) {
                            iTypeRoot = this.getClassFile(iResource2.getName());
                            hashSet.add(iTypeRoot);
                        }
                    }
                    ++n3;
                }
            }
        }
        catch (CoreException coreException) {
            throw new JavaModelException(coreException);
        }
        if (n == 1) {
            iJavaElementArray = this.getCompilationUnits(DefaultWorkingCopyOwner.PRIMARY);
            int n4 = 0;
            int n5 = iJavaElementArray.length;
            while (n4 < n5) {
                object = iJavaElementArray[n4];
                hashSet.add(object);
                ++n4;
            }
        }
        iJavaElementArray = new IJavaElement[hashSet.size()];
        hashSet.toArray(iJavaElementArray);
        openableElementInfo.setChildren(iJavaElementArray);
        return true;
    }

    public boolean containsJavaResources() throws JavaModelException {
        return ((PackageFragmentInfo)this.getElementInfo()).containsJavaResources();
    }

    public void copy(IJavaElement iJavaElement, IJavaElement iJavaElement2, String string, boolean bl, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (iJavaElement == null) {
            throw new IllegalArgumentException(Messages.operation_nullContainer);
        }
        IJavaElement[] iJavaElementArray = new IJavaElement[]{this};
        IJavaElement[] iJavaElementArray2 = new IJavaElement[]{iJavaElement};
        IJavaElement[] iJavaElementArray3 = null;
        if (iJavaElement2 != null) {
            iJavaElementArray3 = new IJavaElement[]{iJavaElement2};
        }
        String[] stringArray = null;
        if (string != null) {
            stringArray = new String[]{string};
        }
        this.getJavaModel().copy(iJavaElementArray, iJavaElementArray2, iJavaElementArray3, stringArray, bl, iProgressMonitor);
    }

    public ICompilationUnit createCompilationUnit(String string, String string2, boolean bl, IProgressMonitor iProgressMonitor) throws JavaModelException {
        CreateCompilationUnitOperation createCompilationUnitOperation = new CreateCompilationUnitOperation(this, string, string2, bl);
        createCompilationUnitOperation.runOperation(iProgressMonitor);
        return new CompilationUnit(this, string, DefaultWorkingCopyOwner.PRIMARY);
    }

    protected Object createElementInfo() {
        return new PackageFragmentInfo();
    }

    public void delete(boolean bl, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IJavaElement[] iJavaElementArray = new IJavaElement[]{this};
        this.getJavaModel().delete(iJavaElementArray, bl, iProgressMonitor);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PackageFragment)) {
            return false;
        }
        PackageFragment packageFragment = (PackageFragment)object;
        return Util.equalArraysOrNull(this.names, packageFragment.names) && this.parent.equals(packageFragment.parent);
    }

    public boolean exists() {
        return super.exists() && !Util.isExcluded(this);
    }

    public IClassFile getClassFile(String string) {
        if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(string)) {
            throw new IllegalArgumentException(Messages.element_invalidClassFileName);
        }
        int n = string.length() - SUFFIX_CLASS.length;
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return new ClassFile(this, new String(cArray));
    }

    public IClassFile[] getClassFiles() throws JavaModelException {
        if (this.getKind() == 1) {
            return NO_CLASSFILES;
        }
        ArrayList arrayList = this.getChildrenOfType(6);
        IClassFile[] iClassFileArray = new IClassFile[arrayList.size()];
        arrayList.toArray(iClassFileArray);
        return iClassFileArray;
    }

    public ICompilationUnit getCompilationUnit(String string, String string2) {
        int n;
        if (!Util.isJavaLikeFileName(string)) {
            throw new IllegalArgumentException(Messages.convention_unit_notJavaName);
        }
        String string3 = new String();
        try {
            IResource iResource = this.parent.getResource();
            string3 = iResource == null ? null : String.valueOf(iResource.getName()) + "/";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string3 != null && (n = string.indexOf(string3)) > -1 && n < 2) {
            String string4 = "/" + string.substring(n + string3.length(), string.length());
            return new CompilationUnit(this, string4, string2, DefaultWorkingCopyOwner.PRIMARY);
        }
        return new CompilationUnit(this, string, string2, DefaultWorkingCopyOwner.PRIMARY);
    }

    public ICompilationUnit getCompilationUnit(String string) {
        return this.getCompilationUnit(string, null);
    }

    public ICompilationUnit[] getCompilationUnits() throws JavaModelException {
        if (this.getKind() == 2) {
            return NO_COMPILATION_UNITS;
        }
        ArrayList arrayList = this.getChildrenOfType(5);
        ICompilationUnit[] iCompilationUnitArray = new ICompilationUnit[arrayList.size()];
        arrayList.toArray(iCompilationUnitArray);
        return iCompilationUnitArray;
    }

    public ICompilationUnit[] getCompilationUnits(WorkingCopyOwner workingCopyOwner) {
        ICompilationUnit[] iCompilationUnitArray = JavaModelManager.getJavaModelManager().getWorkingCopies(workingCopyOwner, false);
        if (iCompilationUnitArray == null) {
            return JavaModelManager.NO_WORKING_COPY;
        }
        int n = iCompilationUnitArray.length;
        ICompilationUnit[] iCompilationUnitArray2 = new ICompilationUnit[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            ICompilationUnit iCompilationUnit = iCompilationUnitArray[n3];
            if (this.equals(iCompilationUnit.getParent()) && !Util.isExcluded(iCompilationUnit)) {
                iCompilationUnitArray2[n2++] = iCompilationUnit;
            }
            ++n3;
        }
        if (n2 != n) {
            ICompilationUnit[] iCompilationUnitArray3 = iCompilationUnitArray2;
            iCompilationUnitArray2 = new ICompilationUnit[n2];
            System.arraycopy(iCompilationUnitArray3, 0, iCompilationUnitArray2, 0, n2);
        }
        return iCompilationUnitArray2;
    }

    public String getElementName() {
        return Util.concatWith(this.names, '/');
    }

    public int getElementType() {
        return 4;
    }

    public IJavaElement getHandleFromMemento(String string, MementoTokenizer mementoTokenizer, WorkingCopyOwner workingCopyOwner) {
        switch (string.charAt(0)) {
            case '(': {
                if (!mementoTokenizer.hasMoreTokens()) {
                    return this;
                }
                String string2 = mementoTokenizer.nextToken();
                JavaElement javaElement = (JavaElement)((Object)this.getClassFile(string2));
                return javaElement.getHandleFromMemento(mementoTokenizer, workingCopyOwner);
            }
            case '{': {
                if (!mementoTokenizer.hasMoreTokens()) {
                    return this;
                }
                String string3 = mementoTokenizer.nextToken();
                CompilationUnit compilationUnit = new CompilationUnit(this, string3, workingCopyOwner);
                return compilationUnit.getHandleFromMemento(mementoTokenizer, workingCopyOwner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '<';
    }

    public int getKind() throws JavaModelException {
        return ((IPackageFragmentRoot)this.getParent()).getKind();
    }

    public Object[] getNonJavaResources() throws JavaModelException {
        if (this.isDefaultPackage()) {
            return JavaElementInfo.NO_NON_JAVA_RESOURCES;
        }
        return ((PackageFragmentInfo)this.getElementInfo()).getNonJavaResources(this.getResource(), this.getPackageFragmentRoot());
    }

    public IPath getPath() {
        PackageFragmentRoot packageFragmentRoot = this.getPackageFragmentRoot();
        if (packageFragmentRoot.isArchive()) {
            return packageFragmentRoot.getPath();
        }
        IPath iPath = packageFragmentRoot.getPath();
        int n = 0;
        int n2 = this.names.length;
        while (n < n2) {
            String string = this.names[n];
            iPath = iPath.append(string);
            ++n;
        }
        return iPath;
    }

    public IResource getResource() {
        PackageFragmentRoot packageFragmentRoot = this.getPackageFragmentRoot();
        if (!packageFragmentRoot.isResourceContainer()) {
            return packageFragmentRoot.getResource();
        }
        int n = this.names.length;
        if (n == 0) {
            return packageFragmentRoot.getResource();
        }
        Path path = new Path(this.names[0]);
        int n2 = 1;
        while (n2 < n) {
            path = path.append(this.names[n2]);
            ++n2;
        }
        return ((IContainer)packageFragmentRoot.getResource()).getFolder((IPath)path);
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        IResource iResource = this.parent.getUnderlyingResource();
        if (iResource == null) {
            return null;
        }
        if (iResource.getType() == 2 || iResource.getType() == 4) {
            IContainer iContainer = (IContainer)iResource;
            String[] stringArray = this.names;
            int n = 0;
            while (n < stringArray.length) {
                IResource iResource2 = iContainer.findMember(stringArray[n]);
                if (iResource2 == null || iResource2.getType() != 2) {
                    throw this.newNotPresentException();
                }
                iContainer = (IFolder)iResource2;
                ++n;
            }
            return iContainer;
        }
        return iResource;
    }

    public int hashCode() {
        int n = this.parent.hashCode();
        int n2 = 0;
        int n3 = this.names.length;
        while (n2 < n3) {
            n = Util.combineHashCodes(this.names[n2].hashCode(), n);
            ++n2;
        }
        return n;
    }

    public boolean hasChildren() throws JavaModelException {
        return this.getChildren().length > 0;
    }

    public boolean hasSubpackages() throws JavaModelException {
        IJavaElement[] iJavaElementArray = ((IPackageFragmentRoot)this.getParent()).getChildren();
        int n = this.names.length;
        int n2 = 0;
        int n3 = iJavaElementArray.length;
        while (n2 < n3) {
            block4: {
                String[] stringArray = ((PackageFragment)iJavaElementArray[n2]).names;
                if (stringArray.length > n) {
                    int n4 = 0;
                    while (n4 < n) {
                        if (this.names[n4].equals(stringArray[n4])) {
                            ++n4;
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public boolean isDefaultPackage() {
        return this.names.length == 0;
    }

    public void move(IJavaElement iJavaElement, IJavaElement iJavaElement2, String string, boolean bl, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (iJavaElement == null) {
            throw new IllegalArgumentException(Messages.operation_nullContainer);
        }
        IJavaElement[] iJavaElementArray = new IJavaElement[]{this};
        IJavaElement[] iJavaElementArray2 = new IJavaElement[]{iJavaElement};
        IJavaElement[] iJavaElementArray3 = null;
        if (iJavaElement2 != null) {
            iJavaElementArray3 = new IJavaElement[]{iJavaElement2};
        }
        String[] stringArray = null;
        if (string != null) {
            stringArray = new String[]{string};
        }
        this.getJavaModel().move(iJavaElementArray, iJavaElementArray2, iJavaElementArray3, stringArray, bl, iProgressMonitor);
    }

    public void rename(String string, boolean bl, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.element_nullName);
        }
        IJavaElement[] iJavaElementArray = new IJavaElement[]{this};
        IJavaElement[] iJavaElementArray2 = new IJavaElement[]{this.getParent()};
        String[] stringArray = new String[]{string};
        this.getJavaModel().rename(iJavaElementArray, iJavaElementArray2, stringArray, bl, iProgressMonitor);
    }

    protected void toStringChildren(int n, StringBuffer stringBuffer, Object object) {
        if (n == 0) {
            super.toStringChildren(n, stringBuffer, object);
        }
    }

    protected void toStringInfo(int n, StringBuffer stringBuffer, Object object, boolean bl) {
        stringBuffer.append(this.tabString(n));
        if (this.names.length == 0) {
            stringBuffer.append("<default>");
        } else {
            this.toStringName(stringBuffer);
        }
        if (object == null) {
            stringBuffer.append(" (not open)");
        } else if (n > 0) {
            stringBuffer.append(" (...)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttachedJavadoc(IProgressMonitor iProgressMonitor) throws JavaModelException {
        JavaModelManager.PerProjectInfo perProjectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfoCheckExistence(this.getJavaProject().getProject());
        String string = null;
        Object object = perProjectInfo.javadocCache;
        synchronized (object) {
            string = (String)perProjectInfo.javadocCache.get(this);
        }
        if (string != null) {
            return string;
        }
        object = this.getJavadocBaseLocation();
        if (object == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(((URL)object).toExternalForm());
        if (stringBuffer.charAt(stringBuffer.length() - 1) != '/') {
            stringBuffer.append('/');
        }
        String string2 = this.getElementName().replace('.', '/');
        stringBuffer.append(string2).append('/').append("package-summary.html");
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        String string3 = this.getURLContents(String.valueOf(stringBuffer));
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (string3 == null) {
            throw new JavaModelException(new JavaModelStatus(1008, this));
        }
        LRUCache lRUCache = perProjectInfo.javadocCache;
        synchronized (lRUCache) {
            perProjectInfo.javadocCache.put(this, string3);
        }
        return string3;
    }
}

