/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.ArrayList;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.IRegion;

public class Region
implements IRegion {
    protected ArrayList fRootElements = new ArrayList(1);

    public void add(IJavaElement iJavaElement) {
        if (!this.contains(iJavaElement)) {
            this.removeAllChildren(iJavaElement);
            this.fRootElements.add(iJavaElement);
            this.fRootElements.trimToSize();
        }
    }

    public boolean contains(IJavaElement iJavaElement) {
        int n = this.fRootElements.size();
        ArrayList arrayList = this.getAncestors(iJavaElement);
        int n2 = 0;
        while (n2 < n) {
            IJavaElement iJavaElement2 = (IJavaElement)this.fRootElements.get(n2);
            if (iJavaElement2.equals(iJavaElement)) {
                return true;
            }
            int n3 = 0;
            int n4 = arrayList.size();
            while (n3 < n4) {
                if (iJavaElement2.equals(arrayList.get(n3))) {
                    return true;
                }
                ++n3;
            }
            ++n2;
        }
        return false;
    }

    private ArrayList getAncestors(IJavaElement iJavaElement) {
        ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>();
        IJavaElement iJavaElement2 = iJavaElement.getParent();
        while (iJavaElement2 != null) {
            arrayList.add(iJavaElement2);
            iJavaElement2 = iJavaElement2.getParent();
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public IJavaElement[] getElements() {
        int n = this.fRootElements.size();
        IJavaElement[] iJavaElementArray = new IJavaElement[n];
        int n2 = 0;
        while (n2 < n) {
            iJavaElementArray[n2] = (IJavaElement)this.fRootElements.get(n2);
            ++n2;
        }
        return iJavaElementArray;
    }

    public boolean remove(IJavaElement iJavaElement) {
        this.removeAllChildren(iJavaElement);
        return this.fRootElements.remove(iJavaElement);
    }

    protected void removeAllChildren(IJavaElement iJavaElement) {
        if (iJavaElement instanceof IParent) {
            ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>();
            int n = 0;
            int n2 = this.fRootElements.size();
            while (n < n2) {
                IJavaElement iJavaElement2 = (IJavaElement)this.fRootElements.get(n);
                IJavaElement iJavaElement3 = iJavaElement2.getParent();
                boolean bl = false;
                while (iJavaElement3 != null) {
                    if (iJavaElement3.equals(iJavaElement)) {
                        bl = true;
                        break;
                    }
                    iJavaElement3 = iJavaElement3.getParent();
                }
                if (!bl) {
                    arrayList.add(iJavaElement2);
                }
                ++n;
            }
            this.fRootElements = arrayList;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        IJavaElement[] iJavaElementArray = this.getElements();
        stringBuffer.append('[');
        int n = 0;
        while (n < iJavaElementArray.length) {
            stringBuffer.append(iJavaElementArray[n].getElementName());
            if (n < iJavaElementArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

