/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.builder;

import java.io.File;
import java.net.URI;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSet;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathLocation;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class ClasspathLibrary
extends ClasspathLocation {
    String filename;
    IFile resource;
    long lastModified;
    boolean closeZipFileAtEnd;
    SimpleSet knownPackageNames;
    AccessRuleSet accessRuleSet;

    ClasspathLibrary(IFile iFile, AccessRuleSet accessRuleSet) {
        this.resource = iFile;
        try {
            URI uRI = iFile.getLocationURI();
            if (uRI == null) {
                this.filename = "";
            } else {
                File file = Util.toLocalFile(uRI, null);
                this.filename = file.getPath();
            }
        }
        catch (CoreException coreException) {}
        this.knownPackageNames = null;
        this.accessRuleSet = accessRuleSet;
    }

    ClasspathLibrary(String string, long l, AccessRuleSet accessRuleSet) {
        this.filename = string;
        this.lastModified = l;
        this.knownPackageNames = null;
        this.accessRuleSet = accessRuleSet;
    }

    public void cleanup() {
        this.knownPackageNames = null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ClasspathLibrary)) {
            return false;
        }
        ClasspathLibrary classpathLibrary = (ClasspathLibrary)object;
        if (!(this.accessRuleSet == classpathLibrary.accessRuleSet || this.accessRuleSet != null && this.accessRuleSet.equals(classpathLibrary.accessRuleSet))) {
            return false;
        }
        return this.filename.equals(classpathLibrary.filename) && this.lastModified() == classpathLibrary.lastModified();
    }

    public NameEnvironmentAnswer findClass(String string, String string2, String string3) {
        throw new UnimplementedException();
    }

    public IPath getProjectRelativePath() {
        if (this.resource == null) {
            return null;
        }
        return this.resource.getProjectRelativePath();
    }

    public boolean isPackage(String string) {
        return this.filename.endsWith(string);
    }

    public long lastModified() {
        if (this.lastModified == 0L) {
            this.lastModified = new File(this.filename).lastModified();
        }
        return this.lastModified;
    }

    public String toString() {
        String string = "Classpath library file " + this.filename;
        if (this.accessRuleSet == null) {
            return string;
        }
        return String.valueOf(string) + " with " + this.accessRuleSet;
    }

    public String debugPathString() {
        if (this.lastModified == 0L) {
            return this.filename;
        }
        return String.valueOf(this.filename) + '(' + new Date(this.lastModified) + " : " + this.lastModified + ')';
    }
}

