/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.builder;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.wst.jsdt.internal.core.builder.MissingSourceFileException;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class SourceFile
implements ICompilationUnit {
    public IFile resource;
    ClasspathMultiDirectory sourceLocation;
    String initialTypeName;
    boolean updateClassFile;

    public SourceFile(IFile iFile, ClasspathMultiDirectory classpathMultiDirectory) {
        this.resource = iFile;
        this.sourceLocation = classpathMultiDirectory;
        this.initialTypeName = this.extractTypeName();
        this.updateClassFile = false;
    }

    public SourceFile(IFile iFile, ClasspathMultiDirectory classpathMultiDirectory, boolean bl) {
        this(iFile, classpathMultiDirectory);
        this.updateClassFile = bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SourceFile)) {
            return false;
        }
        SourceFile sourceFile = (SourceFile)object;
        return this.sourceLocation == sourceFile.sourceLocation && this.resource.getFullPath().equals((Object)sourceFile.resource.getFullPath());
    }

    String extractTypeName() {
        IPath iPath = this.resource.getFullPath();
        int n = iPath.segmentCount();
        int n2 = this.sourceLocation.sourceFolder.getFullPath().segmentCount();
        int n3 = n - n2 - 1;
        --n;
        int n4 = n2;
        while (n4 < n) {
            n3 += iPath.segment(n4).length();
            ++n4;
        }
        String string = iPath.segment(n);
        int n5 = Util.indexOfJavaLikeExtension(string);
        char[] cArray = new char[n3 += n5];
        int n6 = 0;
        int n7 = n2;
        while (n7 < n) {
            String string2 = iPath.segment(n7);
            int n8 = string2.length();
            string2.getChars(0, n8, cArray, n6);
            n6 += n8;
            cArray[n6++] = 47;
            ++n7;
        }
        string.getChars(0, n5, cArray, n6);
        return new String(cArray);
    }

    public char[] getContents() {
        try {
            return Util.getResourceContentsAsCharArray(this.resource);
        }
        catch (CoreException coreException) {
            throw new AbortCompilation(true, new MissingSourceFileException(this.resource.getFullPath().toString()));
        }
    }

    public char[] getFileName() {
        return this.resource.getFullPath().toString().toCharArray();
    }

    public char[] getMainTypeName() {
        char[] cArray = this.initialTypeName.toCharArray();
        int n = CharOperation.lastIndexOf('/', cArray);
        return CharOperation.subarray(cArray, n + 1, -1);
    }

    public char[][] getPackageName() {
        char[] cArray = this.initialTypeName.toCharArray();
        int n = CharOperation.lastIndexOf('/', cArray);
        return CharOperation.splitOn('/', cArray, 0, n);
    }

    public int hashCode() {
        return this.initialTypeName.hashCode();
    }

    String typeLocator() {
        return this.resource.getProjectRelativePath().toString();
    }

    public String toString() {
        return "SourceFile[" + this.resource.getFullPath() + "]";
    }

    public LibrarySuperType getCommonSuperType() {
        IProject iProject = this.resource.getProject();
        IJavaProject iJavaProject = JavaCore.create(iProject);
        return iJavaProject.getCommonSuperType();
    }
}

