/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.builder;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRule;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.core.ClasspathAccessRule;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.builder.AdditionalTypeCollection;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathDirectory;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathLibrary;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathLocation;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.wst.jsdt.internal.core.builder.JavaBuilder;
import org.eclipse.wst.jsdt.internal.core.builder.ReferenceCollection;
import org.eclipse.wst.jsdt.internal.core.builder.StringSet;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class State {
    String javaProjectName;
    ClasspathMultiDirectory[] sourceLocations;
    ClasspathLocation[] binaryLocations;
    SimpleLookupTable references;
    public SimpleLookupTable typeLocators;
    int buildNumber;
    long lastStructuralBuildTime;
    SimpleLookupTable structuralBuildTimes;
    private String[] knownPackageNames;
    private long previousStructuralBuildTime;
    private StringSet structurallyChangedTypes;
    public static int MaxStructurallyChangedTypes = 100;
    public static final byte VERSION = 21;
    static final byte SOURCE_FOLDER = 1;
    static final byte BINARY_FOLDER = 2;
    static final byte EXTERNAL_JAR = 3;
    static final byte INTERNAL_JAR = 4;
    static final byte LIBRARY = 5;

    State() {
    }

    protected State(JavaBuilder javaBuilder) {
        this.knownPackageNames = null;
        this.previousStructuralBuildTime = -1L;
        this.structurallyChangedTypes = null;
        this.javaProjectName = javaBuilder.currentProject.getName();
        this.sourceLocations = javaBuilder.nameEnvironment.sourceLocations;
        this.binaryLocations = javaBuilder.nameEnvironment.binaryLocations;
        this.references = new SimpleLookupTable(7);
        this.typeLocators = new SimpleLookupTable(7);
        this.buildNumber = 0;
        this.lastStructuralBuildTime = this.computeStructuralBuildTime(javaBuilder.lastState == null ? 0L : javaBuilder.lastState.lastStructuralBuildTime);
        this.structuralBuildTimes = new SimpleLookupTable(3);
    }

    long computeStructuralBuildTime(long l) {
        long l2 = System.currentTimeMillis();
        if (l2 <= l) {
            l2 = l + 1L;
        }
        return l2;
    }

    /*
     * Unable to fully structure code
     */
    void copyFrom(State var1_1) {
        block6: {
            this.knownPackageNames = null;
            this.previousStructuralBuildTime = var1_1.previousStructuralBuildTime;
            this.structurallyChangedTypes = var1_1.structurallyChangedTypes;
            this.buildNumber = var1_1.buildNumber + 1;
            this.lastStructuralBuildTime = var1_1.lastStructuralBuildTime;
            this.structuralBuildTimes = var1_1.structuralBuildTimes;
            try {
                this.references = (SimpleLookupTable)var1_1.references.clone();
                this.typeLocators = (SimpleLookupTable)var1_1.typeLocators.clone();
                break block6;
            }
            catch (CloneNotSupportedException v0) {
                this.references = new SimpleLookupTable(var1_1.references.elementSize);
                var2_2 = var1_1.references.keyTable;
                var3_3 = var1_1.references.valueTable;
                var4_4 = 0;
                var5_5 = var2_2.length;
                ** while (var4_4 < var5_5)
            }
lbl-1000:
            // 1 sources

            {
                if (var2_2[var4_4] != null) {
                    this.references.put(var2_2[var4_4], var3_3[var4_4]);
                }
                ++var4_4;
                continue;
            }
lbl23:
            // 1 sources

            this.typeLocators = new SimpleLookupTable(var1_1.typeLocators.elementSize);
            var2_2 = var1_1.typeLocators.keyTable;
            var3_3 = var1_1.typeLocators.valueTable;
            var4_4 = 0;
            var5_5 = var2_2.length;
            while (var4_4 < var5_5) {
                if (var2_2[var4_4] != null) {
                    this.typeLocators.put(var2_2[var4_4], var3_3[var4_4]);
                }
                ++var4_4;
            }
        }
    }

    public char[][] getDefinedTypeNamesFor(String string) {
        Object object = this.references.get(string);
        if (object instanceof AdditionalTypeCollection) {
            return ((AdditionalTypeCollection)object).definedTypeNames;
        }
        return null;
    }

    StringSet getStructurallyChangedTypes(State state) {
        if (state != null && state.previousStructuralBuildTime > 0L) {
            long l;
            Object object = this.structuralBuildTimes.get(state.javaProjectName);
            long l2 = l = object == null ? 0L : (Long)object;
            if (l == state.previousStructuralBuildTime) {
                return state.structurallyChangedTypes;
            }
        }
        return null;
    }

    boolean isDuplicateLocator(String string, String string2) {
        String string3 = (String)this.typeLocators.get(string);
        return string3 != null && !string3.equals(string2);
    }

    boolean isKnownPackage(String string) {
        if (this.knownPackageNames == null) {
            ArrayList<String> arrayList = new ArrayList<String>(this.typeLocators.elementSize);
            Object[] objectArray = this.typeLocators.keyTable;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                if (objectArray[n] != null) {
                    String string2 = (String)objectArray[n];
                    int n3 = string2.lastIndexOf(47);
                    string2 = n3 == -1 ? null : string2.substring(0, n3);
                    while (string2 != null && !arrayList.contains(string2)) {
                        arrayList.add(string2);
                        n3 = string2.lastIndexOf(47);
                        String string3 = string2 = n3 == -1 ? null : string2.substring(0, n3);
                    }
                }
                ++n;
            }
            this.knownPackageNames = new String[arrayList.size()];
            arrayList.toArray(this.knownPackageNames);
        }
        int n = 0;
        int n4 = this.knownPackageNames.length;
        while (n < n4) {
            if (this.knownPackageNames[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean isKnownType(String string) {
        return this.typeLocators.containsKey(string);
    }

    void record(String string, char[][][] cArray, char[][] cArray2, char[] cArray3, ArrayList arrayList) {
        if (arrayList.size() == 1 && CharOperation.equals(cArray3, (char[])arrayList.get(0))) {
            this.references.put(string, new ReferenceCollection(cArray, cArray2));
        } else {
            char[][] cArrayArray = new char[arrayList.size()][];
            arrayList.toArray((T[])cArrayArray);
            this.references.put(string, new AdditionalTypeCollection(cArrayArray, cArray, cArray2));
        }
    }

    void recordLocatorForType(String string, String string2) {
        this.knownPackageNames = null;
        int n = string2.indexOf(string, 0);
        if (n > 0) {
            string = string2.substring(n, n + string.length());
        }
        this.typeLocators.put(string, string2);
    }

    void recordStructuralDependency(IProject iProject, State state) {
        if (state != null && state.lastStructuralBuildTime > 0L) {
            this.structuralBuildTimes.put(iProject.getName(), new Long(state.lastStructuralBuildTime));
        }
    }

    void removeLocator(String string) {
        this.knownPackageNames = null;
        this.references.removeKey(string);
        this.typeLocators.removeValue(string);
    }

    void removePackage(IResourceDelta iResourceDelta) {
        IResource iResource = iResourceDelta.getResource();
        switch (iResource.getType()) {
            case 2: {
                IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
                int n = 0;
                int n2 = iResourceDeltaArray.length;
                while (n < n2) {
                    this.removePackage(iResourceDeltaArray[n]);
                    ++n;
                }
                return;
            }
            case 1: {
                IPath iPath = iResource.getProjectRelativePath();
                if (!Util.isJavaLikeFileName(iPath.lastSegment())) break;
                this.removeLocator(iPath.toString());
            }
        }
    }

    void removeQualifiedTypeName(String string) {
        this.knownPackageNames = null;
        this.typeLocators.removeKey(string);
    }

    static State read(IProject iProject, DataInputStream dataInputStream) throws IOException {
        Object object;
        Object object2;
        IProject iProject2;
        if (JavaBuilder.DEBUG) {
            System.out.println("About to read state " + iProject.getName());
        }
        if (21 != dataInputStream.readByte()) {
            if (JavaBuilder.DEBUG) {
                System.out.println("Found non-compatible state version... answered null for " + iProject.getName());
            }
            return null;
        }
        State state = new State();
        state.javaProjectName = dataInputStream.readUTF();
        if (!iProject.getName().equals(state.javaProjectName)) {
            if (JavaBuilder.DEBUG) {
                System.out.println("Project's name does not match... answered null");
            }
            return null;
        }
        state.buildNumber = dataInputStream.readInt();
        state.lastStructuralBuildTime = dataInputStream.readLong();
        int n = dataInputStream.readInt();
        state.sourceLocations = new ClasspathMultiDirectory[n];
        int n2 = 0;
        while (n2 < n) {
            IProject iProject3 = iProject;
            iProject2 = iProject;
            object2 = dataInputStream.readUTF();
            if (((String)object2).length() > 0) {
                iProject3 = iProject.getFolder((String)object2);
            }
            if (((String)(object2 = dataInputStream.readUTF())).length() > 0) {
                iProject2 = iProject.getFolder((String)object2);
            }
            ClasspathMultiDirectory classpathMultiDirectory = (ClasspathMultiDirectory)ClasspathLocation.forSourceFolder((IContainer)iProject3, (IContainer)iProject2, State.readNames(dataInputStream), State.readNames(dataInputStream));
            if (dataInputStream.readBoolean()) {
                classpathMultiDirectory.hasIndependentOutputFolder = true;
            }
            state.sourceLocations[n2] = classpathMultiDirectory;
            ++n2;
        }
        n = dataInputStream.readInt();
        state.binaryLocations = new ClasspathLocation[n];
        IWorkspaceRoot iWorkspaceRoot = iProject.getWorkspace().getRoot();
        int n3 = 0;
        while (n3 < n) {
            switch (dataInputStream.readByte()) {
                case 1: {
                    state.binaryLocations[n3] = state.sourceLocations[dataInputStream.readInt()];
                    break;
                }
                case 2: {
                    iProject2 = new Path(dataInputStream.readUTF());
                    object2 = iProject2.segmentCount() == 1 ? iWorkspaceRoot.getProject(iProject2.toString()) : iWorkspaceRoot.getFolder((IPath)iProject2);
                    state.binaryLocations[n3] = ClasspathLocation.forBinaryFolder((IContainer)object2, dataInputStream.readBoolean(), State.readRestriction(dataInputStream));
                    break;
                }
                case 3: {
                    state.binaryLocations[n3] = ClasspathLocation.forLibrary(dataInputStream.readUTF(), dataInputStream.readLong(), State.readRestriction(dataInputStream));
                    break;
                }
                case 4: {
                    state.binaryLocations[n3] = ClasspathLocation.forLibrary(iWorkspaceRoot.getFile((IPath)new Path(dataInputStream.readUTF())), State.readRestriction(dataInputStream));
                }
                case 5: {
                    state.binaryLocations[n3] = ClasspathLocation.forLibrary(dataInputStream.readUTF(), State.readRestriction(dataInputStream));
                }
            }
            ++n3;
        }
        n = dataInputStream.readInt();
        state.structuralBuildTimes = new SimpleLookupTable(n);
        n3 = 0;
        while (n3 < n) {
            state.structuralBuildTimes.put(dataInputStream.readUTF(), new Long(dataInputStream.readLong()));
            ++n3;
        }
        n = dataInputStream.readInt();
        String[] stringArray = new String[n];
        int n4 = 0;
        while (n4 < n) {
            stringArray[n4] = dataInputStream.readUTF();
            ++n4;
        }
        n = dataInputStream.readInt();
        state.typeLocators = new SimpleLookupTable(n);
        n4 = 0;
        while (n4 < n) {
            state.recordLocatorForType(dataInputStream.readUTF(), stringArray[dataInputStream.readInt()]);
            ++n4;
        }
        char[][] cArray = ReferenceCollection.internSimpleNames(State.readNames(dataInputStream), false);
        n = dataInputStream.readInt();
        object2 = new char[n][][];
        int n5 = 0;
        while (n5 < n) {
            int n6 = dataInputStream.readInt();
            object = new char[n6][];
            int n7 = 0;
            while (n7 < n6) {
                object[n7] = cArray[dataInputStream.readInt()];
                ++n7;
            }
            object2[n5] = object;
            ++n5;
        }
        object2 = ReferenceCollection.internQualifiedNames((char[][][])object2);
        n = dataInputStream.readInt();
        state.references = new SimpleLookupTable(n);
        n5 = 0;
        while (n5 < n) {
            String string = stringArray[dataInputStream.readInt()];
            object = null;
            switch (dataInputStream.readByte()) {
                case 1: {
                    char[][] cArray2 = State.readNames(dataInputStream);
                    char[][][] cArrayArray = new char[dataInputStream.readInt()][][];
                    int n8 = 0;
                    int n9 = cArrayArray.length;
                    while (n8 < n9) {
                        cArrayArray[n8] = (char[][])object2[dataInputStream.readInt()];
                        ++n8;
                    }
                    char[][] cArrayArray2 = new char[dataInputStream.readInt()][];
                    n9 = 0;
                    int n10 = cArrayArray2.length;
                    while (n9 < n10) {
                        cArrayArray2[n9] = cArray[dataInputStream.readInt()];
                        ++n9;
                    }
                    object = new AdditionalTypeCollection(cArray2, cArrayArray, cArrayArray2);
                    break;
                }
                case 2: {
                    char[][][] cArrayArray = new char[dataInputStream.readInt()][][];
                    int n10 = 0;
                    int n11 = cArrayArray.length;
                    while (n10 < n11) {
                        cArrayArray[n10] = (char[][])object2[dataInputStream.readInt()];
                        ++n10;
                    }
                    char[][] cArrayArray3 = new char[dataInputStream.readInt()][];
                    n11 = 0;
                    int n12 = cArrayArray3.length;
                    while (n11 < n12) {
                        cArrayArray3[n11] = cArray[dataInputStream.readInt()];
                        ++n11;
                    }
                    object = new ReferenceCollection(cArrayArray, cArrayArray3);
                }
            }
            state.references.put(string, object);
            ++n5;
        }
        if (JavaBuilder.DEBUG) {
            System.out.println("Successfully read state for " + state.javaProjectName);
        }
        return state;
    }

    private static char[] readName(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = dataInputStream.readChar();
            ++n2;
        }
        return cArray;
    }

    private static char[][] readNames(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        char[][] cArrayArray = new char[n][];
        int n2 = 0;
        while (n2 < n) {
            cArrayArray[n2] = State.readName(dataInputStream);
            ++n2;
        }
        return cArrayArray;
    }

    private static AccessRuleSet readRestriction(DataInputStream dataInputStream) throws IOException {
        int n;
        Object[] objectArray;
        int n2 = dataInputStream.readInt();
        if (n2 == 0) {
            return null;
        }
        AccessRule[] accessRuleArray = new AccessRule[n2];
        int n3 = 0;
        while (n3 < n2) {
            objectArray = State.readName(dataInputStream);
            n = dataInputStream.readInt();
            accessRuleArray[n3] = new ClasspathAccessRule((char[])objectArray, n);
            ++n3;
        }
        JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
        objectArray = new String[4];
        n = 0;
        while (n < 4) {
            objectArray[n] = (char)javaModelManager.intern(dataInputStream.readUTF());
            ++n;
        }
        AccessRuleSet accessRuleSet = new AccessRuleSet(accessRuleArray, (String[])objectArray);
        return accessRuleSet;
    }

    void tagAsNoopBuild() {
        this.buildNumber = -1;
    }

    boolean wasNoopBuild() {
        return this.buildNumber == -1;
    }

    void tagAsStructurallyChanged() {
        this.previousStructuralBuildTime = this.lastStructuralBuildTime;
        this.structurallyChangedTypes = new StringSet(7);
        this.lastStructuralBuildTime = this.computeStructuralBuildTime(this.previousStructuralBuildTime);
    }

    boolean wasStructurallyChanged(IProject iProject, State state) {
        if (state != null) {
            long l;
            Object object = this.structuralBuildTimes.get(iProject.getName());
            long l2 = l = object == null ? 0L : (Long)object;
            if (l == state.lastStructuralBuildTime) {
                return false;
            }
        }
        return true;
    }

    void wasStructurallyChanged(String string) {
        if (this.structurallyChangedTypes != null) {
            if (this.structurallyChangedTypes.elementSize > MaxStructurallyChangedTypes) {
                this.structurallyChangedTypes = null;
            } else {
                this.structurallyChangedTypes.add(string);
            }
        }
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        Object object;
        int n2;
        int n3;
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3;
        int n4;
        ClasspathLocation classpathLocation;
        dataOutputStream.writeByte(21);
        dataOutputStream.writeUTF(this.javaProjectName);
        dataOutputStream.writeInt(this.buildNumber);
        dataOutputStream.writeLong(this.lastStructuralBuildTime);
        int n5 = this.sourceLocations.length;
        dataOutputStream.writeInt(n5);
        int n6 = 0;
        while (n6 < n5) {
            classpathLocation = this.sourceLocations[n6];
            dataOutputStream.writeUTF(classpathLocation.sourceFolder.getProjectRelativePath().toString());
            dataOutputStream.writeUTF(classpathLocation.binaryFolder.getProjectRelativePath().toString());
            this.writeNames(classpathLocation.inclusionPatterns, dataOutputStream);
            this.writeNames(classpathLocation.exclusionPatterns, dataOutputStream);
            dataOutputStream.writeBoolean(classpathLocation.hasIndependentOutputFolder);
            ++n6;
        }
        n5 = this.binaryLocations.length;
        dataOutputStream.writeInt(n5);
        n6 = 0;
        while (n6 < n5) {
            classpathLocation = this.binaryLocations[n6];
            if (classpathLocation instanceof ClasspathMultiDirectory) {
                dataOutputStream.writeByte(1);
                int n7 = 0;
                n4 = this.sourceLocations.length;
                while (n7 < n4) {
                    if (this.sourceLocations[n7] == classpathLocation) {
                        dataOutputStream.writeInt(n7);
                        break;
                    }
                    ++n7;
                }
            } else if (classpathLocation instanceof ClasspathDirectory) {
                dataOutputStream.writeByte(2);
                ClasspathDirectory classpathDirectory = classpathLocation;
                dataOutputStream.writeUTF(classpathDirectory.binaryFolder.getFullPath().toString());
                dataOutputStream.writeBoolean(classpathDirectory.isOutputFolder);
                this.writeRestriction(classpathDirectory.accessRuleSet, dataOutputStream);
            } else {
                ClasspathLibrary classpathLibrary = (ClasspathLibrary)classpathLocation;
                dataOutputStream.writeByte(5);
                dataOutputStream.writeUTF(classpathLibrary.filename);
                this.writeRestriction(classpathLibrary.accessRuleSet, dataOutputStream);
            }
            ++n6;
        }
        n5 = this.structuralBuildTimes.elementSize;
        dataOutputStream.writeInt(n5);
        if (n5 > 0) {
            objectArray3 = this.structuralBuildTimes.keyTable;
            objectArray2 = this.structuralBuildTimes.valueTable;
            n6 = 0;
            int n8 = objectArray3.length;
            while (n6 < n8) {
                if (objectArray3[n6] != null) {
                    --n5;
                    dataOutputStream.writeUTF((String)objectArray3[n6]);
                    dataOutputStream.writeLong((Long)objectArray2[n6]);
                }
                ++n6;
            }
            if (JavaBuilder.DEBUG && n5 != 0) {
                System.out.println("structuralBuildNumbers table is inconsistent");
            }
        }
        n5 = this.references.elementSize;
        dataOutputStream.writeInt(n5);
        SimpleLookupTable simpleLookupTable = new SimpleLookupTable(n5);
        if (n5 > 0) {
            objectArray3 = this.references.keyTable;
            int n9 = 0;
            int n10 = objectArray3.length;
            while (n9 < n10) {
                if (objectArray3[n9] != null) {
                    --n5;
                    String string = (String)objectArray3[n9];
                    dataOutputStream.writeUTF(string);
                    simpleLookupTable.put(string, new Integer(simpleLookupTable.elementSize));
                }
                ++n9;
            }
            if (JavaBuilder.DEBUG && n5 != 0) {
                System.out.println("references table is inconsistent");
            }
        }
        n5 = this.typeLocators.elementSize;
        dataOutputStream.writeInt(n5);
        if (n5 > 0) {
            objectArray3 = this.typeLocators.keyTable;
            objectArray2 = this.typeLocators.valueTable;
            int n11 = 0;
            int n12 = objectArray3.length;
            while (n11 < n12) {
                if (objectArray3[n11] != null) {
                    --n5;
                    dataOutputStream.writeUTF((String)objectArray3[n11]);
                    Integer n13 = (Integer)simpleLookupTable.get(objectArray2[n11]);
                    dataOutputStream.writeInt(n13);
                }
                ++n11;
            }
            if (JavaBuilder.DEBUG && n5 != 0) {
                System.out.println("typeLocators table is inconsistent");
            }
        }
        SimpleLookupTable simpleLookupTable2 = new SimpleLookupTable(31);
        SimpleLookupTable simpleLookupTable3 = new SimpleLookupTable(31);
        objectArray2 = this.references.valueTable;
        n4 = 0;
        int n14 = objectArray2.length;
        while (n4 < n14) {
            if (objectArray2[n4] != null) {
                objectArray = (Object[])objectArray2[n4];
                char[][][] cArray = objectArray.qualifiedNameReferences;
                int n15 = 0;
                n3 = cArray.length;
                while (n15 < n3) {
                    char[][] cArray2 = cArray[n15];
                    if (!simpleLookupTable2.containsKey(cArray2)) {
                        simpleLookupTable2.put(cArray2, new Integer(simpleLookupTable2.elementSize));
                        int n16 = 0;
                        n2 = cArray2.length;
                        while (n16 < n2) {
                            object = cArray2[n16];
                            if (!simpleLookupTable3.containsKey(object)) {
                                simpleLookupTable3.put(object, new Integer(simpleLookupTable3.elementSize));
                            }
                            ++n16;
                        }
                    }
                    ++n15;
                }
                char[][] cArray3 = objectArray.simpleNameReferences;
                n3 = 0;
                n = cArray3.length;
                while (n3 < n) {
                    char[] cArray4 = cArray3[n3];
                    if (!simpleLookupTable3.containsKey(cArray4)) {
                        simpleLookupTable3.put(cArray4, new Integer(simpleLookupTable3.elementSize));
                    }
                    ++n3;
                }
            }
            ++n4;
        }
        char[][] cArrayArray = new char[simpleLookupTable3.elementSize][];
        Object[] objectArray4 = simpleLookupTable3.keyTable;
        objectArray = simpleLookupTable3.valueTable;
        int n17 = objectArray.length;
        while (--n17 >= 0) {
            if (objectArray[n17] == null) continue;
            int n18 = (Integer)objectArray[n17];
            cArrayArray[n18] = (char[])objectArray4[n17];
        }
        this.writeNames(cArrayArray, dataOutputStream);
        char[][][] cArrayArray2 = new char[simpleLookupTable2.elementSize][][];
        Object[] objectArray5 = simpleLookupTable2.keyTable;
        objectArray = simpleLookupTable2.valueTable;
        n3 = objectArray.length;
        while (--n3 >= 0) {
            if (objectArray[n3] == null) continue;
            n = (Integer)objectArray[n3];
            cArrayArray2[n] = (char[][])objectArray5[n3];
        }
        n5 = cArrayArray2.length;
        dataOutputStream.writeInt(n5);
        n3 = 0;
        while (n3 < n5) {
            char[][] cArray = cArrayArray2[n3];
            int n19 = cArray.length;
            dataOutputStream.writeInt(n19);
            n2 = 0;
            while (n2 < n19) {
                object = (Integer)simpleLookupTable3.get(cArray[n2]);
                dataOutputStream.writeInt(object.intValue());
                ++n2;
            }
            ++n3;
        }
        n5 = this.references.elementSize;
        dataOutputStream.writeInt(n5);
        if (n5 > 0) {
            objectArray3 = this.references.keyTable;
            n3 = 0;
            int n20 = objectArray3.length;
            while (n3 < n20) {
                if (objectArray3[n3] != null) {
                    --n5;
                    Integer n21 = (Integer)simpleLookupTable.get(objectArray3[n3]);
                    dataOutputStream.writeInt(n21);
                    ReferenceCollection referenceCollection = (ReferenceCollection)objectArray2[n3];
                    if (referenceCollection instanceof AdditionalTypeCollection) {
                        dataOutputStream.writeByte(1);
                        object = (AdditionalTypeCollection)referenceCollection;
                        this.writeNames(object.definedTypeNames, dataOutputStream);
                    } else {
                        dataOutputStream.writeByte(2);
                    }
                    object = referenceCollection.qualifiedNameReferences;
                    int n22 = ((char[])object).length;
                    dataOutputStream.writeInt(n22);
                    int n23 = 0;
                    while (n23 < n22) {
                        n21 = (Integer)simpleLookupTable2.get(object[n23]);
                        dataOutputStream.writeInt(n21);
                        ++n23;
                    }
                    char[][] cArray = referenceCollection.simpleNameReferences;
                    int n24 = cArray.length;
                    dataOutputStream.writeInt(n24);
                    int n25 = 0;
                    while (n25 < n24) {
                        n21 = (Integer)simpleLookupTable3.get(cArray[n25]);
                        dataOutputStream.writeInt(n21);
                        ++n25;
                    }
                }
                ++n3;
            }
            if (JavaBuilder.DEBUG && n5 != 0) {
                System.out.println("references table is inconsistent");
            }
        }
    }

    private void writeName(char[] cArray, DataOutputStream dataOutputStream) throws IOException {
        int n = cArray.length;
        dataOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            dataOutputStream.writeChar(cArray[n2]);
            ++n2;
        }
    }

    private void writeNames(char[][] cArray, DataOutputStream dataOutputStream) throws IOException {
        int n = cArray == null ? 0 : cArray.length;
        dataOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            this.writeName(cArray[n2], dataOutputStream);
            ++n2;
        }
    }

    private void writeRestriction(AccessRuleSet accessRuleSet, DataOutputStream dataOutputStream) throws IOException {
        if (accessRuleSet == null) {
            dataOutputStream.writeInt(0);
        } else {
            AccessRule[] accessRuleArray = accessRuleSet.getAccessRules();
            int n = accessRuleArray.length;
            dataOutputStream.writeInt(n);
            if (n != 0) {
                int n2 = 0;
                while (n2 < n) {
                    AccessRule accessRule = accessRuleArray[n2];
                    this.writeName(accessRule.pattern, dataOutputStream);
                    dataOutputStream.writeInt(accessRule.problemId);
                    ++n2;
                }
                n2 = 0;
                while (n2 < 4) {
                    dataOutputStream.writeUTF(accessRuleSet.messageTemplates[n2]);
                    ++n2;
                }
            }
        }
    }

    public String toString() {
        return "State for " + this.javaProjectName + " (#" + this.buildNumber + " @ " + new Date(this.lastStructuralBuildTime) + ")";
    }
}

