/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.dom.rewrite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.formatter.IndentManipulation;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.ASTRewriteFlattener;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.NodeInfoStore;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.RewriteEventStore;

final class ASTRewriteFormatter {
    private final String lineDelimiter;
    private final int tabWidth;
    private final int indentWidth;
    private final NodeInfoStore placeholders;
    private final RewriteEventStore eventStore;
    private final Map options;
    public static final Prefix NONE = new ConstPrefix("");
    public static final Prefix SPACE = new ConstPrefix(" ");
    public static final Prefix ASSERT_COMMENT = new ConstPrefix(" : ");
    public final Prefix VAR_INITIALIZER = new FormattingPrefix("A a={};", "a={", 2);
    public final Prefix METHOD_BODY = new FormattingPrefix("void a() {}", ") {", 4);
    public final Prefix FINALLY_BLOCK = new FormattingPrefix("try {} finally {}", "} finally {", 2);
    public final Prefix CATCH_BLOCK = new FormattingPrefix("try {} catch(Exception e) {}", "} c", 2);
    public final Prefix ANNOT_MEMBER_DEFAULT = new FormattingPrefix("String value() default 1;", ") default 1", 4);
    public final Prefix ENUM_BODY_START = new FormattingPrefix("enum E { A(){void foo(){}} }", "){v", 8);
    public final Prefix ENUM_BODY_END = new FormattingPrefix("enum E { A(){void foo(){ }}, B}", "}},", 8);
    public final Prefix WILDCARD_EXTENDS = new FormattingPrefix("A<? extends B> a;", "? extends B", 4);
    public final Prefix WILDCARD_SUPER = new FormattingPrefix("A<? super B> a;", "? super B", 4);
    public final Prefix FIRST_ENUM_CONST = new FormattingPrefix("enum E { X;}", "{ X", 8);
    public final Prefix ANNOTATION_SEPARATION = new FormattingPrefix("@A @B class C {}", "A @", 8);
    public final BlockContext IF_BLOCK_WITH_ELSE = new BlockFormattingPrefixSuffix("if (true)", "else{}", 8);
    public final BlockContext IF_BLOCK_NO_ELSE = new BlockFormattingPrefix("if (true)", 8);
    public final BlockContext ELSE_AFTER_STATEMENT = new BlockFormattingPrefix("if (true) foo(); else ", 15);
    public final BlockContext ELSE_AFTER_BLOCK = new BlockFormattingPrefix("if (true) {} else ", 11);
    public final BlockContext FOR_BLOCK = new BlockFormattingPrefix("for (;;) ", 7);
    public final BlockContext WHILE_BLOCK = new BlockFormattingPrefix("while (true)", 11);
    public final BlockContext DO_BLOCK = new BlockFormattingPrefixSuffix("do ", "while (true);", 1);

    public ASTRewriteFormatter(NodeInfoStore nodeInfoStore, RewriteEventStore rewriteEventStore, Map map, String string) {
        this.placeholders = nodeInfoStore;
        this.eventStore = rewriteEventStore;
        if (map == null) {
            map = JavaCore.getOptions();
        }
        this.options = map;
        this.lineDelimiter = string;
        this.tabWidth = IndentManipulation.getTabWidth(map);
        this.indentWidth = IndentManipulation.getIndentWidth(map);
    }

    public NodeInfoStore getPlaceholders() {
        return this.placeholders;
    }

    public RewriteEventStore getEventStore() {
        return this.eventStore;
    }

    public int getTabWidth() {
        return this.tabWidth;
    }

    public int getIndentWidth() {
        return this.indentWidth;
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public String getFormattedResult(ASTNode aSTNode, int n, Collection collection) {
        ExtendedFlattener extendedFlattener = new ExtendedFlattener(this.eventStore);
        aSTNode.accept(extendedFlattener);
        Position[] positionArray = extendedFlattener.getMarkers();
        int n2 = 0;
        while (n2 < positionArray.length) {
            collection.add(positionArray[n2]);
            ++n2;
        }
        String string = extendedFlattener.getResult();
        TextEdit textEdit = this.formatNode(aSTNode, string, n);
        if (textEdit == null) {
            if (n > 0) {
                String string2 = this.createIndentString(n);
                ReplaceEdit[] replaceEditArray = IndentManipulation.getChangeIndentEdits(string, 0, this.tabWidth, this.indentWidth, string2);
                textEdit = new MultiTextEdit();
                textEdit.addChild((TextEdit)new InsertEdit(0, string2));
                textEdit.addChildren((TextEdit[])replaceEditArray);
            } else {
                return string;
            }
        }
        return ASTRewriteFormatter.evaluateFormatterEdit(string, textEdit, positionArray);
    }

    public String createIndentString(int n) {
        return ToolFactory.createCodeFormatter(this.options).createIndentationString(n);
    }

    public String getIndentString(String string) {
        return IndentManipulation.extractIndentString(string, this.tabWidth, this.indentWidth);
    }

    public String changeIndent(String string, int n, String string2) {
        return IndentManipulation.changeIndent(string, n, this.tabWidth, this.indentWidth, string2, this.lineDelimiter);
    }

    public int computeIndentUnits(String string) {
        return IndentManipulation.measureIndentUnits(string, this.tabWidth, this.indentWidth);
    }

    public static String evaluateFormatterEdit(String string, TextEdit textEdit, Position[] positionArray) {
        try {
            Document document = ASTRewriteFormatter.createDocument(string, positionArray);
            textEdit.apply((IDocument)document, 0);
            if (positionArray != null) {
                int n = 0;
                while (n < positionArray.length) {
                    Assert.isTrue((!positionArray[n].isDeleted ? 1 : 0) != 0, (String)"Position got deleted");
                    ++n;
                }
            }
            return document.get();
        }
        catch (BadLocationException badLocationException) {
            Assert.isTrue((boolean)false, (String)("Fromatter created edits with wrong positions: " + badLocationException.getMessage()));
            return null;
        }
    }

    public TextEdit formatString(int n, String string, int n2, int n3, int n4) {
        return ToolFactory.createCodeFormatter(this.options).format(n, string, n2, n3, n4, this.lineDelimiter);
    }

    private TextEdit formatNode(ASTNode aSTNode, String string, int n) {
        int n2;
        String string2 = "";
        String string3 = "";
        if (aSTNode instanceof Statement) {
            n2 = 2;
            if (aSTNode.getNodeType() == 49) {
                string2 = "switch(1) {";
                string3 = "}";
                n2 = 2;
            }
        } else if (aSTNode instanceof Expression && aSTNode.getNodeType() != 58) {
            n2 = 1;
        } else if (aSTNode instanceof BodyDeclaration) {
            n2 = 4;
        } else {
            switch (aSTNode.getNodeType()) {
                case 5: 
                case 39: 
                case 43: 
                case 74: 
                case 75: {
                    string3 = " x;";
                    n2 = 4;
                    break;
                }
                case 76: {
                    string2 = "A<";
                    string3 = "> x;";
                    n2 = 4;
                    break;
                }
                case 15: {
                    n2 = 8;
                    break;
                }
                case 44: 
                case 58: {
                    string3 = ";";
                    n2 = 2;
                    break;
                }
                case 59: {
                    string2 = "A ";
                    string3 = ";";
                    n2 = 2;
                    break;
                }
                case 26: 
                case 35: {
                    string3 = "\nclass A {}";
                    n2 = 8;
                    break;
                }
                case 29: {
                    string3 = "\nclass A {}";
                    n2 = 8;
                    break;
                }
                case 12: {
                    string2 = "try {}";
                    n2 = 2;
                    break;
                }
                case 1: {
                    string2 = "new A()";
                    string3 = ";";
                    n2 = 2;
                    break;
                }
                case 80: {
                    string2 = "@Author(";
                    string3 = ") class x {}";
                    n2 = 8;
                    break;
                }
                case 100: {
                    string3 = " class x {}";
                    n2 = 8;
                    break;
                }
                case 73: {
                    string2 = "class X<";
                    string3 = "> {}";
                    n2 = 8;
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: {
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        String string4 = String.valueOf(string2) + string + string3;
        TextEdit textEdit = this.formatString(n2, string4, string2.length(), string.length(), n);
        if (string2.length() > 0) {
            textEdit = ASTRewriteFormatter.shifEdit(textEdit, string2.length());
        }
        return textEdit;
    }

    private static TextEdit shifEdit(TextEdit textEdit, int n) {
        MultiTextEdit multiTextEdit;
        TextEdit[] textEditArray;
        if (textEdit instanceof ReplaceEdit) {
            textEditArray = (TextEdit[])textEdit;
            multiTextEdit = new ReplaceEdit(textEditArray.getOffset() - n, textEditArray.getLength(), textEditArray.getText());
        } else if (textEdit instanceof InsertEdit) {
            textEditArray = (InsertEdit)textEdit;
            multiTextEdit = new InsertEdit(textEditArray.getOffset() - n, textEditArray.getText());
        } else if (textEdit instanceof DeleteEdit) {
            textEditArray = (DeleteEdit)textEdit;
            multiTextEdit = new DeleteEdit(textEditArray.getOffset() - n, textEditArray.getLength());
        } else if (textEdit instanceof MultiTextEdit) {
            multiTextEdit = new MultiTextEdit();
        } else {
            return null;
        }
        textEditArray = textEdit.getChildren();
        int n2 = 0;
        while (n2 < textEditArray.length) {
            TextEdit textEdit2 = ASTRewriteFormatter.shifEdit(textEditArray[n2], n);
            if (textEdit2 != null) {
                multiTextEdit.addChild(textEdit2);
            }
            ++n2;
        }
        return multiTextEdit;
    }

    private static Document createDocument(String string, Position[] positionArray) throws IllegalArgumentException {
        Document document;
        block5: {
            document = new Document(string);
            try {
                if (positionArray == null) break block5;
                document.addPositionCategory("myCategory");
                document.addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater("myCategory"){

                    protected boolean notDeleted() {
                        int n = this.fOffset;
                        int n2 = n + this.fLength;
                        if (n < this.fPosition.offset && this.fPosition.offset + this.fPosition.length < n2) {
                            this.fPosition.offset = n2;
                            return false;
                        }
                        return true;
                    }
                });
                int n = 0;
                while (n < positionArray.length) {
                    try {
                        document.addPosition("myCategory", positionArray[n]);
                    }
                    catch (BadLocationException badLocationException) {
                        throw new IllegalArgumentException("Position outside of string. offset: " + positionArray[n].offset + ", length: " + positionArray[n].length + ", string size: " + string.length());
                    }
                    ++n;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
        return document;
    }

    public static interface BlockContext {
        public String[] getPrefixAndSuffix(int var1, ASTNode var2, RewriteEventStore var3);
    }

    private class BlockFormattingPrefix
    implements BlockContext {
        private String prefix;
        private int start;

        public BlockFormattingPrefix(String string, int n) {
            this.start = n;
            this.prefix = string;
        }

        public String[] getPrefixAndSuffix(int n, ASTNode aSTNode, RewriteEventStore rewriteEventStore) {
            String string = ASTRewriteFlattener.asString(aSTNode, rewriteEventStore);
            String string2 = String.valueOf(this.prefix) + string;
            Position position = new Position(this.start, this.prefix.length() + 1 - this.start);
            TextEdit textEdit = ASTRewriteFormatter.this.formatString(2, string2, 0, string2.length(), n);
            if (textEdit != null) {
                string2 = ASTRewriteFormatter.evaluateFormatterEdit(string2, textEdit, new Position[]{position});
            }
            return new String[]{string2.substring(position.offset + 1, position.offset + position.length - 1), ""};
        }
    }

    private class BlockFormattingPrefixSuffix
    implements BlockContext {
        private String prefix;
        private String suffix;
        private int start;

        public BlockFormattingPrefixSuffix(String string, String string2, int n) {
            this.start = n;
            this.suffix = string2;
            this.prefix = string;
        }

        public String[] getPrefixAndSuffix(int n, ASTNode aSTNode, RewriteEventStore rewriteEventStore) {
            String string = ASTRewriteFlattener.asString(aSTNode, rewriteEventStore);
            int n2 = this.prefix.length();
            int n3 = n2 + string.length() - 1;
            String string2 = String.valueOf(this.prefix) + string + this.suffix;
            Position position = new Position(this.start, n2 + 1 - this.start);
            Position position2 = new Position(n3, 2);
            TextEdit textEdit = ASTRewriteFormatter.this.formatString(2, string2, 0, string2.length(), n);
            if (textEdit != null) {
                string2 = ASTRewriteFormatter.evaluateFormatterEdit(string2, textEdit, new Position[]{position, position2});
            }
            return new String[]{string2.substring(position.offset + 1, position.offset + position.length - 1), string2.substring(position2.offset + 1, position2.offset + position2.length - 1)};
        }
    }

    public static class ConstPrefix
    implements Prefix {
        private String prefix;

        public ConstPrefix(String string) {
            this.prefix = string;
        }

        public String getPrefix(int n) {
            return this.prefix;
        }
    }

    private class ExtendedFlattener
    extends ASTRewriteFlattener {
        private ArrayList positions = new ArrayList();

        public ExtendedFlattener(RewriteEventStore rewriteEventStore) {
            super(rewriteEventStore);
        }

        public void preVisit(ASTNode aSTNode) {
            Object object;
            TextEditGroup textEditGroup = ASTRewriteFormatter.this.getEventStore().getTrackedNodeData(aSTNode);
            if (textEditGroup != null) {
                this.addMarker(textEditGroup, this.result.length(), 0);
            }
            if ((object = ASTRewriteFormatter.this.getPlaceholders().getPlaceholderData(aSTNode)) != null) {
                this.addMarker(object, this.result.length(), 0);
            }
        }

        public void postVisit(ASTNode aSTNode) {
            TextEditGroup textEditGroup;
            Object object = ASTRewriteFormatter.this.getPlaceholders().getPlaceholderData(aSTNode);
            if (object != null) {
                this.fixupLength(object, this.result.length());
            }
            if ((textEditGroup = ASTRewriteFormatter.this.getEventStore().getTrackedNodeData(aSTNode)) != null) {
                this.fixupLength(textEditGroup, this.result.length());
            }
        }

        public boolean visit(Block block) {
            if (ASTRewriteFormatter.this.getPlaceholders().isCollapsed(block)) {
                this.visitList(block, Block.STATEMENTS_PROPERTY, null);
                return false;
            }
            return super.visit(block);
        }

        private NodeMarker addMarker(Object object, int n, int n2) {
            NodeMarker nodeMarker = new NodeMarker();
            nodeMarker.offset = n;
            nodeMarker.length = n2;
            nodeMarker.data = object;
            this.positions.add(nodeMarker);
            return nodeMarker;
        }

        private void fixupLength(Object object, int n) {
            int n2 = this.positions.size() - 1;
            while (n2 >= 0) {
                NodeMarker nodeMarker = (NodeMarker)((Object)this.positions.get(n2));
                if (nodeMarker.data == object) {
                    nodeMarker.length = n - nodeMarker.offset;
                    return;
                }
                --n2;
            }
        }

        public NodeMarker[] getMarkers() {
            return this.positions.toArray(new NodeMarker[this.positions.size()]);
        }
    }

    private class FormattingPrefix
    implements Prefix {
        private int kind;
        private String string;
        private int start;
        private int length;

        public FormattingPrefix(String string, String string2, int n) {
            this.start = string.indexOf(string2);
            this.length = string2.length();
            this.string = string;
            this.kind = n;
        }

        public String getPrefix(int n) {
            Position position = new Position(this.start, this.length);
            String string = this.string;
            TextEdit textEdit = ASTRewriteFormatter.this.formatString(this.kind, string, 0, string.length(), n);
            if (textEdit != null) {
                string = ASTRewriteFormatter.evaluateFormatterEdit(string, textEdit, new Position[]{position});
            }
            return string.substring(position.offset + 1, position.offset + position.length - 1);
        }
    }

    public static class NodeMarker
    extends Position {
        public Object data;
    }

    public static interface Prefix {
        public String getPrefix(int var1);
    }
}

