/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.dom.rewrite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.ListRewriteEvent;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.NodeRewriteEvent;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.RewriteEvent;

public final class RewriteEventStore {
    public static final int NEW = 1;
    public static final int ORIGINAL = 2;
    public static final int BOTH = 3;
    final List events = new ArrayList();
    private EventHolder lastEvent = null;
    private Map editGroups = null;
    List nodeCopySources = null;
    Map nodeRangeInfos = null;
    Map trackedNodes = null;
    private Set insertBoundToPrevious = null;
    private INodePropertyMapper nodePropertyMapper = null;
    private static final String INTERNAL_PLACEHOLDER_PROPERTY = "rewrite_internal_placeholder";

    public void setNodePropertyMapper(INodePropertyMapper iNodePropertyMapper) {
        this.nodePropertyMapper = iNodePropertyMapper;
    }

    public void clear() {
        this.events.clear();
        this.lastEvent = null;
        this.trackedNodes = null;
        this.editGroups = null;
        this.insertBoundToPrevious = null;
        this.nodeCopySources = null;
    }

    public void addEvent(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, RewriteEvent rewriteEvent) {
        this.validateHasChildProperty(aSTNode, structuralPropertyDescriptor);
        if (rewriteEvent.isListRewrite()) {
            this.validateIsListProperty(structuralPropertyDescriptor);
        }
        EventHolder eventHolder = new EventHolder(aSTNode, structuralPropertyDescriptor, rewriteEvent);
        int n = 0;
        while (n < this.events.size()) {
            EventHolder eventHolder2 = (EventHolder)this.events.get(n);
            if (eventHolder2.parent == aSTNode && eventHolder2.childProperty == structuralPropertyDescriptor) {
                this.events.set(n, eventHolder);
                this.lastEvent = null;
                return;
            }
            ++n;
        }
        this.events.add(eventHolder);
    }

    public RewriteEvent getEvent(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        this.validateHasChildProperty(aSTNode, structuralPropertyDescriptor);
        if (this.lastEvent != null && this.lastEvent.parent == aSTNode && this.lastEvent.childProperty == structuralPropertyDescriptor) {
            return this.lastEvent.event;
        }
        int n = 0;
        while (n < this.events.size()) {
            EventHolder eventHolder = (EventHolder)this.events.get(n);
            if (eventHolder.parent == aSTNode && eventHolder.childProperty == structuralPropertyDescriptor) {
                this.lastEvent = eventHolder;
                return eventHolder.event;
            }
            ++n;
        }
        return null;
    }

    public NodeRewriteEvent getNodeEvent(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, boolean bl) {
        this.validateIsNodeProperty(structuralPropertyDescriptor);
        NodeRewriteEvent nodeRewriteEvent = (NodeRewriteEvent)this.getEvent(aSTNode, structuralPropertyDescriptor);
        if (nodeRewriteEvent == null && bl) {
            Object object = this.accessOriginalValue(aSTNode, structuralPropertyDescriptor);
            nodeRewriteEvent = new NodeRewriteEvent(object, object);
            this.addEvent(aSTNode, structuralPropertyDescriptor, nodeRewriteEvent);
        }
        return nodeRewriteEvent;
    }

    public ListRewriteEvent getListEvent(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, boolean bl) {
        this.validateIsListProperty(structuralPropertyDescriptor);
        ListRewriteEvent listRewriteEvent = (ListRewriteEvent)this.getEvent(aSTNode, structuralPropertyDescriptor);
        if (listRewriteEvent == null && bl) {
            List list = (List)this.accessOriginalValue(aSTNode, structuralPropertyDescriptor);
            listRewriteEvent = new ListRewriteEvent(list);
            this.addEvent(aSTNode, structuralPropertyDescriptor, listRewriteEvent);
        }
        return listRewriteEvent;
    }

    public Iterator getChangeRootIterator() {
        return new ParentIterator();
    }

    public boolean hasChangedProperties(ASTNode aSTNode) {
        int n = 0;
        while (n < this.events.size()) {
            EventHolder eventHolder = (EventHolder)this.events.get(n);
            if (eventHolder.parent == aSTNode && eventHolder.event.getChangeKind() != 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public PropertyLocation getPropertyLocation(Object object, int n) {
        int n2 = 0;
        while (n2 < this.events.size()) {
            EventHolder eventHolder = (EventHolder)this.events.get(n2);
            RewriteEvent rewriteEvent = eventHolder.event;
            if (this.isNodeInEvent(rewriteEvent, object, n)) {
                return new PropertyLocation(eventHolder.parent, eventHolder.childProperty);
            }
            if (rewriteEvent.isListRewrite()) {
                RewriteEvent[] rewriteEventArray = rewriteEvent.getChildren();
                int n3 = 0;
                while (n3 < rewriteEventArray.length) {
                    if (this.isNodeInEvent(rewriteEventArray[n3], object, n)) {
                        return new PropertyLocation(eventHolder.parent, eventHolder.childProperty);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        if (object instanceof ASTNode) {
            ASTNode aSTNode = (ASTNode)object;
            return new PropertyLocation(aSTNode.getParent(), aSTNode.getLocationInParent());
        }
        return null;
    }

    public RewriteEvent findEvent(Object object, int n) {
        int n2 = 0;
        while (n2 < this.events.size()) {
            RewriteEvent rewriteEvent = ((EventHolder)this.events.get((int)n2)).event;
            if (this.isNodeInEvent(rewriteEvent, object, n)) {
                return rewriteEvent;
            }
            if (rewriteEvent.isListRewrite()) {
                RewriteEvent[] rewriteEventArray = rewriteEvent.getChildren();
                int n3 = 0;
                while (n3 < rewriteEventArray.length) {
                    if (this.isNodeInEvent(rewriteEventArray[n3], object, n)) {
                        return rewriteEventArray[n3];
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return null;
    }

    private boolean isNodeInEvent(RewriteEvent rewriteEvent, Object object, int n) {
        if ((n & 1) != 0 && rewriteEvent.getNewValue() == object) {
            return true;
        }
        return (n & 2) != 0 && rewriteEvent.getOriginalValue() == object;
    }

    public Object getOriginalValue(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        RewriteEvent rewriteEvent = this.getEvent(aSTNode, structuralPropertyDescriptor);
        if (rewriteEvent != null) {
            return rewriteEvent.getOriginalValue();
        }
        return this.accessOriginalValue(aSTNode, structuralPropertyDescriptor);
    }

    public Object getNewValue(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        RewriteEvent rewriteEvent = this.getEvent(aSTNode, structuralPropertyDescriptor);
        if (rewriteEvent != null) {
            return rewriteEvent.getNewValue();
        }
        return this.accessOriginalValue(aSTNode, structuralPropertyDescriptor);
    }

    public int getChangeKind(ASTNode aSTNode) {
        RewriteEvent rewriteEvent = this.findEvent(aSTNode, 2);
        if (rewriteEvent != null) {
            return rewriteEvent.getChangeKind();
        }
        return 0;
    }

    private Object accessOriginalValue(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        if (this.nodePropertyMapper != null) {
            return this.nodePropertyMapper.getOriginalValue(aSTNode, structuralPropertyDescriptor);
        }
        return aSTNode.getStructuralProperty(structuralPropertyDescriptor);
    }

    public TextEditGroup getEventEditGroup(RewriteEvent rewriteEvent) {
        if (this.editGroups == null) {
            return null;
        }
        return (TextEditGroup)this.editGroups.get(rewriteEvent);
    }

    public void setEventEditGroup(RewriteEvent rewriteEvent, TextEditGroup textEditGroup) {
        if (this.editGroups == null) {
            this.editGroups = new IdentityHashMap(5);
        }
        this.editGroups.put(rewriteEvent, textEditGroup);
    }

    public final TextEditGroup getTrackedNodeData(ASTNode aSTNode) {
        if (this.trackedNodes != null) {
            return (TextEditGroup)this.trackedNodes.get(aSTNode);
        }
        return null;
    }

    public void setTrackedNodeData(ASTNode aSTNode, TextEditGroup textEditGroup) {
        if (this.trackedNodes == null) {
            this.trackedNodes = new IdentityHashMap();
        }
        this.trackedNodes.put(aSTNode, textEditGroup);
    }

    public final void markAsTracked(ASTNode aSTNode, TextEditGroup textEditGroup) {
        if (this.getTrackedNodeData(aSTNode) != null) {
            throw new IllegalArgumentException("Node is already marked as tracked");
        }
        this.setTrackedNodeData(aSTNode, textEditGroup);
    }

    private final CopySourceInfo createCopySourceInfo(PropertyLocation propertyLocation, ASTNode aSTNode, boolean bl) {
        CopySourceInfo copySourceInfo = new CopySourceInfo(propertyLocation, aSTNode, bl);
        if (this.nodeCopySources == null) {
            this.nodeCopySources = new ArrayList();
        }
        this.nodeCopySources.add(copySourceInfo);
        return copySourceInfo;
    }

    public final CopySourceInfo markAsCopySource(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, ASTNode aSTNode2, boolean bl) {
        return this.createCopySourceInfo(new PropertyLocation(aSTNode, structuralPropertyDescriptor), aSTNode2, bl);
    }

    public final boolean isRangeCopyPlaceholder(ASTNode aSTNode) {
        return aSTNode.getProperty(INTERNAL_PLACEHOLDER_PROPERTY) != null;
    }

    public final CopySourceInfo createRangeCopy(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, ASTNode aSTNode2, ASTNode aSTNode3, boolean bl, ASTNode aSTNode4, ASTNode aSTNode5, TextEditGroup textEditGroup) {
        PropertyLocation propertyLocation;
        ArrayList<NodeRangeInfo> arrayList;
        CopySourceInfo copySourceInfo = this.createCopySourceInfo(null, aSTNode4, bl);
        aSTNode4.setProperty(INTERNAL_PLACEHOLDER_PROPERTY, aSTNode4);
        NodeRangeInfo nodeRangeInfo = new NodeRangeInfo(aSTNode, structuralPropertyDescriptor, aSTNode2, aSTNode3, copySourceInfo, aSTNode5, textEditGroup);
        ListRewriteEvent listRewriteEvent = this.getListEvent(aSTNode, structuralPropertyDescriptor, true);
        int n = listRewriteEvent.getIndex(aSTNode2, 2);
        if (n == -1) {
            throw new IllegalArgumentException("Start node is not a original child of the given list");
        }
        int n2 = listRewriteEvent.getIndex(aSTNode3, 2);
        if (n2 == -1) {
            throw new IllegalArgumentException("End node is not a original child of the given list");
        }
        if (n > n2) {
            throw new IllegalArgumentException("Start node must be before end node");
        }
        if (this.nodeRangeInfos == null) {
            this.nodeRangeInfos = new HashMap();
        }
        if ((arrayList = (ArrayList<NodeRangeInfo>)this.nodeRangeInfos.get(propertyLocation = new PropertyLocation(aSTNode, structuralPropertyDescriptor))) == null) {
            arrayList = new ArrayList<NodeRangeInfo>(2);
            this.nodeRangeInfos.put(propertyLocation, arrayList);
        } else {
            this.assertNoOverlap(listRewriteEvent, n, n2, arrayList);
        }
        arrayList.add(nodeRangeInfo);
        return copySourceInfo;
    }

    public CopySourceInfo[] getNodeCopySources(ASTNode aSTNode) {
        if (this.nodeCopySources == null) {
            return null;
        }
        return this.internalGetCopySources(this.nodeCopySources, aSTNode);
    }

    public CopySourceInfo[] internalGetCopySources(List list, ASTNode aSTNode) {
        ArrayList<CopySourceInfo> arrayList = new ArrayList<CopySourceInfo>(3);
        int n = 0;
        while (n < list.size()) {
            CopySourceInfo copySourceInfo = (CopySourceInfo)list.get(n);
            if (copySourceInfo.getNode() == aSTNode) {
                arrayList.add(copySourceInfo);
            }
            ++n;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        Object[] objectArray = arrayList.toArray(new CopySourceInfo[arrayList.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private void assertNoOverlap(ListRewriteEvent listRewriteEvent, int n, int n2, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NodeRangeInfo nodeRangeInfo = (NodeRangeInfo)iterator.next();
            int n3 = listRewriteEvent.getIndex(nodeRangeInfo.getStartNode(), 3);
            int n4 = listRewriteEvent.getIndex(nodeRangeInfo.getEndNode(), 3);
            if ((n3 >= n || n4 >= n2 || n4 < n) && (n3 <= n || n3 > n4 || n4 <= n2)) continue;
            throw new IllegalArgumentException("Range overlapps with an existing copy or move range");
        }
    }

    public void prepareMovedNodes(TargetSourceRangeComputer targetSourceRangeComputer) {
        if (this.nodeCopySources != null) {
            this.prepareSingleNodeCopies();
        }
        if (this.nodeRangeInfos != null) {
            this.prepareNodeRangeCopies(targetSourceRangeComputer);
        }
    }

    public void revertMovedNodes() {
        if (this.nodeRangeInfos != null) {
            this.removeMoveRangePlaceholders();
        }
    }

    private void removeMoveRangePlaceholders() {
        Iterator iterator = this.nodeRangeInfos.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            HashSet<Block> hashSet = new HashSet<Block>();
            List list = (List)entry.getValue();
            int n = 0;
            while (n < list.size()) {
                hashSet.add(((NodeRangeInfo)list.get(n)).getInternalPlaceholder());
                ++n;
            }
            PropertyLocation propertyLocation = (PropertyLocation)entry.getKey();
            RewriteEvent[] rewriteEventArray = this.getListEvent(propertyLocation.getParent(), propertyLocation.getProperty(), true).getChildren();
            ArrayList arrayList = new ArrayList();
            this.revertListWithRanges(rewriteEventArray, hashSet, arrayList);
            RewriteEvent[] rewriteEventArray2 = arrayList.toArray(new RewriteEvent[arrayList.size()]);
            this.addEvent(propertyLocation.getParent(), propertyLocation.getProperty(), new ListRewriteEvent(rewriteEventArray2));
        }
    }

    private void revertListWithRanges(RewriteEvent[] rewriteEventArray, Set set, List list) {
        int n = 0;
        while (n < rewriteEventArray.length) {
            RewriteEvent rewriteEvent = rewriteEventArray[n];
            ASTNode aSTNode = (ASTNode)rewriteEvent.getOriginalValue();
            if (set.contains(aSTNode)) {
                RewriteEvent[] rewriteEventArray2 = this.getListEvent(aSTNode, Block.STATEMENTS_PROPERTY, false).getChildren();
                this.revertListWithRanges(rewriteEventArray2, set, list);
            } else {
                list.add(rewriteEvent);
            }
            ++n;
        }
    }

    private void prepareNodeRangeCopies(TargetSourceRangeComputer targetSourceRangeComputer) {
        Iterator iterator = this.nodeRangeInfos.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            List list = (List)entry.getValue();
            Collections.sort(list);
            PropertyLocation propertyLocation = (PropertyLocation)entry.getKey();
            RewriteEvent[] rewriteEventArray = this.getListEvent(propertyLocation.getParent(), propertyLocation.getProperty(), true).getChildren();
            RewriteEvent[] rewriteEventArray2 = this.processListWithRanges(list, rewriteEventArray, targetSourceRangeComputer);
            this.addEvent(propertyLocation.getParent(), propertyLocation.getProperty(), new ListRewriteEvent(rewriteEventArray2));
        }
    }

    private RewriteEvent[] processListWithRanges(List list, RewriteEvent[] rewriteEventArray, TargetSourceRangeComputer targetSourceRangeComputer) {
        List<RewriteEvent> list2 = new ArrayList<RewriteEvent>(rewriteEventArray.length);
        NodeRangeInfo nodeRangeInfo = null;
        Stack<ArrayList<RewriteEvent>> stack = new Stack<ArrayList<RewriteEvent>>();
        Stack<NodeRangeInfo> stack2 = new Stack<NodeRangeInfo>();
        Iterator iterator = list.iterator();
        NodeRangeInfo nodeRangeInfo2 = (NodeRangeInfo)iterator.next();
        int n = 0;
        while (n < rewriteEventArray.length) {
            Object object;
            RewriteEvent[] rewriteEventArray2;
            RewriteEvent rewriteEvent = rewriteEventArray[n];
            ASTNode aSTNode = (ASTNode)rewriteEvent.getOriginalValue();
            while (nodeRangeInfo2 != null && aSTNode == nodeRangeInfo2.getStartNode()) {
                nodeRangeInfo2.updatePlaceholderSourceRanges(targetSourceRangeComputer);
                rewriteEventArray2 = nodeRangeInfo2.getInternalPlaceholder();
                object = nodeRangeInfo2.isMove() ? new NodeRewriteEvent(rewriteEventArray2, nodeRangeInfo2.replacingNode) : new NodeRewriteEvent(rewriteEventArray2, rewriteEventArray2);
                list2.add((RewriteEvent)object);
                if (nodeRangeInfo2.editGroup != null) {
                    this.setEventEditGroup((RewriteEvent)object, nodeRangeInfo2.editGroup);
                }
                stack.push((ArrayList<RewriteEvent>)list2);
                stack2.push(nodeRangeInfo);
                list2 = new ArrayList(rewriteEventArray.length);
                nodeRangeInfo = nodeRangeInfo2;
                NodeRangeInfo nodeRangeInfo3 = nodeRangeInfo2 = iterator.hasNext() ? (NodeRangeInfo)iterator.next() : null;
            }
            list2.add(rewriteEvent);
            while (nodeRangeInfo != null && aSTNode == nodeRangeInfo.getEndNode()) {
                rewriteEventArray2 = list2.toArray(new RewriteEvent[list2.size()]);
                object = nodeRangeInfo.getInternalPlaceholder();
                this.addEvent((ASTNode)object, Block.STATEMENTS_PROPERTY, new ListRewriteEvent(rewriteEventArray2));
                list2 = (List)stack.pop();
                nodeRangeInfo = (NodeRangeInfo)stack2.pop();
            }
            ++n;
        }
        return list2.toArray(new RewriteEvent[list2.size()]);
    }

    private void prepareSingleNodeCopies() {
        int n = 0;
        while (n < this.nodeCopySources.size()) {
            CopySourceInfo copySourceInfo = (CopySourceInfo)this.nodeCopySources.get(n);
            if (copySourceInfo.isMove && copySourceInfo.location != null) {
                this.doMarkMovedAsRemoved(copySourceInfo, copySourceInfo.location.getParent(), copySourceInfo.location.getProperty());
            }
            ++n;
        }
    }

    private void doMarkMovedAsRemoved(CopySourceInfo copySourceInfo, ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        if (structuralPropertyDescriptor.isChildListProperty()) {
            ListRewriteEvent listRewriteEvent = this.getListEvent(aSTNode, structuralPropertyDescriptor, true);
            int n = listRewriteEvent.getIndex(copySourceInfo.getNode(), 2);
            if (n != -1 && listRewriteEvent.getChangeKind(n) == 0) {
                listRewriteEvent.setNewValue(null, n);
            }
        } else {
            NodeRewriteEvent nodeRewriteEvent = this.getNodeEvent(aSTNode, structuralPropertyDescriptor, true);
            if (nodeRewriteEvent.getChangeKind() == 0) {
                nodeRewriteEvent.setNewValue(null);
            }
        }
    }

    public boolean isInsertBoundToPrevious(ASTNode aSTNode) {
        if (this.insertBoundToPrevious != null) {
            return this.insertBoundToPrevious.contains(aSTNode);
        }
        return false;
    }

    public void setInsertBoundToPrevious(ASTNode aSTNode) {
        if (this.insertBoundToPrevious == null) {
            this.insertBoundToPrevious = new HashSet();
        }
        this.insertBoundToPrevious.add(aSTNode);
    }

    private void validateIsListProperty(StructuralPropertyDescriptor structuralPropertyDescriptor) {
        if (!structuralPropertyDescriptor.isChildListProperty()) {
            String string = String.valueOf(structuralPropertyDescriptor.getId()) + " is not a list property";
            throw new IllegalArgumentException(string);
        }
    }

    private void validateHasChildProperty(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        if (!aSTNode.structuralPropertiesForType().contains(structuralPropertyDescriptor)) {
            String string = String.valueOf(Signature.getSimpleName(aSTNode.getClass().getName())) + " has no property " + structuralPropertyDescriptor.getId();
            throw new IllegalArgumentException(string);
        }
    }

    private void validateIsNodeProperty(StructuralPropertyDescriptor structuralPropertyDescriptor) {
        if (structuralPropertyDescriptor.isChildListProperty()) {
            String string = String.valueOf(structuralPropertyDescriptor.getId()) + " is not a node property";
            throw new IllegalArgumentException(string);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.events.size()) {
            stringBuffer.append(this.events.get(n).toString()).append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean isNewNode(ASTNode aSTNode) {
        return (aSTNode.getFlags() & 2) == 0;
    }

    public static class CopySourceInfo
    implements Comparable {
        public final PropertyLocation location;
        private final ASTNode node;
        public final boolean isMove;

        public CopySourceInfo(PropertyLocation propertyLocation, ASTNode aSTNode, boolean bl) {
            this.location = propertyLocation;
            this.node = aSTNode;
            this.isMove = bl;
        }

        public ASTNode getNode() {
            return this.node;
        }

        public int compareTo(Object object) {
            CopySourceInfo copySourceInfo = (CopySourceInfo)object;
            int n = this.getNode().getStartPosition() - copySourceInfo.getNode().getStartPosition();
            if (n != 0) {
                return n;
            }
            if (copySourceInfo.isMove != this.isMove) {
                return this.isMove ? -1 : 1;
            }
            return 0;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.isMove) {
                stringBuffer.append("move source: ");
            } else {
                stringBuffer.append("copy source: ");
            }
            stringBuffer.append(this.node);
            return stringBuffer.toString();
        }
    }

    private static class EventHolder {
        public final ASTNode parent;
        public final StructuralPropertyDescriptor childProperty;
        public final RewriteEvent event;

        public EventHolder(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, RewriteEvent rewriteEvent) {
            this.parent = aSTNode;
            this.childProperty = structuralPropertyDescriptor;
            this.event = rewriteEvent;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.parent).append(" - ");
            stringBuffer.append(this.childProperty.getId()).append(": ");
            stringBuffer.append(this.event).append('\n');
            return stringBuffer.toString();
        }
    }

    public static interface INodePropertyMapper {
        public Object getOriginalValue(ASTNode var1, StructuralPropertyDescriptor var2);
    }

    private static class NodeRangeInfo
    implements Comparable {
        private final ASTNode first;
        private final ASTNode last;
        public final CopySourceInfo copyInfo;
        public final ASTNode replacingNode;
        public final TextEditGroup editGroup;

        public NodeRangeInfo(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, ASTNode aSTNode2, ASTNode aSTNode3, CopySourceInfo copySourceInfo, ASTNode aSTNode4, TextEditGroup textEditGroup) {
            this.first = aSTNode2;
            this.last = aSTNode3;
            this.copyInfo = copySourceInfo;
            this.replacingNode = aSTNode4;
            this.editGroup = textEditGroup;
        }

        public ASTNode getStartNode() {
            return this.first;
        }

        public ASTNode getEndNode() {
            return this.last;
        }

        public boolean isMove() {
            return this.copyInfo.isMove;
        }

        public Block getInternalPlaceholder() {
            return (Block)this.copyInfo.getNode();
        }

        public int compareTo(Object object) {
            NodeRangeInfo nodeRangeInfo = (NodeRangeInfo)object;
            int n = this.getStartNode().getStartPosition() - nodeRangeInfo.getStartNode().getStartPosition();
            if (n != 0) {
                return n;
            }
            int n2 = this.getEndNode().getStartPosition() - nodeRangeInfo.getEndNode().getStartPosition();
            if (n2 != 0) {
                return -n2;
            }
            if (nodeRangeInfo.isMove() != this.isMove()) {
                return this.isMove() ? -1 : 1;
            }
            return 0;
        }

        public void updatePlaceholderSourceRanges(TargetSourceRangeComputer targetSourceRangeComputer) {
            TargetSourceRangeComputer.SourceRange sourceRange = targetSourceRangeComputer.computeSourceRange(this.getStartNode());
            TargetSourceRangeComputer.SourceRange sourceRange2 = targetSourceRangeComputer.computeSourceRange(this.getEndNode());
            int n = sourceRange.getStartPosition();
            int n2 = sourceRange2.getStartPosition() + sourceRange2.getLength();
            Block block = this.getInternalPlaceholder();
            block.setSourceRange(n, n2 - n);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.first != this.last) {
                stringBuffer.append("range ");
            }
            if (this.isMove()) {
                stringBuffer.append("move source: ");
            } else {
                stringBuffer.append("copy source: ");
            }
            stringBuffer.append(this.first);
            stringBuffer.append(" - ");
            stringBuffer.append(this.last);
            return stringBuffer.toString();
        }
    }

    private class ParentIterator
    implements Iterator {
        private Iterator eventIter;
        private Iterator sourceNodeIter;
        private Iterator rangeNodeIter;
        private Iterator trackedNodeIter;

        public ParentIterator() {
            this.eventIter = RewriteEventStore.this.events.iterator();
            this.sourceNodeIter = RewriteEventStore.this.nodeCopySources != null ? RewriteEventStore.this.nodeCopySources.iterator() : Collections.EMPTY_LIST.iterator();
            this.rangeNodeIter = RewriteEventStore.this.nodeRangeInfos != null ? RewriteEventStore.this.nodeRangeInfos.keySet().iterator() : Collections.EMPTY_LIST.iterator();
            this.trackedNodeIter = RewriteEventStore.this.trackedNodes != null ? RewriteEventStore.this.trackedNodes.keySet().iterator() : Collections.EMPTY_LIST.iterator();
        }

        public boolean hasNext() {
            return this.eventIter.hasNext() || this.sourceNodeIter.hasNext() || this.rangeNodeIter.hasNext() || this.trackedNodeIter.hasNext();
        }

        public Object next() {
            if (this.eventIter.hasNext()) {
                return ((EventHolder)this.eventIter.next()).parent;
            }
            if (this.sourceNodeIter.hasNext()) {
                return ((CopySourceInfo)this.sourceNodeIter.next()).getNode();
            }
            if (this.rangeNodeIter.hasNext()) {
                return ((PropertyLocation)this.rangeNodeIter.next()).getParent();
            }
            return this.trackedNodeIter.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class PropertyLocation {
        private final ASTNode parent;
        private final StructuralPropertyDescriptor property;

        public PropertyLocation(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
            this.parent = aSTNode;
            this.property = structuralPropertyDescriptor;
        }

        public ASTNode getParent() {
            return this.parent;
        }

        public StructuralPropertyDescriptor getProperty() {
            return this.property;
        }

        public boolean equals(Object object) {
            if (object != null && object.getClass().equals(this.getClass())) {
                PropertyLocation propertyLocation = (PropertyLocation)object;
                return propertyLocation.getParent().equals(this.getParent()) && propertyLocation.getProperty().equals(this.getProperty());
            }
            return false;
        }

        public int hashCode() {
            return this.getParent().hashCode() + this.getProperty().hashCode();
        }
    }
}

