/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.jdom;

import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.wst.jsdt.core.jdom.IDOMNode;
import org.eclipse.wst.jsdt.core.jdom.IDOMType;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMNode;
import org.eclipse.wst.jsdt.internal.core.jdom.ILineStartFinder;
import org.eclipse.wst.jsdt.internal.core.util.CharArrayBuffer;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

class DOMCompilationUnit
extends DOMNode
implements IDOMCompilationUnit,
SuffixConstants {
    protected String fHeader = "";

    DOMCompilationUnit() {
    }

    DOMCompilationUnit(char[] cArray, int[] nArray) {
        super(cArray, nArray, null, new int[]{-1, -1});
    }

    protected void appendFragmentedContents(CharArrayBuffer charArrayBuffer) {
        charArrayBuffer.append(this.getHeader());
        this.appendContentsOfChildren(charArrayBuffer);
    }

    public boolean canHaveChildren() {
        return true;
    }

    public String getHeader() {
        return this.fHeader;
    }

    public IJavaElement getJavaElement(IJavaElement iJavaElement) throws IllegalArgumentException {
        if (iJavaElement.getElementType() == 4) {
            return ((IPackageFragment)iJavaElement).getCompilationUnit(this.getName());
        }
        throw new IllegalArgumentException(Messages.element_illegalParent);
    }

    public String getName() {
        IDOMType iDOMType = null;
        IDOMType iDOMType2 = null;
        IDOMNode iDOMNode = this.fFirstChild;
        while (iDOMNode != null) {
            if (iDOMNode.getNodeType() == 4) {
                IDOMType iDOMType3 = (IDOMType)iDOMNode;
                if (iDOMType2 == null) {
                    iDOMType2 = iDOMType3;
                }
                if (Flags.isPublic(iDOMType3.getFlags())) {
                    iDOMType = iDOMType3;
                    break;
                }
            }
            iDOMNode = iDOMNode.getNextNode();
        }
        if (iDOMType == null) {
            iDOMType = iDOMType2;
        }
        if (iDOMType != null) {
            return String.valueOf(iDOMType.getName()) + Util.defaultJavaExtension();
        }
        return null;
    }

    public int getNodeType() {
        return 1;
    }

    protected void initalizeHeader() {
        int n;
        DOMNode dOMNode = (DOMNode)this.getFirstChild();
        if (dOMNode != null && (n = dOMNode.getStartPosition()) > 1) {
            this.setHeader(new String(this.fDocument, 0, n));
        }
    }

    public boolean isAllowableChild(IDOMNode iDOMNode) {
        if (iDOMNode != null) {
            int n = iDOMNode.getNodeType();
            return n == 2 || n == 3 || n == 4;
        }
        return false;
    }

    protected DOMNode newDOMNode() {
        return new DOMCompilationUnit();
    }

    void normalize(ILineStartFinder iLineStartFinder) {
        super.normalize(iLineStartFinder);
        this.initalizeHeader();
    }

    public void setHeader(String string) {
        this.fHeader = string;
        this.fragment();
    }

    public void setName(String string) {
    }

    protected void shareContents(DOMNode dOMNode) {
        super.shareContents(dOMNode);
        this.fHeader = ((DOMCompilationUnit)dOMNode).fHeader;
    }

    public String toString() {
        return "COMPILATION_UNIT: " + this.getName();
    }
}

