/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.core.search.IndexSelector;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchDocument;
import org.eclipse.wst.jsdt.internal.core.search.indexing.BinaryIndexer;
import org.eclipse.wst.jsdt.internal.core.search.indexing.SourceIndexer;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class JavaSearchParticipant
extends SearchParticipant {
    IndexSelector indexSelector;

    public void beginSearching() {
        super.beginSearching();
        this.indexSelector = null;
    }

    public void doneSearching() {
        this.indexSelector = null;
        super.doneSearching();
    }

    public String getDescription() {
        return "Java";
    }

    public SearchDocument getDocument(String string) {
        return new JavaSearchDocument(string, this);
    }

    public void indexDocument(SearchDocument searchDocument, IPath iPath) {
        searchDocument.removeAllIndexEntries();
        String string = searchDocument.getPath();
        if (Util.isJavaLikeFileName(string)) {
            new SourceIndexer(searchDocument).indexDocument();
        } else if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(string)) {
            new BinaryIndexer(searchDocument).indexDocument();
        }
    }

    public void locateMatches(SearchDocument[] searchDocumentArray, SearchPattern searchPattern, IJavaSearchScope iJavaSearchScope, SearchRequestor searchRequestor, IProgressMonitor iProgressMonitor) throws CoreException {
        MatchLocator matchLocator = new MatchLocator(searchPattern, searchRequestor, iJavaSearchScope, iProgressMonitor);
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        matchLocator.locateMatches(searchDocumentArray);
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        matchLocator.locatePackageDeclarations(this);
    }

    public IPath[] selectIndexes(SearchPattern searchPattern, IJavaSearchScope iJavaSearchScope) {
        if (this.indexSelector == null) {
            this.indexSelector = new IndexSelector(iJavaSearchScope, searchPattern);
        }
        return this.indexSelector.getIndexLocations();
    }
}

