/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchDocument;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.wst.jsdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.wst.jsdt.internal.core.search.processing.JobManager;
import org.eclipse.wst.jsdt.internal.core.util.Util;

class AddLibraryFileToIndex
extends IndexRequest {
    public AddLibraryFileToIndex(IFile iFile, IndexManager indexManager) {
        super(iFile.getFullPath(), indexManager);
    }

    public AddLibraryFileToIndex(IPath iPath, IndexManager indexManager) {
        super(iPath, indexManager);
    }

    public boolean equals(Object object) {
        if (object instanceof AddLibraryFileToIndex && this.containerPath != null) {
            return this.containerPath.equals((Object)((AddLibraryFileToIndex)object).containerPath);
        }
        return false;
    }

    public int hashCode() {
        if (this.containerPath != null) {
            return this.containerPath.hashCode();
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor iProgressMonitor) {
        if (this.isCancelled) return true;
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return true;
        }
        try {
            Index index = this.manager.getIndexForUpdate(this.containerPath, false, false);
            if (index != null) {
                if (!JobManager.VERBOSE) return true;
                Util.verbose("-> no indexing required (index already exists) for " + this.containerPath);
                return true;
            }
            index = this.manager.getIndexForUpdate(this.containerPath, true, true);
            if (index == null) {
                if (!JobManager.VERBOSE) return true;
                Util.verbose("-> index could not be created for " + this.containerPath);
                return true;
            }
            ReadWriteMonitor readWriteMonitor = index.monitor;
            if (readWriteMonitor == null) {
                if (!JobManager.VERBOSE) return true;
                Util.verbose("-> index for " + this.containerPath + " just got deleted");
                return true;
            }
            try {
                SearchParticipant searchParticipant;
                long l;
                Path path;
                block20: {
                    block19: {
                        block18: {
                            path = null;
                            readWriteMonitor.enterWrite();
                            if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Creating ZipFile on " + this.containerPath);
                            }
                            path = (Path)this.containerPath;
                            if (!this.isCancelled) break block18;
                            if (JobManager.VERBOSE) {
                                Util.verbose("-> indexing of " + path.toString() + " has been cancelled");
                            }
                            break block19;
                        }
                        if (JobManager.VERBOSE) {
                            Util.verbose("-> indexing " + path.toString());
                        }
                        l = System.currentTimeMillis();
                        searchParticipant = SearchEngine.getDefaultSearchParticipant();
                        index = this.manager.recreateIndex(this.containerPath);
                        if (index != null) break block20;
                        this.manager.removeIndex(this.containerPath);
                    }
                    Object var12_6 = null;
                    readWriteMonitor.exitWrite();
                    return false;
                }
                File file = new File(path.toOSString());
                char[] cArray = org.eclipse.wst.jsdt.internal.compiler.util.Util.getFileCharContent(file, null);
                String string = path.lastSegment();
                JavaSearchDocument javaSearchDocument = new JavaSearchDocument((IPath)path, cArray, searchParticipant, string);
                this.manager.indexDocument(javaSearchDocument, searchParticipant, index, this.containerPath);
                this.manager.saveIndex(index);
                if (JobManager.VERBOSE) {
                    Util.verbose("-> done indexing of " + path.toString() + " (" + (System.currentTimeMillis() - l) + "ms)");
                }
                Object var12_8 = null;
                readWriteMonitor.exitWrite();
                return true;
            }
            catch (Throwable throwable) {
                Object var12_7 = null;
                readWriteMonitor.exitWrite();
                throw throwable;
            }
        }
        catch (IOException iOException) {
            if (JobManager.VERBOSE) {
                Util.verbose("-> failed to index " + this.containerPath + " because of the following exception:");
                iOException.printStackTrace();
            }
            this.manager.removeIndex(this.containerPath);
            return false;
        }
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing " + this.containerPath.toString();
    }
}

