/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.search.indexing.SourceIndexer;
import org.eclipse.wst.jsdt.internal.core.search.processing.JobManager;

public class SourceIndexerRequestor
implements ISourceElementRequestor,
IIndexConstants {
    SourceIndexer indexer;
    char[] packageName = CharOperation.NO_CHAR;
    char[][] enclosingTypeNames = new char[5][];
    int depth = 0;
    int methodDepth = 0;

    public SourceIndexerRequestor(SourceIndexer sourceIndexer) {
        this.indexer = sourceIndexer;
    }

    public void acceptConstructorReference(char[] cArray, int n, int n2) {
        if (CharOperation.indexOf('<', cArray) > 0) {
            cArray = Signature.toCharArray(Signature.getTypeErasure(Signature.createTypeSignature(cArray, false)).toCharArray());
        }
        this.indexer.addConstructorReference(cArray, n);
        int n3 = CharOperation.lastIndexOf('.', cArray);
        if (n3 != -1) {
            char[][] cArray2 = CharOperation.splitOn('.', CharOperation.subarray(cArray, 0, n3));
            int n4 = 0;
            int n5 = cArray2.length;
            while (n4 < n5) {
                this.indexer.addNameReference(cArray2[n4]);
                ++n4;
            }
        }
    }

    public void acceptFieldReference(char[] cArray, int n) {
        this.indexer.addFieldReference(cArray);
    }

    public void acceptImport(int n, int n2, char[][] cArray, boolean bl, int n3) {
    }

    public void acceptLineSeparatorPositions(int[] nArray) {
    }

    public void acceptMethodReference(char[] cArray, int n, int n2) {
        this.indexer.addMethodReference(cArray, n);
    }

    public void acceptPackage(int n, int n2, char[] cArray) {
        this.packageName = cArray;
    }

    public void acceptProblem(CategorizedProblem categorizedProblem) {
    }

    public void acceptTypeReference(char[][] cArray, int n, int n2) {
        int n3 = cArray.length;
        int n4 = 0;
        while (n4 < n3 - 1) {
            this.acceptUnknownReference(cArray[n4], 0);
            ++n4;
        }
        this.acceptTypeReference(cArray[n3 - 1], 0);
    }

    public void acceptTypeReference(char[] cArray, int n) {
        this.indexer.addTypeReference(cArray);
    }

    public void acceptUnknownReference(char[][] cArray, int n, int n2) {
        int n3 = 0;
        while (n3 < cArray.length) {
            this.acceptUnknownReference(cArray[n3], 0);
            ++n3;
        }
    }

    public void acceptUnknownReference(char[] cArray, int n) {
        this.indexer.addNameReference(cArray);
    }

    public char[][] enclosingTypeNames() {
        if (this.depth == 0) {
            return null;
        }
        char[][] cArrayArray = new char[this.depth][];
        System.arraycopy(this.enclosingTypeNames, 0, cArrayArray, 0, this.depth);
        return cArrayArray;
    }

    private void enterAnnotationType(ISourceElementRequestor.TypeInfo typeInfo) {
        char[][] cArray = this.methodDepth > 0 ? ONE_ZERO_CHAR : this.enclosingTypeNames();
        this.indexer.addAnnotationTypeDeclaration(typeInfo.modifiers, this.packageName, typeInfo.name, cArray, typeInfo.secondary);
        this.pushTypeName(typeInfo.name);
    }

    private void enterClass(ISourceElementRequestor.TypeInfo typeInfo) {
        if (typeInfo.superclass != null) {
            typeInfo.superclass = this.getSimpleName(typeInfo.superclass);
            this.indexer.addConstructorReference(typeInfo.superclass, 0);
        }
        if (typeInfo.superinterfaces != null) {
            int n = 0;
            int n2 = typeInfo.superinterfaces.length;
            while (n < n2) {
                typeInfo.superinterfaces[n] = this.getSimpleName(typeInfo.superinterfaces[n]);
                ++n;
            }
        }
        char[][] cArray = this.methodDepth > 0 ? ONE_ZERO_CHAR : this.enclosingTypeNames();
        Object object = null;
        if (typeInfo.typeParameters != null) {
            int n = typeInfo.typeParameters.length;
            object = new char[n][];
            int n3 = 0;
            while (n3 < n) {
                ISourceElementRequestor.TypeParameterInfo typeParameterInfo = typeInfo.typeParameters[n3];
                object[n3] = Signature.createTypeParameterSignature(typeParameterInfo.name, typeParameterInfo.bounds == null ? CharOperation.NO_CHAR_CHAR : typeParameterInfo.bounds);
                ++n3;
            }
        }
        this.indexer.addClassDeclaration(typeInfo.modifiers, this.packageName, typeInfo.name, cArray, typeInfo.superclass, typeInfo.superinterfaces, (char[][])object, typeInfo.secondary);
        this.pushTypeName(typeInfo.name);
    }

    public void enterCompilationUnit() {
    }

    public void enterConstructor(ISourceElementRequestor.MethodInfo methodInfo) {
        this.indexer.addConstructorDeclaration(methodInfo.name, methodInfo.parameterTypes, methodInfo.exceptionTypes);
        ++this.methodDepth;
    }

    private void enterEnum(ISourceElementRequestor.TypeInfo typeInfo) {
        if (typeInfo.superinterfaces != null) {
            int n = 0;
            int n2 = typeInfo.superinterfaces.length;
            while (n < n2) {
                typeInfo.superinterfaces[n] = this.getSimpleName(typeInfo.superinterfaces[n]);
                ++n;
            }
        }
        char[][] cArray = this.methodDepth > 0 ? ONE_ZERO_CHAR : this.enclosingTypeNames();
        char[] cArray2 = typeInfo.superclass == null ? CharOperation.concatWith(TypeConstants.JAVA_LANG_ENUM, '.') : typeInfo.superclass;
        this.indexer.addEnumDeclaration(typeInfo.modifiers, this.packageName, typeInfo.name, cArray, cArray2, typeInfo.superinterfaces, typeInfo.secondary);
        this.pushTypeName(typeInfo.name);
    }

    public void enterField(ISourceElementRequestor.FieldInfo fieldInfo) {
        if (this.depth > 0 || this.methodDepth == 0) {
            boolean bl = this.depth == 0;
            this.indexer.addFieldDeclaration(fieldInfo.type, fieldInfo.name, bl);
        }
        ++this.methodDepth;
    }

    public void enterInitializer(int n, int n2) {
        ++this.methodDepth;
    }

    private void enterInterface(ISourceElementRequestor.TypeInfo typeInfo) {
        if (typeInfo.superinterfaces != null) {
            int n = 0;
            int n2 = typeInfo.superinterfaces.length;
            while (n < n2) {
                typeInfo.superinterfaces[n] = this.getSimpleName(typeInfo.superinterfaces[n]);
                ++n;
            }
        }
        char[][] cArray = this.methodDepth > 0 ? ONE_ZERO_CHAR : this.enclosingTypeNames();
        Object object = null;
        if (typeInfo.typeParameters != null) {
            int n = typeInfo.typeParameters.length;
            object = new char[n][];
            int n3 = 0;
            while (n3 < n) {
                ISourceElementRequestor.TypeParameterInfo typeParameterInfo = typeInfo.typeParameters[n3];
                object[n3] = Signature.createTypeParameterSignature(typeParameterInfo.name, typeParameterInfo.bounds);
                ++n3;
            }
        }
        this.indexer.addInterfaceDeclaration(typeInfo.modifiers, this.packageName, typeInfo.name, cArray, typeInfo.superinterfaces, (char[][])object, typeInfo.secondary);
        this.pushTypeName(typeInfo.name);
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        boolean bl = this.depth == 0;
        this.indexer.addMethodDeclaration(methodInfo.name, methodInfo.parameterTypes, methodInfo.returnType, methodInfo.exceptionTypes, bl);
        ++this.methodDepth;
    }

    public void enterType(ISourceElementRequestor.TypeInfo typeInfo) {
        switch (TypeDeclaration.kind(typeInfo.modifiers)) {
            case 1: {
                this.enterClass(typeInfo);
                break;
            }
            case 4: {
                this.enterAnnotationType(typeInfo);
                break;
            }
            case 2: {
                this.enterInterface(typeInfo);
                break;
            }
            case 3: {
                this.enterEnum(typeInfo);
            }
        }
    }

    public void exitCompilationUnit(int n) {
    }

    public void exitConstructor(int n) {
        --this.methodDepth;
    }

    public void exitField(int n, int n2, int n3) {
        --this.methodDepth;
    }

    public void exitInitializer(int n) {
        --this.methodDepth;
    }

    public void exitMethod(int n, int n2, int n3) {
        --this.methodDepth;
    }

    public void exitType(int n) {
        this.popTypeName();
    }

    /*
     * Enabled aggressive block sorting
     */
    private char[] getSimpleName(char[] cArray) {
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        int n4 = cArray.length;
        int n5 = n4 - 1;
        block5: while (n5 >= 0) {
            switch (cArray[n5]) {
                case '.': {
                    if (n3 != 0) break;
                    n = n5;
                    break block5;
                }
                case '<': {
                    if (--n3 != 0) break;
                    n2 = n5;
                    break;
                }
                case '>': {
                    ++n3;
                }
            }
            --n5;
        }
        if (n2 >= 0) {
            return CharOperation.subarray(cArray, n + 1, n2);
        }
        if (n < 0) {
            return cArray;
        }
        return CharOperation.subarray(cArray, n + 1, n4);
    }

    public void popTypeName() {
        if (this.depth > 0) {
            this.enclosingTypeNames[--this.depth] = null;
        } else if (JobManager.VERBOSE) {
            try {
                this.enclosingTypeNames[-1] = null;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                arrayIndexOutOfBoundsException.printStackTrace();
            }
        }
    }

    public void pushTypeName(char[] cArray) {
        if (this.depth == this.enclosingTypeNames.length) {
            char[][] cArrayArray = new char[this.depth * 2][];
            this.enclosingTypeNames = cArrayArray;
            System.arraycopy(this.enclosingTypeNames, 0, cArrayArray, 0, this.depth);
        }
        this.enclosingTypeNames[this.depth++] = cArray;
    }
}

