/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.wst.jsdt.internal.core.search.matching.PatternLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.QualifiedTypeDeclarationPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.wst.jsdt.internal.infer.InferredType;

public class TypeDeclarationLocator
extends PatternLocator {
    protected TypeDeclarationPattern pattern;

    public TypeDeclarationLocator(TypeDeclarationPattern typeDeclarationPattern) {
        super(typeDeclarationPattern);
        this.pattern = typeDeclarationPattern;
    }

    public int match(TypeDeclaration typeDeclaration, MatchingNodeSet matchingNodeSet) {
        if (this.pattern.simpleName == null || this.matchesName(this.pattern.simpleName, typeDeclaration.name)) {
            return matchingNodeSet.addMatch(typeDeclaration, this.pattern.mustResolve ? 2 : 3);
        }
        return 0;
    }

    public int match(InferredType inferredType, MatchingNodeSet matchingNodeSet) {
        if (this.pattern.simpleName == null || this.matchesName(this.pattern.simpleName, inferredType.getName())) {
            return matchingNodeSet.addMatch(inferredType, this.pattern.mustResolve ? 2 : 3);
        }
        return 0;
    }

    public int resolveLevel(ASTNode aSTNode) {
        if (!(aSTNode instanceof TypeDeclaration)) {
            return 0;
        }
        return this.resolveLevel(((TypeDeclaration)aSTNode).binding);
    }

    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof TypeBinding)) {
            return 0;
        }
        TypeBinding typeBinding = (TypeBinding)binding;
        switch (this.pattern.typeSuffix) {
            case 'C': {
                if (typeBinding.isClass()) break;
                return 0;
            }
            case '\n': {
                if (typeBinding.isClass() || typeBinding.isInterface() && !typeBinding.isAnnotationType()) break;
                return 0;
            }
            case '\t': {
                if (typeBinding.isClass() || typeBinding.isEnum()) break;
                return 0;
            }
            case 'I': {
                if (typeBinding.isInterface() && !typeBinding.isAnnotationType()) break;
                return 0;
            }
            case '\u000b': {
                if (typeBinding.isInterface() || typeBinding.isAnnotationType()) break;
                return 0;
            }
            case 'E': {
                if (typeBinding.isEnum()) break;
                return 0;
            }
            case 'A': {
                if (typeBinding.isAnnotationType()) break;
                return 0;
            }
        }
        if (this.pattern instanceof QualifiedTypeDeclarationPattern) {
            QualifiedTypeDeclarationPattern qualifiedTypeDeclarationPattern = (QualifiedTypeDeclarationPattern)this.pattern;
            return this.resolveLevelForType(qualifiedTypeDeclarationPattern.simpleName, qualifiedTypeDeclarationPattern.qualification, typeBinding);
        }
        char[] cArray = this.pattern.enclosingTypeNames == null ? null : CharOperation.concatWith(this.pattern.enclosingTypeNames, '.');
        return this.resolveLevelForType(this.pattern.simpleName, this.pattern.pkg, cArray, typeBinding);
    }

    protected int resolveLevelForType(char[] cArray, char[] cArray2, char[] cArray3, TypeBinding typeBinding) {
        if (cArray3 == null) {
            return this.resolveLevelForType(cArray, cArray2, typeBinding);
        }
        if (cArray2 == null) {
            return this.resolveLevelForType(cArray, cArray3, typeBinding);
        }
        if (typeBinding instanceof ProblemReferenceBinding) {
            return 0;
        }
        char[] cArray4 = CharOperation.concat(cArray2, cArray3, '.');
        if (CharOperation.equals(this.pattern.pkg, CharOperation.concatWith(typeBinding.getPackage().compoundName, '.'))) {
            return this.resolveLevelForType(cArray, cArray4, typeBinding);
        }
        return 0;
    }

    public String toString() {
        return "Locator for " + this.pattern.toString();
    }
}

