/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeParameter;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.wst.jsdt.internal.core.search.matching.PatternLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeParameterPattern;

public class TypeParameterLocator
extends PatternLocator {
    protected TypeParameterPattern pattern;

    public TypeParameterLocator(TypeParameterPattern typeParameterPattern) {
        super(typeParameterPattern);
        this.pattern = typeParameterPattern;
    }

    public int match(TypeReference typeReference, MatchingNodeSet matchingNodeSet) {
        if (this.pattern.findReferences && typeReference instanceof SingleTypeReference && this.matchesName(this.pattern.name, ((SingleTypeReference)typeReference).token)) {
            int n = this.pattern.mustResolve ? 2 : 3;
            return matchingNodeSet.addMatch(typeReference, n);
        }
        return 0;
    }

    public int match(TypeParameter typeParameter, MatchingNodeSet matchingNodeSet) {
        if (this.pattern.findDeclarations && this.matchesName(this.pattern.name, typeParameter.name)) {
            int n = this.pattern.mustResolve ? 2 : 3;
            return matchingNodeSet.addMatch(typeParameter, n);
        }
        return 0;
    }

    protected int matchContainer() {
        if (this.pattern.findReferences) {
            return 15;
        }
        return 6;
    }

    protected int matchTypeParameter(TypeVariableBinding typeVariableBinding, boolean bl) {
        if (typeVariableBinding == null || typeVariableBinding.declaringElement == null) {
            return 1;
        }
        if (typeVariableBinding.declaringElement instanceof ReferenceBinding) {
            ReferenceBinding referenceBinding = (ReferenceBinding)typeVariableBinding.declaringElement;
            if (this.matchesName(referenceBinding.sourceName, this.pattern.declaringMemberName)) {
                return 3;
            }
        } else if (typeVariableBinding.declaringElement instanceof MethodBinding) {
            MethodBinding methodBinding = (MethodBinding)typeVariableBinding.declaringElement;
            if (this.matchesName(methodBinding.declaringClass.sourceName, this.pattern.methodDeclaringClassName) && (methodBinding.isConstructor() || this.matchesName(methodBinding.selector, this.pattern.declaringMemberName))) {
                int n;
                int n2 = n = this.pattern.methodArgumentTypes == null ? 0 : this.pattern.methodArgumentTypes.length;
                if (methodBinding.parameters == null) {
                    if (n == 0) {
                        return 3;
                    }
                } else if (methodBinding.parameters.length == n) {
                    int n3 = 0;
                    while (n3 < n) {
                        if (!this.matchesName(methodBinding.parameters[n3].shortReadableName(), this.pattern.methodArgumentTypes[n3])) {
                            return 0;
                        }
                        ++n3;
                    }
                    return 3;
                }
            }
        }
        return 0;
    }

    protected int referenceType() {
        return 15;
    }

    public int resolveLevel(ASTNode aSTNode) {
        if (this.pattern.findReferences && aSTNode instanceof SingleTypeReference) {
            return this.resolveLevel(((SingleTypeReference)aSTNode).resolvedType);
        }
        if (this.pattern.findDeclarations && aSTNode instanceof TypeParameter) {
            return this.matchTypeParameter(((TypeParameter)aSTNode).binding, true);
        }
        return 0;
    }

    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof TypeVariableBinding)) {
            return 0;
        }
        return this.matchTypeParameter((TypeVariableBinding)binding, true);
    }

    public String toString() {
        return "Locator for " + this.pattern.toString();
    }
}

