/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Initializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.core.SourceRefElement;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.eclipse.wst.jsdt.internal.infer.InferredType;

public class ASTNodeFinder {
    private CompilationUnitDeclaration unit;

    public ASTNodeFinder(CompilationUnitDeclaration compilationUnitDeclaration) {
        this.unit = compilationUnitDeclaration;
    }

    public FieldDeclaration findField(IField iField) {
        TypeDeclaration typeDeclaration = this.findType((IType)iField.getParent());
        if (typeDeclaration == null) {
            return null;
        }
        FieldDeclaration[] fieldDeclarationArray = typeDeclaration.fields;
        if (fieldDeclarationArray != null) {
            char[] cArray = iField.getElementName().toCharArray();
            int n = 0;
            int n2 = fieldDeclarationArray.length;
            while (n < n2) {
                FieldDeclaration fieldDeclaration = fieldDeclarationArray[n];
                if (CharOperation.equals(cArray, fieldDeclaration.name)) {
                    return fieldDeclaration;
                }
                ++n;
            }
        }
        return null;
    }

    public Initializer findInitializer(IInitializer iInitializer) {
        TypeDeclaration typeDeclaration = this.findType((IType)iInitializer.getParent());
        if (typeDeclaration == null) {
            return null;
        }
        FieldDeclaration[] fieldDeclarationArray = typeDeclaration.fields;
        if (fieldDeclarationArray != null) {
            int n = ((SourceRefElement)((Object)iInitializer)).occurrenceCount;
            int n2 = 0;
            int n3 = fieldDeclarationArray.length;
            while (n2 < n3) {
                FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
                if (fieldDeclaration instanceof Initializer && --n == 0) {
                    return (Initializer)fieldDeclaration;
                }
                ++n2;
            }
        }
        return null;
    }

    public AbstractMethodDeclaration findMethod(IMethod iMethod) {
        TypeDeclaration typeDeclaration = this.findType((IType)iMethod.getParent());
        if (typeDeclaration == null) {
            return null;
        }
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = typeDeclaration.methods;
        if (abstractMethodDeclarationArray != null) {
            char[] cArray = iMethod.getElementName().toCharArray();
            String[] stringArray = iMethod.getParameterTypes();
            int n = stringArray.length;
            int n2 = 0;
            int n3 = abstractMethodDeclarationArray.length;
            while (n2 < n3) {
                block7: {
                    AbstractMethodDeclaration abstractMethodDeclaration = abstractMethodDeclarationArray[n2];
                    if (CharOperation.equals(cArray, abstractMethodDeclaration.selector)) {
                        int n4;
                        Argument[] argumentArray = abstractMethodDeclaration.arguments;
                        int n5 = n4 = argumentArray == null ? 0 : argumentArray.length;
                        if (n4 == n) {
                            int n6 = 0;
                            while (n6 < n) {
                                TypeReference typeReference = argumentArray[n6].type;
                                String string = Util.typeSignature(typeReference);
                                if (string.equals(stringArray[n6])) {
                                    ++n6;
                                    continue;
                                }
                                break block7;
                            }
                            return abstractMethodDeclaration;
                        }
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public TypeDeclaration findType(IType iType) {
        return null;
    }

    public InferredType findInferredType(IType iType) {
        char[] cArray = iType.getElementName().toCharArray();
        int n = ((SourceType)iType).occurrenceCount;
        boolean bl = cArray.length == 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.unit.numberInferredTypes) {
            InferredType inferredType = this.unit.inferredTypes[n3];
            if (inferredType.isDefinition && (inferredType.isAnonymous ? bl && ++n2 == n : !bl && CharOperation.equals(inferredType.getName(), cArray))) {
                return inferredType;
            }
            ++n3;
        }
        return null;
    }
}

