/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.internal.compiler.util.Util;

public class CharArrayBuffer {
    protected char[][] fBuffer;
    public static final int DEFAULT_BUFFER_SIZE = 10;
    protected int fEnd;
    protected int fSize;
    protected int[][] fRanges;

    public CharArrayBuffer() {
        this(null, 10);
    }

    public CharArrayBuffer(char[] cArray) {
        this(cArray, 10);
    }

    public CharArrayBuffer(char[] cArray, int n) {
        this.fSize = n > 0 ? n : 10;
        this.fBuffer = new char[this.fSize][];
        this.fRanges = new int[this.fSize][];
        this.fEnd = 0;
        if (cArray != null) {
            this.append(cArray, 0, cArray.length);
        }
    }

    public CharArrayBuffer(int n) {
        this(null, n);
    }

    public CharArrayBuffer append(char[] cArray) {
        if (cArray != null) {
            this.append(cArray, 0, cArray.length);
        }
        return this;
    }

    public CharArrayBuffer append(char[] cArray, int n, int n2) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (cArray != null) {
            int n3 = cArray.length;
            if (n > n3) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (n2 + n > n3) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (n2 > 0) {
                if (this.fEnd == this.fSize) {
                    int n4 = this.fSize * 2;
                    char[][] cArrayArray = new char[n4][];
                    this.fBuffer = cArrayArray;
                    System.arraycopy(this.fBuffer, 0, cArrayArray, 0, this.fSize);
                    int[][] nArrayArray = new int[n4][];
                    this.fRanges = nArrayArray;
                    System.arraycopy(this.fRanges, 0, nArrayArray, 0, this.fSize);
                    this.fSize *= 2;
                }
                this.fBuffer[this.fEnd] = cArray;
                this.fRanges[this.fEnd] = new int[]{n, n2};
                ++this.fEnd;
            }
        }
        return this;
    }

    public CharArrayBuffer append(char c) {
        this.append(new char[]{c}, 0, 1);
        return this;
    }

    public CharArrayBuffer append(String string) {
        if (string != null) {
            this.append(string.toCharArray(), 0, string.length());
        }
        return this;
    }

    public char[] getContents() {
        if (this.fEnd == 0) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.fEnd) {
            n += this.fRanges[n2][1];
            ++n2;
        }
        if (n > 0) {
            char[] cArray = new char[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.fEnd) {
                int[] nArray = this.fRanges[n4];
                int n5 = nArray[1];
                System.arraycopy(this.fBuffer[n4], nArray[0], cArray, n3, n5);
                n3 += n5;
                ++n4;
            }
            return cArray;
        }
        return null;
    }

    public String toString() {
        char[] cArray = this.getContents();
        return cArray != null ? new String(cArray) : Util.EMPTY_STRING;
    }
}

