/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.core.util.IConstantPool;
import org.eclipse.wst.jsdt.core.util.IConstantPoolEntry;
import org.eclipse.wst.jsdt.internal.core.util.ClassFileStruct;
import org.eclipse.wst.jsdt.internal.core.util.ConstantPoolEntry;

public class ConstantPool
extends ClassFileStruct
implements IConstantPool {
    private int constantPoolCount;
    private int[] constantPoolOffset;
    private byte[] classFileBytes;

    ConstantPool(byte[] byArray, int[] nArray) {
        this.constantPoolCount = nArray.length;
        this.constantPoolOffset = nArray;
        this.classFileBytes = byArray;
    }

    public IConstantPoolEntry decodeEntry(int n) {
        ConstantPoolEntry constantPoolEntry = new ConstantPoolEntry();
        constantPoolEntry.reset();
        int n2 = this.getEntryKind(n);
        constantPoolEntry.setKind(n2);
        switch (n2) {
            case 7: {
                constantPoolEntry.setClassInfoNameIndex(this.u2At(this.classFileBytes, 1, this.constantPoolOffset[n]));
                constantPoolEntry.setClassInfoName(this.getUtf8ValueAt(constantPoolEntry.getClassInfoNameIndex()));
                break;
            }
            case 6: {
                constantPoolEntry.setDoubleValue(this.doubleAt(this.classFileBytes, 1, this.constantPoolOffset[n]));
                break;
            }
            case 9: {
                constantPoolEntry.setClassIndex(this.u2At(this.classFileBytes, 1, this.constantPoolOffset[n]));
                int n3 = this.u2At(this.classFileBytes, 1, this.constantPoolOffset[constantPoolEntry.getClassIndex()]);
                constantPoolEntry.setClassName(this.getUtf8ValueAt(n3));
                constantPoolEntry.setNameAndTypeIndex(this.u2At(this.classFileBytes, 3, this.constantPoolOffset[n]));
                int n4 = this.u2At(this.classFileBytes, 1, this.constantPoolOffset[constantPoolEntry.getNameAndTypeIndex()]);
                int n5 = this.u2At(this.classFileBytes, 3, this.constantPoolOffset[constantPoolEntry.getNameAndTypeIndex()]);
                constantPoolEntry.setFieldName(this.getUtf8ValueAt(n4));
                constantPoolEntry.setFieldDescriptor(this.getUtf8ValueAt(n5));
                break;
            }
            case 10: 
            case 11: {
                constantPoolEntry.setClassIndex(this.u2At(this.classFileBytes, 1, this.constantPoolOffset[n]));
                int n6 = this.u2At(this.classFileBytes, 1, this.constantPoolOffset[constantPoolEntry.getClassIndex()]);
                constantPoolEntry.setClassName(this.getUtf8ValueAt(n6));
                constantPoolEntry.setNameAndTypeIndex(this.u2At(this.classFileBytes, 3, this.constantPoolOffset[n]));
                int n7 = this.u2At(this.classFileBytes, 1, this.constantPoolOffset[constantPoolEntry.getNameAndTypeIndex()]);
                int n8 = this.u2At(this.classFileBytes, 3, this.constantPoolOffset[constantPoolEntry.getNameAndTypeIndex()]);
                constantPoolEntry.setMethodName(this.getUtf8ValueAt(n7));
                constantPoolEntry.setMethodDescriptor(this.getUtf8ValueAt(n8));
                break;
            }
            case 4: {
                constantPoolEntry.setFloatValue(this.floatAt(this.classFileBytes, 1, this.constantPoolOffset[n]));
                break;
            }
            case 3: {
                constantPoolEntry.setIntegerValue(this.i4At(this.classFileBytes, 1, this.constantPoolOffset[n]));
                break;
            }
            case 5: {
                constantPoolEntry.setLongValue(this.i8At(this.classFileBytes, 1, this.constantPoolOffset[n]));
                break;
            }
            case 12: {
                constantPoolEntry.setNameAndTypeNameIndex(this.u2At(this.classFileBytes, 1, this.constantPoolOffset[n]));
                constantPoolEntry.setNameAndTypeDescriptorIndex(this.u2At(this.classFileBytes, 3, this.constantPoolOffset[n]));
                break;
            }
            case 8: {
                constantPoolEntry.setStringIndex(this.u2At(this.classFileBytes, 1, this.constantPoolOffset[n]));
                constantPoolEntry.setStringValue(this.getUtf8ValueAt(constantPoolEntry.getStringIndex()));
                break;
            }
            case 1: {
                constantPoolEntry.setUtf8Length(this.u2At(this.classFileBytes, 1, this.constantPoolOffset[n]));
                constantPoolEntry.setUtf8Value(this.getUtf8ValueAt(n));
            }
        }
        return constantPoolEntry;
    }

    public int getConstantPoolCount() {
        return this.constantPoolCount;
    }

    public int getEntryKind(int n) {
        return this.u1At(this.classFileBytes, 0, this.constantPoolOffset[n]);
    }

    private char[] getUtf8ValueAt(int n) {
        int n2 = this.constantPoolOffset[n];
        return this.utf8At(this.classFileBytes, 0, n2 + 3, this.u2At(this.classFileBytes, 0, n2 + 1));
    }
}

