/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.core.util.ClassFormatException;
import org.eclipse.wst.jsdt.core.util.IConstantPool;
import org.eclipse.wst.jsdt.core.util.IConstantPoolEntry;
import org.eclipse.wst.jsdt.core.util.IExceptionTableEntry;
import org.eclipse.wst.jsdt.internal.core.util.ClassFileStruct;

public class ExceptionTableEntry
extends ClassFileStruct
implements IExceptionTableEntry {
    private int startPC;
    private int endPC;
    private int handlerPC;
    private int catchTypeIndex;
    private char[] catchType;

    ExceptionTableEntry(byte[] byArray, IConstantPool iConstantPool, int n) throws ClassFormatException {
        this.startPC = this.u2At(byArray, 0, n);
        this.endPC = this.u2At(byArray, 2, n);
        this.handlerPC = this.u2At(byArray, 4, n);
        this.catchTypeIndex = this.u2At(byArray, 6, n);
        if (this.catchTypeIndex != 0) {
            IConstantPoolEntry iConstantPoolEntry = iConstantPool.decodeEntry(this.catchTypeIndex);
            if (iConstantPoolEntry.getKind() != 7) {
                throw new ClassFormatException(3);
            }
            this.catchType = iConstantPoolEntry.getClassInfoName();
        }
    }

    public int getStartPC() {
        return this.startPC;
    }

    public int getEndPC() {
        return this.endPC;
    }

    public int getHandlerPC() {
        return this.handlerPC;
    }

    public int getCatchTypeIndex() {
        return this.catchTypeIndex;
    }

    public char[] getCatchType() {
        return this.catchType;
    }
}

