/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import java.util.ArrayList;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.wst.jsdt.internal.core.util.BindingKeyParser;

public class KeyToSignature
extends BindingKeyParser {
    public static final int SIGNATURE = 0;
    public static final int TYPE_ARGUMENTS = 1;
    public static final int DECLARING_TYPE = 2;
    public static final int THROWN_EXCEPTIONS = 3;
    public StringBuffer signature = new StringBuffer();
    private int kind;
    private ArrayList arguments = new ArrayList();
    private ArrayList typeParameters = new ArrayList();
    private ArrayList thrownExceptions = new ArrayList();
    private int mainTypeStart = -1;
    private int mainTypeEnd;
    private int typeSigStart = -1;

    public KeyToSignature(BindingKeyParser bindingKeyParser) {
        super(bindingKeyParser);
        this.kind = ((KeyToSignature)bindingKeyParser).kind;
    }

    public KeyToSignature(String string, int n) {
        super(string);
        this.kind = n;
    }

    public void consumeArrayDimension(char[] cArray) {
        this.signature.append(cArray);
    }

    public void consumeBaseType(char[] cArray) {
        this.typeSigStart = this.signature.length();
        this.signature.append(cArray);
    }

    public void consumeCapture(int n) {
        this.signature = ((KeyToSignature)this.arguments.get((int)0)).signature;
    }

    public void consumeLocalType(char[] cArray) {
        this.signature = new StringBuffer();
        cArray = CharOperation.subarray(cArray, 0, cArray.length - 1);
        CharOperation.replace(cArray, '/', '.');
        this.signature.append(cArray);
    }

    public void consumeMethod(char[] cArray, char[] cArray2) {
        this.arguments = new ArrayList();
        CharOperation.replace(cArray2, '/', '.');
        switch (this.kind) {
            case 0: {
                this.signature = new StringBuffer();
                this.signature.append(cArray2);
                break;
            }
            case 3: {
                if (CharOperation.indexOf('^', cArray2) <= 0) break;
                char[][] cArray3 = Signature.getThrownExceptionTypes(cArray2);
                int n = cArray3.length;
                int n2 = 0;
                while (n2 < n) {
                    this.thrownExceptions.add(new String(cArray3[n2]));
                    ++n2;
                }
                break;
            }
        }
    }

    public void consumeMemberType(char[] cArray) {
        this.signature.append('$');
        this.signature.append(cArray);
    }

    public void consumePackage(char[] cArray) {
        this.signature.append(cArray);
    }

    public void consumeParameterizedGenericMethod() {
        int n = this.arguments.size();
        if (n > 0) {
            int n2 = this.signature.length();
            char[] cArray = new char[n2];
            this.signature.getChars(0, n2, cArray, 0);
            char[][] cArray2 = Signature.getTypeParameters(cArray);
            if (cArray2.length != n) {
                return;
            }
            this.signature = new StringBuffer();
            int n3 = 0;
            while (n3 < n) {
                cArray2[n3] = CharOperation.concat('T', Signature.getTypeVariable(cArray2[n3]), ';');
                ++n3;
            }
            n3 = CharOperation.indexOf('(', cArray);
            char[] cArray3 = CharOperation.subarray(cArray, 0, n3);
            this.signature.append(cArray3);
            this.signature.append('(');
            char[][] cArray4 = Signature.getParameterTypes(cArray);
            int n4 = 0;
            int n5 = cArray4.length;
            while (n4 < n5) {
                this.substitute(cArray4[n4], cArray2, n);
                ++n4;
            }
            this.signature.append(')');
            char[] cArray5 = Signature.getReturnType(cArray);
            this.substitute(cArray5, cArray2, n);
            char[][] cArray6 = Signature.getThrownExceptionTypes(cArray);
            int n6 = 0;
            int n7 = cArray6.length;
            while (n6 < n7) {
                this.signature.append('^');
                this.substitute(cArray6[n6], cArray2, n);
                ++n6;
            }
        }
    }

    private void substitute(char[] cArray, char[][] cArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            if (CharOperation.equals(cArray, cArray2[n2])) {
                String string = ((KeyToSignature)this.arguments.get((int)n2)).signature.toString();
                this.signature.append(string);
                return;
            }
            ++n2;
        }
        n2 = CharOperation.indexOf('<', cArray);
        if (n2 > -1) {
            this.signature.append(CharOperation.subarray(cArray, 0, n2));
            char[][] cArray3 = Signature.getTypeArguments(cArray);
            this.signature.append('<');
            int n3 = 0;
            int n4 = cArray3.length;
            while (n3 < n4) {
                this.substitute(cArray3[n3], cArray2, n);
                ++n3;
            }
            this.signature.append('>');
            this.signature.append(';');
        } else {
            int n5 = 0;
            int n6 = cArray.length;
            block5: while (n5 < n6) {
                char c = cArray[n5];
                switch (c) {
                    case '!': 
                    case '+': 
                    case '-': 
                    case '[': {
                        this.signature.append(c);
                        ++n5;
                        break;
                    }
                    default: {
                        break block5;
                    }
                }
            }
            if (n5 > 0) {
                this.substitute(CharOperation.subarray(cArray, n5, n6), cArray2, n);
            } else {
                this.signature.append(cArray);
            }
        }
    }

    public void consumeParameterizedType(char[] cArray, boolean bl) {
        if (cArray != null) {
            this.signature.append('.');
            this.signature.append(cArray);
        }
        if (!bl) {
            this.signature.append('<');
            int n = this.arguments.size();
            int n2 = 0;
            while (n2 < n) {
                this.signature.append(((KeyToSignature)this.arguments.get((int)n2)).signature);
                ++n2;
            }
            this.signature.append('>');
            if (this.kind != 1) {
                this.arguments = new ArrayList();
            }
        }
    }

    public void consumeParser(BindingKeyParser bindingKeyParser) {
        this.arguments.add(bindingKeyParser);
    }

    public void consumeField(char[] cArray) {
        if (this.kind == 0) {
            this.signature = ((KeyToSignature)this.arguments.get((int)0)).signature;
        }
    }

    public void consumeException() {
        int n = this.arguments.size();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                this.thrownExceptions.add(((KeyToSignature)this.arguments.get((int)n2)).signature.toString());
                ++n2;
            }
            this.arguments = new ArrayList();
        }
    }

    public void consumeFullyQualifiedName(char[] cArray) {
        this.typeSigStart = this.signature.length();
        this.signature.append('L');
        this.signature.append(CharOperation.replaceOnCopy(cArray, '/', '.'));
    }

    public void consumeSecondaryType(char[] cArray) {
        this.signature.append('~');
        this.mainTypeStart = this.signature.lastIndexOf(".") + 1;
        if (this.mainTypeStart == 0) {
            this.mainTypeStart = 1;
        }
        this.mainTypeEnd = this.signature.length();
        this.signature.append(cArray);
    }

    public void consumeType() {
        int n;
        if (this.mainTypeStart != -1) {
            this.signature.replace(this.mainTypeStart, this.mainTypeEnd, "");
        }
        if ((n = this.typeParameters.size()) > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('<');
            int n2 = 0;
            while (n2 < n) {
                char[] cArray = Signature.createTypeParameterSignature((char[])this.typeParameters.get(n2), new char[][]{ConstantPool.ObjectSignature});
                stringBuffer.append(cArray);
                ++n2;
            }
            stringBuffer.append('>');
            this.signature.insert(this.typeSigStart, stringBuffer);
            this.typeParameters = new ArrayList();
        }
        this.signature.append(';');
    }

    public void consumeTypeParameter(char[] cArray) {
        this.typeParameters.add(cArray);
    }

    public void consumeTypeVariable(char[] cArray, char[] cArray2) {
        this.signature = new StringBuffer();
        this.signature.append('T');
        this.signature.append(cArray2);
        this.signature.append(';');
    }

    public void consumeTypeWithCapture() {
        KeyToSignature keyToSignature = (KeyToSignature)this.arguments.get(0);
        this.signature = keyToSignature.signature;
        this.arguments = keyToSignature.arguments;
        this.thrownExceptions = keyToSignature.thrownExceptions;
    }

    public void consumeWildCard(int n) {
        this.signature = new StringBuffer();
        switch (n) {
            case 0: {
                this.signature.append('*');
                break;
            }
            case 1: {
                this.signature.append('+');
                this.signature.append(((KeyToSignature)this.arguments.get((int)0)).signature);
                break;
            }
            case 2: {
                this.signature.append('-');
                this.signature.append(((KeyToSignature)this.arguments.get((int)0)).signature);
                break;
            }
            default: {
                return;
            }
        }
    }

    public String[] getThrownExceptions() {
        int n = this.thrownExceptions.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this.thrownExceptions.get(n2);
            ++n2;
        }
        return stringArray;
    }

    public String[] getTypeArguments() {
        int n = this.arguments.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = ((KeyToSignature)this.arguments.get((int)n2)).signature.toString();
            ++n2;
        }
        return stringArray;
    }

    public BindingKeyParser newParser() {
        return new KeyToSignature(this);
    }

    public String toString() {
        return this.signature.toString();
    }
}

