/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.eval;

import java.util.Map;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ClassFile;
import org.eclipse.wst.jsdt.internal.compiler.Compiler;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.ICompilerRequestor;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.eval.CodeSnippetCompiler;
import org.eclipse.wst.jsdt.internal.eval.CodeSnippetEnvironment;
import org.eclipse.wst.jsdt.internal.eval.CodeSnippetParser;
import org.eclipse.wst.jsdt.internal.eval.CodeSnippetToCuMapper;
import org.eclipse.wst.jsdt.internal.eval.EvaluationConstants;
import org.eclipse.wst.jsdt.internal.eval.EvaluationContext;
import org.eclipse.wst.jsdt.internal.eval.EvaluationResult;
import org.eclipse.wst.jsdt.internal.eval.Evaluator;
import org.eclipse.wst.jsdt.internal.eval.IRequestor;
import org.eclipse.wst.jsdt.internal.eval.VariablesInfo;

public class CodeSnippetEvaluator
extends Evaluator
implements EvaluationConstants {
    static final boolean DEVELOPMENT_MODE = false;
    char[] codeSnippet;
    CodeSnippetToCuMapper mapper;

    CodeSnippetEvaluator(char[] cArray, EvaluationContext evaluationContext, INameEnvironment iNameEnvironment, Map map, IRequestor iRequestor, IProblemFactory iProblemFactory) {
        super(evaluationContext, iNameEnvironment, map, iRequestor, iProblemFactory);
        this.codeSnippet = cArray;
    }

    protected void addEvaluationResultForCompilationProblem(Map map, CategorizedProblem categorizedProblem, char[] cArray) {
        CodeSnippetToCuMapper codeSnippetToCuMapper = this.getMapper();
        int n = categorizedProblem.getSourceLineNumber();
        int n2 = codeSnippetToCuMapper.getEvaluationType(n);
        char[] cArray2 = null;
        switch (n2) {
            case 4: {
                cArray2 = this.context.packageName;
                categorizedProblem.setSourceLineNumber(1);
                categorizedProblem.setSourceStart(0);
                categorizedProblem.setSourceEnd(cArray2.length - 1);
                break;
            }
            case 3: {
                cArray2 = codeSnippetToCuMapper.getImport(n);
                categorizedProblem.setSourceLineNumber(1);
                categorizedProblem.setSourceStart(0);
                categorizedProblem.setSourceEnd(cArray2.length - 1);
                break;
            }
            case 2: {
                cArray2 = this.codeSnippet;
                categorizedProblem.setSourceLineNumber(n - this.mapper.lineNumberOffset);
                categorizedProblem.setSourceStart(categorizedProblem.getSourceStart() - this.mapper.startPosOffset);
                categorizedProblem.setSourceEnd(categorizedProblem.getSourceEnd() - this.mapper.startPosOffset);
                break;
            }
            case 5: {
                cArray2 = cArray;
            }
        }
        EvaluationResult evaluationResult = (EvaluationResult)map.get(cArray2);
        if (evaluationResult == null) {
            map.put(cArray2, new EvaluationResult(cArray2, n2, new CategorizedProblem[]{categorizedProblem}));
        } else {
            evaluationResult.addProblem(categorizedProblem);
        }
    }

    protected char[] getClassName() {
        return CharOperation.concat(CODE_SNIPPET_CLASS_NAME_PREFIX, Integer.toString(EvaluationContext.CODE_SNIPPET_COUNTER + 1).toCharArray());
    }

    Compiler getCompiler(ICompilerRequestor iCompilerRequestor) {
        CodeSnippetCompiler codeSnippetCompiler = null;
        CompilerOptions compilerOptions = new CompilerOptions(this.options);
        compilerOptions.performMethodsFullRecovery = true;
        compilerOptions.performStatementsRecovery = true;
        codeSnippetCompiler = new CodeSnippetCompiler(this.environment, DefaultErrorHandlingPolicies.exitAfterAllProblems(), compilerOptions, iCompilerRequestor, this.problemFactory, this.context, this.getMapper().startPosOffset, this.getMapper().startPosOffset + this.codeSnippet.length - 1);
        ((CodeSnippetParser)codeSnippetCompiler.parser).lineSeparatorLength = this.context.lineSeparator.length();
        IBinaryType iBinaryType = this.context.getRootCodeSnippetBinary();
        VariablesInfo variablesInfo = this.context.installedVars;
        if (variablesInfo != null) {
            ClassFile[] classFileArray = variablesInfo.classFiles;
            int n = 0;
            while (n < classFileArray.length) {
                try {
                    new ClassFileReader(classFileArray[n].getBytes(), null);
                }
                catch (ClassFormatException classFormatException) {
                    classFormatException.printStackTrace();
                }
                ++n;
            }
        }
        return codeSnippetCompiler;
    }

    private CodeSnippetToCuMapper getMapper() {
        if (this.mapper == null) {
            char[] cArray = null;
            VariablesInfo variablesInfo = this.context.installedVars;
            if (variablesInfo != null) {
                char[] cArray2 = variablesInfo.packageName;
                cArray = cArray2 != null && cArray2.length != 0 ? CharOperation.concat(cArray2, variablesInfo.className, '.') : variablesInfo.className;
            }
            this.mapper = new CodeSnippetToCuMapper(this.codeSnippet, this.context.packageName, this.context.imports, this.getClassName(), cArray, this.context.localVariableNames, this.context.localVariableTypeNames, this.context.localVariableModifiers, this.context.declaringTypeName, this.context.lineSeparator);
        }
        return this.mapper;
    }

    protected char[] getSource() {
        return this.getMapper().cuSource;
    }

    private INameEnvironment getWrapperEnvironment() {
        return new CodeSnippetEnvironment(this.environment, this.context);
    }
}

