/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.formatter;

import java.util.ArrayList;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.AND_AND_Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.CastExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.CharLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.wst.jsdt.internal.compiler.ast.CombinedBinaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.EqualExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.FloatLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.InstanceOfExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.IntLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.ListExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.LongLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.NullLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.OR_OR_Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.PostfixExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.PrefixExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.RegExLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.StringLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.StringLiteralConcatenation;
import org.eclipse.wst.jsdt.internal.compiler.ast.SuperReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ThisReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.UndefinedLiteral;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;

class BinaryExpressionFragmentBuilder
extends ASTVisitor {
    ArrayList fragmentsList = new ArrayList();
    ArrayList operatorsList = new ArrayList();
    private int realFragmentsSize = 0;

    BinaryExpressionFragmentBuilder() {
    }

    private final void addRealFragment(ASTNode aSTNode) {
        this.fragmentsList.add(aSTNode);
        ++this.realFragmentsSize;
    }

    private final void addSmallFragment(ASTNode aSTNode) {
        this.fragmentsList.add(aSTNode);
    }

    private boolean buildFragments(Expression expression) {
        if ((expression.bits & 0x1FE00000) >> 21 != 0) {
            this.addRealFragment(expression);
            return false;
        }
        return true;
    }

    public ASTNode[] fragments() {
        ASTNode[] aSTNodeArray = new ASTNode[this.fragmentsList.size()];
        this.fragmentsList.toArray(aSTNodeArray);
        return aSTNodeArray;
    }

    public int[] operators() {
        int n = this.operatorsList.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = (Integer)this.operatorsList.get(n2);
            ++n2;
        }
        return nArray;
    }

    public int realFragmentsSize() {
        return this.realFragmentsSize;
    }

    public boolean visit(AllocationExpression allocationExpression, BlockScope blockScope) {
        this.addRealFragment(allocationExpression);
        return false;
    }

    public boolean visit(AND_AND_Expression aND_AND_Expression, BlockScope blockScope) {
        if ((aND_AND_Expression.bits & 0x1FE00000) >> 21 != 0) {
            this.addRealFragment(aND_AND_Expression);
        } else {
            aND_AND_Expression.left.traverse((ASTVisitor)this, blockScope);
            this.operatorsList.add(new Integer(28));
            aND_AND_Expression.right.traverse((ASTVisitor)this, blockScope);
        }
        return false;
    }

    public boolean visit(ArrayAllocationExpression arrayAllocationExpression, BlockScope blockScope) {
        this.addRealFragment(arrayAllocationExpression);
        return false;
    }

    public boolean visit(ArrayInitializer arrayInitializer, BlockScope blockScope) {
        this.addRealFragment(arrayInitializer);
        return false;
    }

    public boolean visit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, BlockScope blockScope) {
        this.addRealFragment(arrayQualifiedTypeReference);
        return false;
    }

    public boolean visit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, ClassScope classScope) {
        this.addRealFragment(arrayQualifiedTypeReference);
        return false;
    }

    public boolean visit(ArrayReference arrayReference, BlockScope blockScope) {
        this.addRealFragment(arrayReference);
        return false;
    }

    public boolean visit(ArrayTypeReference arrayTypeReference, BlockScope blockScope) {
        this.addRealFragment(arrayTypeReference);
        return false;
    }

    public boolean visit(ArrayTypeReference arrayTypeReference, ClassScope classScope) {
        this.addRealFragment(arrayTypeReference);
        return false;
    }

    public boolean visit(Assignment assignment, BlockScope blockScope) {
        this.addRealFragment(assignment);
        return false;
    }

    public boolean visit(BinaryExpression binaryExpression, BlockScope blockScope) {
        int n;
        if (binaryExpression instanceof CombinedBinaryExpression) {
            CombinedBinaryExpression combinedBinaryExpression = (CombinedBinaryExpression)binaryExpression;
            if (combinedBinaryExpression.referencesTable != null) {
                return this.visit(combinedBinaryExpression, blockScope);
            }
        }
        if ((n = (binaryExpression.bits & 0x1FE00000) >> 21) > 0) {
            this.addRealFragment(binaryExpression);
        } else {
            switch ((binaryExpression.bits & 0xFC0) >> 6) {
                case 14: {
                    if (this.buildFragments(binaryExpression)) {
                        binaryExpression.left.traverse((ASTVisitor)this, blockScope);
                        this.operatorsList.add(new Integer(1));
                        binaryExpression.right.traverse((ASTVisitor)this, blockScope);
                    }
                    return false;
                }
                case 13: {
                    if (this.buildFragments(binaryExpression)) {
                        binaryExpression.left.traverse((ASTVisitor)this, blockScope);
                        this.operatorsList.add(new Integer(2));
                        binaryExpression.right.traverse((ASTVisitor)this, blockScope);
                    }
                    return false;
                }
                case 15: {
                    if (this.buildFragments(binaryExpression)) {
                        binaryExpression.left.traverse((ASTVisitor)this, blockScope);
                        this.operatorsList.add(new Integer(8));
                        binaryExpression.right.traverse((ASTVisitor)this, blockScope);
                    }
                    return false;
                }
                case 16: {
                    if (this.buildFragments(binaryExpression)) {
                        binaryExpression.left.traverse((ASTVisitor)this, blockScope);
                        this.operatorsList.add(new Integer(7));
                        binaryExpression.right.traverse((ASTVisitor)this, blockScope);
                    }
                    return false;
                }
                case 8: {
                    if (this.buildFragments(binaryExpression)) {
                        binaryExpression.left.traverse((ASTVisitor)this, blockScope);
                        this.operatorsList.add(new Integer(24));
                        binaryExpression.right.traverse((ASTVisitor)this, blockScope);
                    }
                    return false;
                }
                case 9: {
                    if (this.buildFragments(binaryExpression)) {
                        binaryExpression.left.traverse((ASTVisitor)this, blockScope);
                        this.operatorsList.add(new Integer(9));
                        binaryExpression.right.traverse((ASTVisitor)this, blockScope);
                    }
                    return false;
                }
                case 3: {
                    if (this.buildFragments(binaryExpression)) {
                        binaryExpression.left.traverse((ASTVisitor)this, blockScope);
                        this.operatorsList.add(new Integer(26));
                        binaryExpression.right.traverse((ASTVisitor)this, blockScope);
                    }
                    return false;
                }
                case 2: {
                    if (this.buildFragments(binaryExpression)) {
                        binaryExpression.left.traverse((ASTVisitor)this, blockScope);
                        this.operatorsList.add(new Integer(20));
                        binaryExpression.right.traverse((ASTVisitor)this, blockScope);
                    }
                    return false;
                }
            }
            this.addRealFragment(binaryExpression);
        }
        return false;
    }

    public boolean visit(CombinedBinaryExpression combinedBinaryExpression, BlockScope blockScope) {
        if (combinedBinaryExpression.referencesTable == null) {
            this.addRealFragment(combinedBinaryExpression.left);
            this.operatorsList.add(new Integer(1));
            this.addRealFragment(combinedBinaryExpression.right);
            return false;
        }
        BinaryExpression binaryExpression = combinedBinaryExpression.referencesTable[0];
        if (binaryExpression.left instanceof CombinedBinaryExpression) {
            this.visit((CombinedBinaryExpression)binaryExpression.left, blockScope);
        } else {
            this.addRealFragment(binaryExpression.left);
        }
        int n = 0;
        int n2 = combinedBinaryExpression.arity;
        while (n < n2) {
            this.operatorsList.add(new Integer(1));
            this.addRealFragment(combinedBinaryExpression.referencesTable[n].right);
            ++n;
        }
        this.operatorsList.add(new Integer(1));
        this.addRealFragment(combinedBinaryExpression.right);
        return false;
    }

    public boolean visit(CastExpression castExpression, BlockScope blockScope) {
        this.addRealFragment(castExpression);
        return false;
    }

    public boolean visit(CharLiteral charLiteral, BlockScope blockScope) {
        this.addSmallFragment(charLiteral);
        return false;
    }

    public boolean visit(ClassLiteralAccess classLiteralAccess, BlockScope blockScope) {
        this.addRealFragment(classLiteralAccess);
        return false;
    }

    public boolean visit(CompoundAssignment compoundAssignment, BlockScope blockScope) {
        this.addRealFragment(compoundAssignment);
        return false;
    }

    public boolean visit(ConditionalExpression conditionalExpression, BlockScope blockScope) {
        this.addRealFragment(conditionalExpression);
        return false;
    }

    public boolean visit(DoubleLiteral doubleLiteral, BlockScope blockScope) {
        this.addSmallFragment(doubleLiteral);
        return false;
    }

    public boolean visit(EqualExpression equalExpression, BlockScope blockScope) {
        this.addRealFragment(equalExpression);
        return false;
    }

    public boolean visit(ExtendedStringLiteral extendedStringLiteral, BlockScope blockScope) {
        this.addRealFragment(extendedStringLiteral);
        return false;
    }

    public boolean visit(FalseLiteral falseLiteral, BlockScope blockScope) {
        this.addSmallFragment(falseLiteral);
        return false;
    }

    public boolean visit(FieldReference fieldReference, BlockScope blockScope) {
        this.addRealFragment(fieldReference);
        return false;
    }

    public boolean visit(FloatLiteral floatLiteral, BlockScope blockScope) {
        this.addSmallFragment(floatLiteral);
        return false;
    }

    public boolean visit(ObjectLiteral objectLiteral, BlockScope blockScope) {
        this.addRealFragment(objectLiteral);
        return false;
    }

    public boolean visit(UndefinedLiteral undefinedLiteral, BlockScope blockScope) {
        this.addSmallFragment(undefinedLiteral);
        return false;
    }

    public boolean visit(FunctionExpression functionExpression, BlockScope blockScope) {
        this.addRealFragment(functionExpression);
        return false;
    }

    public boolean visit(InstanceOfExpression instanceOfExpression, BlockScope blockScope) {
        this.addRealFragment(instanceOfExpression);
        return false;
    }

    public boolean visit(IntLiteral intLiteral, BlockScope blockScope) {
        this.addSmallFragment(intLiteral);
        return false;
    }

    public boolean visit(ListExpression listExpression, BlockScope blockScope) {
        this.addRealFragment(listExpression);
        return false;
    }

    public boolean visit(LongLiteral longLiteral, BlockScope blockScope) {
        this.addSmallFragment(longLiteral);
        return false;
    }

    public boolean visit(MessageSend messageSend, BlockScope blockScope) {
        this.addRealFragment(messageSend);
        return false;
    }

    public boolean visit(StringLiteralConcatenation stringLiteralConcatenation, BlockScope blockScope) {
        if ((stringLiteralConcatenation.bits & 0x1FE00000) >> 21 != 0) {
            this.addRealFragment(stringLiteralConcatenation);
            return false;
        }
        int n = 0;
        int n2 = stringLiteralConcatenation.counter;
        while (n < n2) {
            this.addRealFragment(stringLiteralConcatenation.literals[n]);
            if (n < n2 - 1) {
                this.operatorsList.add(new Integer(1));
            }
            ++n;
        }
        return false;
    }

    public boolean visit(NullLiteral nullLiteral, BlockScope blockScope) {
        this.addRealFragment(nullLiteral);
        return false;
    }

    public boolean visit(OR_OR_Expression oR_OR_Expression, BlockScope blockScope) {
        if ((oR_OR_Expression.bits & 0x1FE00000) >> 21 != 0) {
            this.addRealFragment(oR_OR_Expression);
        } else {
            oR_OR_Expression.left.traverse((ASTVisitor)this, blockScope);
            this.operatorsList.add(new Integer(29));
            oR_OR_Expression.right.traverse((ASTVisitor)this, blockScope);
        }
        return false;
    }

    public boolean visit(PostfixExpression postfixExpression, BlockScope blockScope) {
        this.addRealFragment(postfixExpression);
        return false;
    }

    public boolean visit(PrefixExpression prefixExpression, BlockScope blockScope) {
        this.addRealFragment(prefixExpression);
        return false;
    }

    public boolean visit(RegExLiteral regExLiteral, BlockScope blockScope) {
        this.addSmallFragment(regExLiteral);
        return false;
    }

    public boolean visit(QualifiedAllocationExpression qualifiedAllocationExpression, BlockScope blockScope) {
        this.addRealFragment(qualifiedAllocationExpression);
        return false;
    }

    public boolean visit(QualifiedNameReference qualifiedNameReference, BlockScope blockScope) {
        this.addRealFragment(qualifiedNameReference);
        return false;
    }

    public boolean visit(QualifiedSuperReference qualifiedSuperReference, BlockScope blockScope) {
        this.addRealFragment(qualifiedSuperReference);
        return false;
    }

    public boolean visit(QualifiedThisReference qualifiedThisReference, BlockScope blockScope) {
        this.addRealFragment(qualifiedThisReference);
        return false;
    }

    public boolean visit(SingleNameReference singleNameReference, BlockScope blockScope) {
        this.addRealFragment(singleNameReference);
        return false;
    }

    public boolean visit(StringLiteral stringLiteral, BlockScope blockScope) {
        this.addRealFragment(stringLiteral);
        return false;
    }

    public boolean visit(SuperReference superReference, BlockScope blockScope) {
        this.addRealFragment(superReference);
        return false;
    }

    public boolean visit(ThisReference thisReference, BlockScope blockScope) {
        this.addRealFragment(thisReference);
        return false;
    }

    public boolean visit(TrueLiteral trueLiteral, BlockScope blockScope) {
        this.addSmallFragment(trueLiteral);
        return false;
    }

    public boolean visit(UnaryExpression unaryExpression, BlockScope blockScope) {
        this.addRealFragment(unaryExpression);
        return false;
    }

    public int size() {
        return this.fragmentsList.size();
    }
}

