/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.formatter.comment;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.wst.jsdt.internal.formatter.CodeFormatterVisitor;
import org.eclipse.wst.jsdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.wst.jsdt.internal.formatter.Scribe;
import org.eclipse.wst.jsdt.internal.formatter.comment.CommentFormatterUtil;
import org.eclipse.wst.jsdt.internal.formatter.comment.CommentLine;
import org.eclipse.wst.jsdt.internal.formatter.comment.CommentRange;
import org.eclipse.wst.jsdt.internal.formatter.comment.IBorderAttributes;
import org.eclipse.wst.jsdt.internal.formatter.comment.ICommentAttributes;
import org.eclipse.wst.jsdt.internal.formatter.comment.IHtmlTagDelimiters;
import org.eclipse.wst.jsdt.internal.formatter.comment.SingleCommentLine;

public class CommentRegion
extends Position
implements IHtmlTagDelimiters,
IBorderAttributes,
ICommentAttributes {
    protected static final String COMMENT_RANGE_DELIMITER = " ";
    private static final int COMMENT_PREFIX_LENGTH = 3;
    private int fBorders = 0;
    protected boolean fClear;
    private final String fDelimiter;
    private final IDocument fDocument;
    private final LinkedList fLines = new LinkedList();
    protected final DefaultCodeFormatterOptions preferences;
    private final LinkedList fRanges = new LinkedList();
    private final boolean fSingleLine;
    private int fTabSize;
    protected Scribe scribe;

    public CommentRegion(IDocument iDocument, Position position, CodeFormatterVisitor codeFormatterVisitor) {
        super(position.getOffset(), position.getLength());
        this.preferences = codeFormatterVisitor.preferences;
        this.fDelimiter = this.preferences.line_separator;
        this.fDocument = iDocument;
        this.fTabSize = 2 == this.preferences.tab_char ? this.preferences.indentation_size : this.preferences.tab_size;
        this.scribe = codeFormatterVisitor.scribe;
        DefaultLineTracker defaultLineTracker = new DefaultLineTracker();
        IRegion iRegion = null;
        CommentLine commentLine = null;
        defaultLineTracker.set(this.getText(0, this.getLength()));
        int n = defaultLineTracker.getNumberOfLines();
        this.fSingleLine = n == 1;
        try {
            int n2 = 0;
            while (n2 < n) {
                iRegion = defaultLineTracker.getLineInformation(n2);
                commentLine = this.createLine();
                commentLine.append(new CommentRange(iRegion.getOffset(), iRegion.getLength()));
                this.fLines.add(commentLine);
                ++n2;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    protected final void append(CommentRange commentRange) {
        this.fRanges.addLast(commentRange);
    }

    protected boolean canAppend(CommentLine commentLine, CommentRange commentRange, CommentRange commentRange2, int n, int n2) {
        return n == 0 || n + commentRange2.getLength() <= n2;
    }

    protected boolean canFormat(CommentRange commentRange, CommentRange commentRange2) {
        return commentRange != null;
    }

    public final TextEdit format(int n, boolean bl) {
        String string = this.getText(0, "/*-".length());
        if (!string.startsWith("/*-")) {
            int n2 = this.preferences.comment_line_length;
            String string2 = this.computeIndentation(n);
            n2 = Math.max(4, n2 - this.stringToLength(string2) - 3);
            this.tokenizeRegion();
            this.markRegion();
            this.wrapRegion(n2);
            this.formatRegion(string2, n2);
        }
        if (bl) {
            return this.scribe.getRootEdit();
        }
        return null;
    }

    protected void formatRegion(String string, int n) {
        int n2 = this.fLines.size() - 1;
        if (n2 >= 0) {
            CommentLine commentLine = (CommentLine)this.fLines.get(n2);
            CommentRange commentRange = commentLine.getLast();
            commentLine.formatLowerBorder(commentRange, string, n);
            CommentLine commentLine2 = null;
            CommentRange commentRange2 = null;
            int n3 = n2;
            while (n3 >= 0) {
                CommentLine commentLine3 = commentLine2;
                commentLine2 = (CommentLine)this.fLines.get(n3);
                commentRange2 = commentLine2.formatLine(commentLine3, commentRange2, string, n3);
                --n3;
            }
            commentLine2.formatUpperBorder(commentRange2, string, n);
        }
    }

    protected final String getDelimiter() {
        return this.fDelimiter;
    }

    protected String getDelimiter(CommentLine commentLine, CommentLine commentLine2, CommentRange commentRange, CommentRange commentRange2, String string) {
        return String.valueOf(this.fDelimiter) + string + commentLine2.getContentPrefix();
    }

    protected String getDelimiter(CommentRange commentRange, CommentRange commentRange2) {
        return COMMENT_RANGE_DELIMITER;
    }

    protected final IDocument getDocument() {
        return this.fDocument;
    }

    protected final LinkedList getRanges() {
        return this.fRanges;
    }

    protected final int getSize() {
        return this.fLines.size();
    }

    protected final String getText(int n, int n2) {
        String string = "";
        try {
            string = this.fDocument.get(this.getOffset() + n, n2);
        }
        catch (BadLocationException badLocationException) {}
        return string;
    }

    protected final boolean hasBorder(int n) {
        return (this.fBorders & n) == n;
    }

    protected final boolean isAlphaNumeric(CommentRange commentRange) {
        String string = this.getText(commentRange.getOffset(), commentRange.getLength());
        int n = 0;
        while (n < string.length()) {
            if (!ScannerHelper.isLetterOrDigit(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected final boolean isNonAlphaNumeric(CommentRange commentRange) {
        String string = this.getText(commentRange.getOffset(), commentRange.getLength());
        int n = 0;
        while (n < string.length()) {
            if (ScannerHelper.isLetterOrDigit(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected final boolean isClearLines() {
        return this.fClear;
    }

    protected final boolean isSingleLine() {
        return this.fSingleLine;
    }

    protected final void logEdit(String string, int n, int n2) {
        try {
            int n3 = this.getOffset() + n;
            String string2 = this.fDocument.get(n3, n2);
            if (!string.equals(string2)) {
                if (n2 > 0) {
                    this.scribe.addReplaceEdit(n3, n3 + n2 - 1, string);
                } else {
                    this.scribe.addInsertEdit(n3, string);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            CommentFormatterUtil.log(badLocationException);
        }
        catch (MalformedTreeException malformedTreeException) {
            CommentFormatterUtil.log(malformedTreeException);
        }
    }

    protected void markRegion() {
    }

    protected final void setBorder(int n) {
        this.fBorders |= n;
    }

    private String computeIndentation(int n) {
        if (1 == this.preferences.tab_char) {
            return this.replicate("\t", n);
        }
        if (2 == this.preferences.tab_char) {
            return this.replicate(COMMENT_RANGE_DELIMITER, n * this.preferences.tab_size);
        }
        if (4 == this.preferences.tab_char) {
            int n2 = this.preferences.tab_size;
            int n3 = this.preferences.indentation_size;
            int n4 = n * n3;
            return String.valueOf(this.replicate("\t", n4 / n2)) + this.replicate(COMMENT_RANGE_DELIMITER, n4 % n2);
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private String replicate(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(n * string.length());
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(string);
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected final String stringToIndent(String string) {
        return this.replicate(COMMENT_RANGE_DELIMITER, this.stringToLength(string));
    }

    protected final int stringToLength(String string) {
        return this.expandTabs(string).length();
    }

    private String expandTabs(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n < n2) {
            char c = string.charAt(n);
            if (c == '\t') {
                while (n3 < this.fTabSize) {
                    stringBuffer.append(' ');
                    ++n3;
                }
                n3 = 0;
            } else {
                stringBuffer.append(c);
                if (++n3 >= this.fTabSize) {
                    n3 = 0;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected void tokenizeRegion() {
        int n = 0;
        CommentLine commentLine = null;
        Iterator iterator = this.fLines.iterator();
        while (iterator.hasNext()) {
            commentLine = (CommentLine)iterator.next();
            commentLine.scanLine(n);
            commentLine.tokenizeLine(n);
            ++n;
        }
    }

    protected void wrapRegion(int n) {
        this.fLines.clear();
        int n2 = 0;
        boolean bl = false;
        CommentLine commentLine = null;
        CommentLine commentLine2 = null;
        CommentRange commentRange = null;
        CommentRange commentRange2 = null;
        block0: while (!this.fRanges.isEmpty()) {
            n2 = 0;
            bl = false;
            commentLine2 = commentLine;
            commentLine = this.createLine();
            this.fLines.add(commentLine);
            while (!this.fRanges.isEmpty()) {
                commentRange2 = (CommentRange)this.fRanges.getFirst();
                if (!this.canAppend(commentLine, commentRange, commentRange2, n2, n)) continue block0;
                if (!bl && commentLine2 != null) {
                    commentLine.adapt(commentLine2);
                    bl = true;
                }
                this.fRanges.removeFirst();
                commentLine.append(commentRange2);
                n2 += commentRange2.getLength() + 1;
                commentRange = commentRange2;
            }
        }
    }

    protected CommentLine createLine() {
        return new SingleCommentLine(this);
    }
}

