/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.formatter.comment;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.wst.jsdt.internal.formatter.CodeFormatterVisitor;
import org.eclipse.wst.jsdt.internal.formatter.comment.CommentLine;
import org.eclipse.wst.jsdt.internal.formatter.comment.CommentRange;
import org.eclipse.wst.jsdt.internal.formatter.comment.CommentRegion;
import org.eclipse.wst.jsdt.internal.formatter.comment.IJavaDocTagConstants;
import org.eclipse.wst.jsdt.internal.formatter.comment.MultiCommentLine;

public class MultiCommentRegion
extends CommentRegion
implements IJavaDocTagConstants {
    private final boolean fIndentDescriptions;
    private final boolean fIndentRoots;
    private final boolean fParameterNewLine;
    private boolean fSeparateRoots;

    public MultiCommentRegion(IDocument iDocument, Position position, CodeFormatterVisitor codeFormatterVisitor) {
        super(iDocument, position, codeFormatterVisitor);
        this.fIndentRoots = this.preferences.comment_indent_root_tags;
        this.fIndentDescriptions = this.preferences.comment_indent_parameter_description;
        this.fSeparateRoots = this.preferences.comment_insert_empty_line_before_root_tags;
        this.fParameterNewLine = this.preferences.comment_insert_new_line_for_parameter;
        this.fClear = this.preferences.comment_clear_blank_lines_in_block_comment;
    }

    protected boolean canAppend(CommentLine commentLine, CommentRange commentRange, CommentRange commentRange2, int n, int n2) {
        boolean bl = commentRange2.hasAttribute(2);
        if (commentRange2.getLength() <= 2 && !bl && this.isNonAlphaNumeric(commentRange2)) {
            return true;
        }
        if (this.fParameterNewLine && commentLine.hasAttribute(1024) && commentLine.getSize() > 1) {
            return false;
        }
        if (commentRange != null) {
            if (n != 0 && (bl || commentRange.hasAttribute(2) || commentRange2.hasAttribute(1024) || commentRange2.hasAttribute(2048) || commentRange2.hasAttribute(4096) || commentRange2.hasAttribute(128) || commentRange.hasAttribute(4) || commentRange.hasAttribute(4096))) {
                return false;
            }
            if (commentRange.hasAttribute(2048)) {
                return true;
            }
            if (commentRange2.hasAttribute(64) && commentRange.hasAttribute(64)) {
                return true;
            }
        }
        if (!commentRange2.hasAttribute(16384)) {
            return true;
        }
        if (this.fIndentRoots && !commentLine.hasAttribute(2048) && !commentLine.hasAttribute(1024)) {
            n2 -= this.stringToLength(commentLine.getIndentationReference());
        }
        if (commentRange2.hasAttribute(64) && (commentRange == null || !commentRange.hasAttribute(64))) {
            Iterator iterator = this.getRanges().iterator();
            CommentRange commentRange3 = null;
            while (iterator.hasNext() && commentRange3 != commentRange2) {
                commentRange3 = (CommentRange)iterator.next();
            }
            if (commentRange3 != null && iterator.hasNext()) {
                try {
                    int n3 = this.getDocument().getLineOfOffset(this.getOffset() + commentRange3.getOffset());
                    CommentRange commentRange4 = commentRange3;
                    while (iterator.hasNext()) {
                        commentRange3 = (CommentRange)iterator.next();
                        if (!commentRange3.hasAttribute(64) || this.getDocument().getLineOfOffset(this.getOffset() + commentRange3.getOffset()) != n3) break;
                        commentRange4 = commentRange3;
                    }
                    n2 -= commentRange4.getOffset() + commentRange4.getLength() - (commentRange2.getOffset() + commentRange2.getLength());
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return super.canAppend(commentLine, commentRange, commentRange2, n, n2);
    }

    protected String getDelimiter(CommentLine commentLine, CommentLine commentLine2, CommentRange commentRange, CommentRange commentRange2, String string) {
        String string2 = super.getDelimiter(commentLine, commentLine2, commentRange, commentRange2, string);
        if (commentRange != null) {
            if (commentRange.hasAttribute(4160) && !commentRange2.hasAttribute(16) && !commentLine2.hasAttribute(2)) {
                return String.valueOf(string2) + string2;
            }
            if (commentRange2.hasAttribute(4160) && !commentLine2.hasAttribute(2) && !commentLine.hasAttribute(2)) {
                return String.valueOf(string2) + string2;
            }
            if (this.fSeparateRoots && commentRange.hasAttribute(512) && !commentLine2.hasAttribute(2) && !commentLine.hasAttribute(2)) {
                return String.valueOf(string2) + string2;
            }
            if (this.fIndentRoots && !commentLine.hasAttribute(2048) && !commentLine.hasAttribute(1024) && !commentLine.hasAttribute(2)) {
                return String.valueOf(string2) + this.stringToIndent(commentLine.getIndentationReference());
            }
        }
        return string2;
    }

    protected String getDelimiter(CommentRange commentRange, CommentRange commentRange2) {
        if (commentRange != null && !commentRange.hasAttribute(16384)) {
            return "";
        }
        return super.getDelimiter(commentRange, commentRange2);
    }

    protected final boolean isIndentDescriptions() {
        return this.fIndentDescriptions;
    }

    protected final boolean isIndentRoots() {
        return this.fIndentRoots;
    }

    protected void markHtmlRanges() {
    }

    protected void markHtmlTag(CommentRange commentRange, char[] cArray) {
    }

    protected void markJavadocTag(CommentRange commentRange, char[] cArray) {
        commentRange.markPrefixTag(COMMENT_ROOT_TAGS, '@', cArray, 2048);
    }

    protected void markRegion() {
        int n = 0;
        boolean bl = false;
        char[] cArray = null;
        CommentRange commentRange = null;
        ListIterator listIterator = this.getRanges().listIterator();
        while (listIterator.hasNext()) {
            commentRange = (CommentRange)listIterator.next();
            n = commentRange.getLength();
            if (n <= 0) continue;
            cArray = this.getText(commentRange.getOffset(), n).toLowerCase().toCharArray();
            this.markJavadocTag(commentRange, cArray);
            if (!bl && (commentRange.hasAttribute(2048) || commentRange.hasAttribute(1024))) {
                commentRange.setAttribute(512);
                bl = true;
            }
            this.markHtmlTag(commentRange, cArray);
        }
        this.markHtmlRanges();
    }

    protected CommentLine createLine() {
        return new MultiCommentLine(this);
    }
}

