/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.core;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentFormatter {
    private static Pattern INTERNAL_SCRIPT_START = Pattern.compile("<SCRIPT class=\"___ATF_INTERNAL", 34);
    private static Pattern INTERNAL_SCRIPT_END = Pattern.compile("</SCRIPT>", 34);
    private static Pattern INTERNAL_DIV_START = Pattern.compile("<DIV class=\"___ATF_INTERNAL", 34);
    private static Pattern INTERNAL_DIV_END = Pattern.compile("</DIV>", 34);

    public static String format(String body, String formatType) {
        String formatted = body;
        if (formatType.indexOf("xml") != -1 || formatType.indexOf("html") != -1 || body.startsWith("<")) {
            formatted = ContentFormatter.formatXML(body);
        } else if (formatType.indexOf("json") != -1 || body.startsWith("{") || body.startsWith("[")) {
            formatted = ContentFormatter.formatJSON(body);
        }
        return formatted;
    }

    private static String formatXML(String body) {
        body = body.replace('\r', '\n');
        body = body.replace('\f', ' ');
        body = body.replace('\t', ' ');
        StringBuffer sb = new StringBuffer(body);
        int level = 0;
        boolean removePreceeding = false;
        boolean removeInternal = false;
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '>') {
                removePreceeding = true;
                removeInternal = false;
            } else if (sb.charAt(i) == '<') {
                while (i - 1 > 0 && (sb.charAt(i - 1) == ' ' || sb.charAt(i - 1) == '\n')) {
                    sb.deleteCharAt(i - 1);
                    --i;
                }
                removePreceeding = false;
                removeInternal = true;
            } else if (removePreceeding && (sb.charAt(i) == '\n' || sb.charAt(i) == ' ')) {
                sb = sb.deleteCharAt(i);
                --i;
            } else if (removeInternal && sb.charAt(i) == '\n') {
                sb = sb.replace(i, i + 1, " ");
            } else {
                removePreceeding = false;
            }
            ++i;
        }
        i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '<' && i > 0) {
                sb.insert(i, '\n');
                ++i;
            } else if (i + 1 < sb.length() && sb.charAt(i) == '>' && sb.charAt(i + 1) != '<') {
                sb.insert(i + 1, '\n');
                ++i;
            }
            ++i;
        }
        int prev_level = level;
        int i2 = 0;
        while (i2 < sb.length()) {
            int tabs;
            if (i2 + 3 < sb.length() && sb.charAt(i2) == '<' && sb.charAt(i2 + 1) == '!' && sb.charAt(i2 + 2) == '-' && sb.charAt(i2 + 3) == '-') {
                i2 += 3;
                prev_level = level;
            } else if (i2 + 2 < sb.length() && sb.charAt(i2) == '-' && sb.charAt(i2 + 1) == '-' && sb.charAt(i2 + 2) == '>') {
                level = prev_level;
                i2 += 2;
            }
            if (i2 + 1 < sb.length() && sb.charAt(i2) == '<' && sb.charAt(i2 + 1) != '/' && sb.charAt(i2 + 1) != '!') {
                tabs = 0;
                while (tabs < level) {
                    sb.insert(i2, '\t');
                    ++i2;
                    ++tabs;
                }
                ++level;
            } else if (i2 + 1 < sb.length() && sb.charAt(i2) == '<' && sb.charAt(i2 + 1) == '/') {
                --level;
                tabs = 0;
                while (tabs < level) {
                    sb.insert(i2, '\t');
                    ++i2;
                    ++tabs;
                }
            } else if (i2 + 1 < sb.length() && sb.charAt(i2) == '/' && sb.charAt(i2 + 1) == '>') {
                --level;
            } else if (i2 + 1 < sb.length() && sb.charAt(i2) == '\n' && sb.charAt(i2 + 1) != '<' || i2 + 2 < sb.length() && sb.charAt(i2 + 1) == '<' && sb.charAt(i2 + 2) == '!') {
                tabs = 0;
                while (tabs < level) {
                    sb.insert(i2 + 1, '\t');
                    ++i2;
                    ++tabs;
                }
            }
            ++i2;
        }
        return sb.toString();
    }

    private static String formatJSON(String body) {
        StringBuffer sb = new StringBuffer(body);
        boolean waitQuotes = false;
        int level = 0;
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '\"' && i > 0 && sb.charAt(i) != '\\') {
                waitQuotes = !waitQuotes;
            } else if (!(waitQuotes || sb.charAt(i) != '\n' && sb.charAt(i) != '\t')) {
                sb.deleteCharAt(i);
                --i;
            }
            ++i;
        }
        waitQuotes = false;
        i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '\"' && i > 0 && sb.charAt(i) != '\\') {
                waitQuotes = !waitQuotes;
            } else if (!waitQuotes) {
                int tabs;
                if (sb.charAt(i) == ' ') {
                    sb.deleteCharAt(i);
                    --i;
                } else if (i + 1 < sb.length() && sb.charAt(i) == '{') {
                    ++level;
                    sb.insert(i + 1, "\n");
                    ++i;
                    tabs = 0;
                    while (tabs < level) {
                        sb.insert(i + 1, '\t');
                        ++i;
                        ++tabs;
                    }
                } else if (sb.charAt(i) == '}') {
                    --level;
                    sb.insert(i, "\n");
                    ++i;
                    tabs = 0;
                    while (tabs < level) {
                        sb.insert(i, '\t');
                        ++i;
                        ++tabs;
                    }
                } else if (sb.charAt(i) == ',') {
                    sb.insert(i + 1, "\n");
                    ++i;
                    tabs = 0;
                    while (tabs < level) {
                        sb.insert(i + 1, '\t');
                        ++i;
                        ++tabs;
                    }
                } else if (sb.charAt(i) == '[') {
                    ++level;
                    sb.insert(i + 1, "\n");
                    ++i;
                    tabs = 0;
                    while (tabs < level) {
                        sb.insert(i + 1, '\t');
                        ++i;
                        ++tabs;
                    }
                } else if (i - 1 > 0 && sb.charAt(i) == ']') {
                    --level;
                    sb.insert(i, "\n");
                    ++i;
                    tabs = 0;
                    while (tabs < level) {
                        sb.insert(i, '\t');
                        ++i;
                        ++tabs;
                    }
                } else if (sb.charAt(i) == '\n') {
                    tabs = 0;
                    while (tabs < level) {
                        sb.insert(i + 1, '\t');
                        ++i;
                        ++tabs;
                    }
                } else if (sb.charAt(i) == ':') {
                    sb.insert(i + 1, ' ');
                    ++i;
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String removeFlashingDiv(String htmlNode) {
        return ContentFormatter.removeInternalNode(INTERNAL_DIV_START, INTERNAL_DIV_END, htmlNode);
    }

    public static String removeInternalScriptNode(String htmlNode) {
        return ContentFormatter.removeInternalNode(INTERNAL_SCRIPT_START, INTERNAL_SCRIPT_END, htmlNode);
    }

    private static String removeInternalNode(Pattern start, Pattern end, String htmlNode) {
        Matcher startM = start.matcher(htmlNode);
        Matcher endM = end.matcher(htmlNode);
        ArrayList<int[]> regions = new ArrayList<int[]>();
        while (startM.find()) {
            int startIdx = startM.start();
            int endIdx = -1;
            if (!endM.find(startIdx)) continue;
            endIdx = endM.end();
            regions.add(new int[]{startIdx, endIdx});
        }
        StringBuffer sb = new StringBuffer(htmlNode);
        int i = regions.size() - 1;
        while (i >= 0) {
            int startIdx = ((int[])regions.get(i))[0];
            int endIdx = ((int[])regions.get(i))[1];
            sb.replace(startIdx, endIdx, "");
            --i;
        }
        return sb.toString();
    }
}

