/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class XULRunnerInitializer {
    static String[] bundles = new String[]{"org.mozilla.xulrunner", "org.mozilla.xulrunner.win32.win32.x86", "org.mozilla.xulrunner.carbon.macosx", "org.mozilla.xulrunner.gtk.linux.x86"};
    static final String PLUGIN_ID = "org.eclipse.atf.mozilla.swt.browser";
    static final String XULRUNNER_PATH = "org.eclipse.swt.browser.XULRunnerPath";

    static {
        XULRunnerInitializer.initialize();
    }

    private static void initialize() {
        URL url = null;
        int i = 0;
        while (i < bundles.length && url == null) {
            Bundle bundle = Platform.getBundle((String)bundles[i]);
            if (bundle != null) {
                url = bundle.getResource("/xulrunner");
            }
            ++i;
        }
        if (url == null) {
            XULRunnerInitializer.log((IStatus)new Status(4, PLUGIN_ID, "XULRunner not found", null));
            return;
        }
        File xulRunnerRoot = null;
        try {
            URL localPath = FileLocator.resolve(url);
            xulRunnerRoot = new File(FileLocator.toFileURL((URL)localPath).getFile());
        }
        catch (IOException e) {
            XULRunnerInitializer.log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e));
        }
        if (xulRunnerRoot != null) {
            System.setProperty(XULRUNNER_PATH, xulRunnerRoot.getAbsolutePath());
        }
    }

    private static void log(IStatus status) {
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        Platform.getLog((Bundle)bundle).log(status);
    }
}

