/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.browser;

import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.atf.mozilla.ide.events.ApplicationEvent;
import org.eclipse.atf.mozilla.ide.events.DOMDocumentEvent;
import org.eclipse.atf.mozilla.ide.events.DOMDocumentListener;
import org.eclipse.atf.mozilla.ide.events.DOMMutationEvent;
import org.eclipse.atf.mozilla.ide.events.IApplicationEvent;
import org.eclipse.atf.mozilla.ide.events.IApplicationEventAdmin;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.mozilla.interfaces.nsIDOMMutationEvent;

public class DOMEventsPublisher
extends DOMDocumentListener {
    public static final String prefix = "org.eclipse.atf.mozilla.ide.ui.browser.DOMEventsPublisher";
    public static final String LOCATION_CHANGED = "org.eclipse.atf.mozilla.ide.ui.browser.DOMEventsPublisher.locationChanged";
    private IWebBrowser browser;

    public DOMEventsPublisher(IWebBrowser browser) {
        this.browser = browser;
    }

    public void locationChanged(String newLocation) {
        ApplicationEvent aevent = new ApplicationEvent(this.browser, LOCATION_CHANGED, null, (Object)newLocation, System.currentTimeMillis(), 0L);
        IApplicationEventAdmin adm = MozIDEUIPlugin.getDefault().getApplicationEventAdmin();
        adm.sendEvent((IApplicationEvent)aevent);
    }

    public void documentLoaded(DOMDocumentEvent event) {
        IApplicationEventAdmin adm = MozIDEUIPlugin.getDefault().getApplicationEventAdmin();
        adm.sendEvent((IApplicationEvent)event);
    }

    public void documentUnloaded(DOMDocumentEvent event) {
        IApplicationEventAdmin adm = MozIDEUIPlugin.getDefault().getApplicationEventAdmin();
        adm.sendEvent((IApplicationEvent)event);
    }

    public void fireAttributeRemoved(nsIDOMMutationEvent event) {
        DOMMutationEvent aevent = DOMMutationEvent.attributeRemoved((IWebBrowser)this.browser, (nsIDOMMutationEvent)event);
        IApplicationEventAdmin adm = MozIDEUIPlugin.getDefault().getApplicationEventAdmin();
        adm.sendEvent((IApplicationEvent)aevent);
    }

    public void fireAttributeModified(nsIDOMMutationEvent event) {
        DOMMutationEvent aevent = DOMMutationEvent.attributeModified((IWebBrowser)this.browser, (nsIDOMMutationEvent)event);
        IApplicationEventAdmin adm = MozIDEUIPlugin.getDefault().getApplicationEventAdmin();
        adm.sendEvent((IApplicationEvent)aevent);
    }

    public void fireAttributeAdded(nsIDOMMutationEvent event) {
        DOMMutationEvent aevent = DOMMutationEvent.attributeAdded((IWebBrowser)this.browser, (nsIDOMMutationEvent)event);
        IApplicationEventAdmin adm = MozIDEUIPlugin.getDefault().getApplicationEventAdmin();
        adm.sendEvent((IApplicationEvent)aevent);
    }

    public void fireNodeRemoved(nsIDOMMutationEvent event) {
        DOMMutationEvent aevent = DOMMutationEvent.nodeRemoved((IWebBrowser)this.browser, (nsIDOMMutationEvent)event);
        IApplicationEventAdmin adm = MozIDEUIPlugin.getDefault().getApplicationEventAdmin();
        adm.sendEvent((IApplicationEvent)aevent);
    }

    public void fireNodeInserted(nsIDOMMutationEvent event) {
        DOMMutationEvent aevent = DOMMutationEvent.nodeInserted((IWebBrowser)this.browser, (nsIDOMMutationEvent)event);
        IApplicationEventAdmin adm = MozIDEUIPlugin.getDefault().getApplicationEventAdmin();
        adm.sendEvent((IApplicationEvent)aevent);
    }

    public void dispose() {
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().dispose(this.browser);
    }
}

