/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.browser.toolbar;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.browser.toolbar.BrowserToolbar;
import org.eclipse.atf.mozilla.ide.ui.browser.toolbar.NavigationBar;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ToolbarExtensionManager {
    public static final String TOOLBAR_POINT = "org.eclipse.atf.mozilla.ide.ui.toolbar";
    public static final String TOOLBAR_NODE = "toolbar";
    public static final String NAME_ATTR = "name";
    public static final String BROWSER_ATTR = "browser";
    public static final String ICON_ATTR = "icon";
    public static final String SHOW_ATTR = "show";
    public static final String CLASS_ATTR = "class";
    public static final String TOOLTIP_PREFIX = "Toggles the visibility of the ";
    public static final String MENUTEXT_PREFIX = "Show ";
    private static List configurables = null;

    public static List create(NavigationBar navBar, Composite displayArea, IWebBrowser container) {
        if (configurables == null) {
            ToolbarExtensionManager.fillConfigurables();
        }
        ArrayList<BrowserToolbar> toolbars = new ArrayList<BrowserToolbar>();
        int i = 0;
        while (i < configurables.size()) {
            block9: {
                IConfigurationElement ce = (IConfigurationElement)configurables.get(i);
                String name = ce.getAttribute(NAME_ATTR);
                String browser = ce.getAttribute(BROWSER_ATTR);
                String icon = ce.getAttribute(ICON_ATTR);
                String show = ce.getAttribute(SHOW_ATTR);
                if (name != null && browser != null && container.getType().getType().equals(browser)) {
                    try {
                        String tooltip = TOOLTIP_PREFIX + name;
                        String menuText = MENUTEXT_PREFIX + name;
                        Object item = ce.createExecutableExtension(CLASS_ATTR);
                        if (!(item instanceof BrowserToolbar)) break block9;
                        BrowserToolbar tb = (BrowserToolbar)item;
                        tb.createControl(displayArea);
                        tb.setBrowser(container);
                        Action action = new Action(menuText, 2, tb){
                            private final BrowserToolbar toolbar;
                            {
                                this.toolbar = browserToolbar;
                            }

                            public void run() {
                                this.toolbar.show(this.isChecked());
                            }
                        };
                        tb.setAction(action);
                        if (show != null) {
                            try {
                                action.setChecked(Boolean.valueOf(show).booleanValue());
                                tb.show(Boolean.valueOf(show));
                            }
                            catch (Exception exception) {}
                        }
                        if (icon != null) {
                            String pluginID = ce.getContributor().getName();
                            action.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginID, (String)icon));
                        }
                        action.setToolTipText(tooltip);
                        navBar.addMenuExtensionAction((IAction)action);
                        toolbars.add(tb);
                    }
                    catch (Exception e) {
                        MozIDEUIPlugin.log(e);
                    }
                }
            }
            ++i;
        }
        return toolbars;
    }

    private static void fillConfigurables() {
        configurables = new ArrayList();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint(TOOLBAR_POINT);
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] ce = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < ce.length) {
                if (ce[j].getName().equals(TOOLBAR_NODE) && ce[j].getAttribute(NAME_ATTR) != null && ce[j].getAttribute(BROWSER_ATTR) != null) {
                    configurables.add(ce[j]);
                }
                ++j;
            }
            ++i;
        }
    }
}

