/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.browser.util;

import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.browser.MozBrowserEditor;
import org.eclipse.atf.mozilla.ide.ui.browser.MozBrowserEditorInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.ide.IDE;

public class MozBrowserUtil {
    public static final String SWITCH_TO_WEB_DEVELOPMENT_PERSPECTIVE = "switch_to_web_development_perspective";

    public static IWebBrowser openMozillaBrowser(String url, IWorkbenchPage page) throws CoreException {
        MozBrowserEditorInput editorInput = new MozBrowserEditorInput(url);
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)editorInput, (String)"org.eclipse.atf.mozilla.ide.ui.MozBrowserEditor");
        if (editor instanceof MozBrowserEditor) {
            return (MozBrowserEditor)editor;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.ui", 4, "Error opening Mozilla Browser... EditorPart did not initialize properly!", null));
    }

    public static IWebBrowser openMozillaBrowser(String url) throws CoreException {
        IWorkbenchWindow activeWindow = MozIDEUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.ui", 4, "Error opening Mozilla Browser... failed to retrieve active workbench window!", null));
        }
        IWorkbenchPage activePage = activeWindow.getActivePage();
        if (activePage == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.ui", 4, "Error opening Mozilla Browser... could not retrieve active page!", null));
        }
        return MozBrowserUtil.openMozillaBrowser(url, activePage);
    }

    public static void openMozillaPerspective() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            MessageDialogWithToggle toggle;
            IPerspectiveDescriptor descr;
            String currentPerspective = null;
            IWorkbenchPage page = window.getActivePage();
            if (page != null && (descr = page.getPerspective()) != null) {
                currentPerspective = descr.getId();
            }
            if ("org.eclipse.atf.mozilla.ide.ui.perspective".equals(currentPerspective)) {
                return;
            }
            IPreferenceStore store = MozIDEUIPlugin.getDefault().getPreferenceStore();
            if (!store.contains(SWITCH_TO_WEB_DEVELOPMENT_PERSPECTIVE) ? (toggle = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)"Open Associated Perspective?", (String)"This kind of launch is configured to open the Web Browser Tools perspective.\n\nThis Web Browser Tools perspective provides additional views for inspecting browser internals such as Document Object Model, network events, JavaScript, Cascading Style Sheets definitions and more.\n\nDo you want to open this perspective now?", null, (boolean)false, (IPreferenceStore)store, (String)SWITCH_TO_WEB_DEVELOPMENT_PERSPECTIVE)).getReturnCode() != 2 : "never".equals(store.getString(SWITCH_TO_WEB_DEVELOPMENT_PERSPECTIVE))) {
                return;
            }
            try {
                PlatformUI.getWorkbench().showPerspective("org.eclipse.atf.mozilla.ide.ui.perspective", window);
            }
            catch (WorkbenchException e) {
                MozIDEUIPlugin.log(e);
            }
        }
    }
}

